/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.commands;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillTools;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.text.StringUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class CommandUtils {
    public static final List<String> TRUE_FALSE_OPTIONS = ImmutableList.of((Object)"on", (Object)"off", (Object)"true", (Object)"false", (Object)"enabled", (Object)"disabled");
    public static final List<String> RESET_OPTIONS = ImmutableList.of((Object)"clear", (Object)"reset");

    private CommandUtils() {
    }

    public static boolean isChildSkill(CommandSender sender, PrimarySkillType skill) {
        if (skill == null || !SkillTools.isChildSkill(skill)) {
            return false;
        }
        sender.sendMessage("Child skills are not supported by this command.");
        return true;
    }

    public static boolean tooFar(CommandSender sender, Player target, boolean hasPermission) {
        if (!target.isOnline() && !hasPermission) {
            sender.sendMessage(LocaleLoader.getString("Inspect.Offline"));
            return true;
        }
        if (sender instanceof Player && !Misc.isNear(((Player)sender).getLocation(), target.getLocation(), mcMMO.p.getGeneralConfig().getInspectDistance()) && !hasPermission) {
            sender.sendMessage(LocaleLoader.getString("Inspect.TooFar"));
            return true;
        }
        return false;
    }

    public static boolean hidden(CommandSender sender, Player target, boolean hasPermission) {
        return sender instanceof Player && !((Player)sender).canSee(target) && !hasPermission;
    }

    public static boolean noConsoleUsage(CommandSender sender) {
        if (sender instanceof Player) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.NoConsole"));
        return true;
    }

    public static boolean isOffline(CommandSender sender, OfflinePlayer player) {
        if (player.isOnline()) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Offline"));
        return true;
    }

    public static boolean checkPlayerExistence(CommandSender sender, String playerName, McMMOPlayer mcMMOPlayer) {
        if (mcMMOPlayer != null) {
            if (CommandUtils.hidden(sender, mcMMOPlayer.getPlayer(), false)) {
                sender.sendMessage(LocaleLoader.getString("Commands.Offline"));
                return false;
            }
            return true;
        }
        PlayerProfile profile = new PlayerProfile(playerName, false, 0);
        if (CommandUtils.unloadedProfile(sender, profile)) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.DoesNotExist"));
        return false;
    }

    public static boolean unloadedProfile(CommandSender sender, PlayerProfile profile) {
        if (profile.isLoaded()) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Offline"));
        return true;
    }

    public static boolean hasPlayerDataKey(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return false;
        }
        boolean hasPlayerDataKey = ((Player)sender).hasMetadata("mcMMO: Player Data");
        if (!hasPlayerDataKey) {
            sender.sendMessage(LocaleLoader.getString("Commands.NotLoaded"));
        }
        return hasPlayerDataKey;
    }

    public static boolean isLoaded(CommandSender sender, PlayerProfile profile) {
        if (profile.isLoaded()) {
            return true;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.NotLoaded"));
        return false;
    }

    public static boolean isInvalidInteger(CommandSender sender, String value) {
        if (StringUtils.isInt(value)) {
            return false;
        }
        sender.sendMessage("That is not a valid integer.");
        return true;
    }

    public static boolean isInvalidDouble(CommandSender sender, String value) {
        if (StringUtils.isDouble(value)) {
            return false;
        }
        sender.sendMessage("That is not a valid percentage.");
        return true;
    }

    public static boolean isInvalidSkill(CommandSender sender, String skillName) {
        if (SkillUtils.isSkill(skillName)) {
            return false;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Skill.Invalid"));
        return true;
    }

    public static boolean shouldEnableToggle(String arg) {
        return arg.equalsIgnoreCase("on") || arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("enabled");
    }

    public static boolean shouldDisableToggle(String arg) {
        return arg.equalsIgnoreCase("off") || arg.equalsIgnoreCase("false") || arg.equalsIgnoreCase("disabled");
    }

    public static void printGatheringSkills(Player inspect, CommandSender display) {
        CommandUtils.printGroupedSkillData(inspect, display, LocaleLoader.getString("Stats.Header.Gathering"), mcMMO.p.getSkillTools().GATHERING_SKILLS);
    }

    public static void printGatheringSkills(Player player) {
        CommandUtils.printGatheringSkills(player, (CommandSender)player);
    }

    public static void printCombatSkills(Player inspect, CommandSender display) {
        CommandUtils.printGroupedSkillData(inspect, display, LocaleLoader.getString("Stats.Header.Combat"), mcMMO.p.getSkillTools().COMBAT_SKILLS);
    }

    public static void printCombatSkills(Player player) {
        CommandUtils.printCombatSkills(player, (CommandSender)player);
    }

    public static void printMiscSkills(Player inspect, CommandSender display) {
        CommandUtils.printGroupedSkillData(inspect, display, LocaleLoader.getString("Stats.Header.Misc"), mcMMO.p.getSkillTools().getMiscSkills());
    }

    public static void printMiscSkills(Player player) {
        CommandUtils.printMiscSkills(player, (CommandSender)player);
    }

    public static String displaySkill(PlayerProfile profile, PrimarySkillType skill) {
        if (SkillTools.isChildSkill(skill)) {
            return LocaleLoader.getString("Skills.ChildStats", LocaleLoader.getString(StringUtils.getCapitalized(skill.toString()) + ".Listener") + " ", profile.getSkillLevel(skill));
        }
        if (profile.getSkillLevel(skill) == mcMMO.p.getSkillTools().getLevelCap(skill)) {
            return LocaleLoader.getString("Skills.Stats", LocaleLoader.getString(StringUtils.getCapitalized(skill.toString()) + ".Listener") + " ", profile.getSkillLevel(skill), profile.getSkillXpLevel(skill), LocaleLoader.getString("Skills.MaxXP"));
        }
        return LocaleLoader.getString("Skills.Stats", LocaleLoader.getString(StringUtils.getCapitalized(skill.toString()) + ".Listener") + " ", profile.getSkillLevel(skill), profile.getSkillXpLevel(skill), profile.getXpToLevel(skill));
    }

    private static void printGroupedSkillData(Player inspectTarget, CommandSender display, String header, List<PrimarySkillType> skillGroup) {
        if (UserManager.getPlayer(inspectTarget) == null) {
            return;
        }
        PlayerProfile profile = UserManager.getPlayer(inspectTarget).getProfile();
        ArrayList<String> displayData = new ArrayList<String>();
        displayData.add(header);
        for (PrimarySkillType primarySkillType : skillGroup) {
            if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(inspectTarget, primarySkillType)) continue;
            displayData.add(CommandUtils.displaySkill(profile, primarySkillType));
        }
        int size = displayData.size();
        if (size > 1) {
            display.sendMessage(displayData.toArray(new String[size]));
        }
    }

    public static List<String> getOnlinePlayerNames(CommandSender sender) {
        Player player = sender instanceof Player ? (Player)sender : null;
        ArrayList<String> onlinePlayerNames = new ArrayList<String>();
        for (Player onlinePlayer : mcMMO.p.getServer().getOnlinePlayers()) {
            if (player == null || !player.canSee(onlinePlayer)) continue;
            onlinePlayerNames.add(onlinePlayer.getName());
        }
        return onlinePlayerNames;
    }

    public static String getMatchedPlayerName(String partialName) {
        if (mcMMO.p.getGeneralConfig().getMatchOfflinePlayers()) {
            List<String> matches = CommandUtils.matchPlayer(partialName);
            if (matches.size() == 1) {
                partialName = matches.get(0);
            }
        } else {
            Player player = mcMMO.p.getServer().getPlayer(partialName);
            if (player != null) {
                partialName = player.getName();
            }
        }
        return partialName;
    }

    private static List<String> matchPlayer(String partialName) {
        ArrayList<String> matchedPlayers = new ArrayList<String>();
        for (OfflinePlayer offlinePlayer : mcMMO.p.getServer().getOfflinePlayers()) {
            String playerName = offlinePlayer.getName();
            if (playerName == null) {
                System.err.println("[McMMO] Player data file with UIID " + String.valueOf(offlinePlayer.getUniqueId()) + " is missing a player name. This may be a legacy file from before bukkit.lastKnownName. This should be okay to ignore.");
                continue;
            }
            if (partialName.equalsIgnoreCase(playerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(playerName);
                break;
            }
            if (!playerName.toLowerCase(Locale.ENGLISH).contains(partialName.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(playerName);
        }
        return matchedPlayers;
    }
}

