/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.meta.OldName;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.metadata.MobMetaFlagType;
import com.gmail.nossr50.runnables.skills.AwardCombatXpTask;
import com.gmail.nossr50.skills.acrobatics.AcrobaticsManager;
import com.gmail.nossr50.skills.archery.ArcheryManager;
import com.gmail.nossr50.skills.axes.AxesManager;
import com.gmail.nossr50.skills.maces.MacesManager;
import com.gmail.nossr50.skills.swords.SwordsManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.tridents.TridentsManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.util.AttributeMapper;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.MetadataConstants;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.MobHealthbarUtils;
import com.gmail.nossr50.util.MobMetadataUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.ProjectileUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Trident;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CombatUtils {
    private static final ThreadLocal<Boolean> IN_MCMO_DAMAGE = ThreadLocal.withInitial(() -> false);

    public static void safeDealDamage(@NotNull LivingEntity target, double amount) {
        CombatUtils.safeDealDamage(target, amount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeDealDamage(@NotNull LivingEntity target, double amount, @Nullable Entity attacker) {
        boolean prev = IN_MCMO_DAMAGE.get();
        if (prev || target.isDead()) {
            return;
        }
        try {
            IN_MCMO_DAMAGE.set(true);
            if (!CombatUtils.hasIgnoreDamageMetadata(target)) {
                CombatUtils.applyIgnoreDamageMetadata(target);
            }
            if (attacker != null) {
                target.damage(amount, attacker);
            } else {
                target.damage(amount);
            }
        }
        finally {
            IN_MCMO_DAMAGE.set(false);
            if (CombatUtils.hasIgnoreDamageMetadata(target)) {
                CombatUtils.removeIgnoreDamageMetadata(target);
            }
        }
    }

    private CombatUtils() {
    }

    @Deprecated(forRemoval=true, since="2.2.039")
    public static boolean isDamageLikelyFromNormalCombat(@NotNull EntityDamageEvent.DamageCause damageCause) {
        return switch (damageCause) {
            case EntityDamageEvent.DamageCause.ENTITY_ATTACK, EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK, EntityDamageEvent.DamageCause.PROJECTILE -> true;
            default -> false;
        };
    }

    @Deprecated(forRemoval=true, since="2.2.039")
    public static boolean hasWeakenedDamage(@NotNull LivingEntity livingEntity) {
        return livingEntity.hasPotionEffect(PotionEffectType.WEAKNESS);
    }

    private static void processSwordCombat(@NotNull LivingEntity target, @NotNull Player player, @NotNull EntityDamageByEntityEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        SwordsManager swordsManager = mcMMOPlayer.getSwordsManager();
        double boostedDamage = event.getDamage();
        if (swordsManager.canActivateAbility()) {
            mcMMOPlayer.checkAbilityActivation(PrimarySkillType.SWORDS);
        }
        if (swordsManager.canUseStab()) {
            boostedDamage += swordsManager.getStabDamage() * mcMMOPlayer.getAttackStrength();
        }
        if (swordsManager.canUseSerratedStrike()) {
            swordsManager.serratedStrikes(target, event.getDamage());
        }
        if (CombatUtils.canUseLimitBreak(player, target, SubSkillType.SWORDS_SWORDS_LIMIT_BREAK)) {
            boostedDamage += (double)CombatUtils.getLimitBreakDamage(player, target, SubSkillType.SWORDS_SWORDS_LIMIT_BREAK) * mcMMOPlayer.getAttackStrength();
        }
        event.setDamage(boostedDamage);
        if (target.getHealth() - event.getFinalDamage() > 0.0) {
            swordsManager.processRupture(target);
        }
        CombatUtils.processCombatXP(mcMMOPlayer, target, PrimarySkillType.SWORDS);
        CombatUtils.printFinalDamageDebug(player, event, mcMMOPlayer, new String[0]);
    }

    private static void printFinalDamageDebug(@NotNull Player player, @NotNull EntityDamageByEntityEvent event, @NotNull McMMOPlayer mcMMOPlayer, String ... extraInfoLines) {
        if (mcMMOPlayer.isDebugMode()) {
            player.sendMessage("Final Damage value after mcMMO modifiers: " + event.getFinalDamage());
            player.sendMessage("Your current attack strength: " + player.getAttackCooldown());
            if (extraInfoLines != null) {
                for (String str : extraInfoLines) {
                    if (str == null) continue;
                    player.sendMessage(str);
                }
            }
        }
    }

    private static void processTridentCombatMelee(@NotNull LivingEntity target, @NotNull Player player, @NotNull EntityDamageByEntityEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        double boostedDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        TridentsManager tridentsManager = mcMMOPlayer.getTridentsManager();
        if (SkillUtils.canUseSubskill(player, SubSkillType.TRIDENTS_IMPALE)) {
            boostedDamage += tridentsManager.impaleDamageBonus() * mcMMOPlayer.getAttackStrength();
        }
        if (CombatUtils.canUseLimitBreak(player, target, SubSkillType.TRIDENTS_TRIDENTS_LIMIT_BREAK)) {
            boostedDamage += (double)CombatUtils.getLimitBreakDamage(player, target, SubSkillType.TRIDENTS_TRIDENTS_LIMIT_BREAK) * mcMMOPlayer.getAttackStrength();
        }
        event.setDamage(boostedDamage);
        CombatUtils.processCombatXP(mcMMOPlayer, target, PrimarySkillType.TRIDENTS);
        CombatUtils.printFinalDamageDebug(player, event, mcMMOPlayer, new String[0]);
    }

    private static void processTridentCombatRanged(@NotNull Trident trident, @NotNull LivingEntity target, @NotNull Player player, @NotNull EntityDamageByEntityEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        double boostedDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        TridentsManager tridentsManager = mcMMOPlayer.getTridentsManager();
        if (SkillUtils.canUseSubskill(player, SubSkillType.TRIDENTS_IMPALE)) {
            boostedDamage += tridentsManager.impaleDamageBonus();
        }
        if (CombatUtils.canUseLimitBreak(player, target, SubSkillType.TRIDENTS_TRIDENTS_LIMIT_BREAK)) {
            boostedDamage += (double)CombatUtils.getLimitBreakDamage(player, target, SubSkillType.TRIDENTS_TRIDENTS_LIMIT_BREAK);
        }
        event.setDamage(boostedDamage);
        CombatUtils.processCombatXP(mcMMOPlayer, target, PrimarySkillType.TRIDENTS);
        CombatUtils.printFinalDamageDebug(player, event, mcMMOPlayer, new String[0]);
    }

    private static void processCrossbowsCombat(@NotNull LivingEntity target, @NotNull Player player, @NotNull EntityDamageByEntityEvent event, @NotNull AbstractArrow arrow) {
        double initialDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            CombatUtils.delayArrowMetaCleanup(arrow);
            return;
        }
        double boostedDamage = event.getDamage();
        if (SkillUtils.canUseSubskill(player, SubSkillType.CROSSBOWS_POWERED_SHOT)) {
            boostedDamage = mcMMOPlayer.getCrossbowsManager().poweredShot(initialDamage);
        }
        if (CombatUtils.canUseLimitBreak(player, target, SubSkillType.CROSSBOWS_CROSSBOWS_LIMIT_BREAK)) {
            boostedDamage += (double)CombatUtils.getLimitBreakDamage(player, target, SubSkillType.CROSSBOWS_CROSSBOWS_LIMIT_BREAK);
        }
        double distanceMultiplier = ArcheryManager.distanceXpBonusMultiplier(target, (Entity)arrow);
        double forceMultiplier = 1.0;
        event.setDamage(boostedDamage);
        CombatUtils.processCombatXP(mcMMOPlayer, target, PrimarySkillType.CROSSBOWS, forceMultiplier * distanceMultiplier);
        CombatUtils.printFinalDamageDebug(player, event, mcMMOPlayer, "Distance Multiplier: " + distanceMultiplier, "Force Multiplier: " + forceMultiplier, "Initial Damage: " + initialDamage, "Final Damage: " + boostedDamage);
        CombatUtils.delayArrowMetaCleanup(arrow);
    }

    private static void processMacesCombat(@NotNull LivingEntity target, @NotNull Player player, @NotNull EntityDamageByEntityEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        double boostedDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        MacesManager macesManager = mcMMOPlayer.getMacesManager();
        if (CombatUtils.canUseLimitBreak(player, target, SubSkillType.MACES_MACES_LIMIT_BREAK)) {
            boostedDamage += (double)CombatUtils.getLimitBreakDamage(player, target, SubSkillType.MACES_MACES_LIMIT_BREAK) * mcMMOPlayer.getAttackStrength();
        }
        event.setDamage(boostedDamage += macesManager.getCrushDamage() * mcMMOPlayer.getAttackStrength());
        if (target.getHealth() - event.getFinalDamage() > 0.0) {
            macesManager.processCripple(target);
        }
        CombatUtils.processCombatXP(mcMMOPlayer, target, PrimarySkillType.MACES);
        CombatUtils.printFinalDamageDebug(player, event, mcMMOPlayer, new String[0]);
    }

    private static void processAxeCombat(@NotNull LivingEntity target, @NotNull Player player, @NotNull EntityDamageByEntityEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        double boostedDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        AxesManager axesManager = mcMMOPlayer.getAxesManager();
        if (axesManager.canActivateAbility()) {
            mcMMOPlayer.checkAbilityActivation(PrimarySkillType.AXES);
        }
        if (axesManager.canUseAxeMastery()) {
            boostedDamage += axesManager.axeMastery() * mcMMOPlayer.getAttackStrength();
        }
        if (axesManager.canImpact(target)) {
            axesManager.impactCheck(target);
        } else if (axesManager.canGreaterImpact(target)) {
            boostedDamage += axesManager.greaterImpact(target) * mcMMOPlayer.getAttackStrength();
        }
        if (axesManager.canUseSkullSplitter(target)) {
            axesManager.skullSplitterCheck(target, event.getDamage());
        }
        if (axesManager.canCriticalHit(target)) {
            boostedDamage += axesManager.criticalHit(target, boostedDamage) * mcMMOPlayer.getAttackStrength();
        }
        if (CombatUtils.canUseLimitBreak(player, target, SubSkillType.AXES_AXES_LIMIT_BREAK)) {
            boostedDamage += (double)CombatUtils.getLimitBreakDamage(player, target, SubSkillType.AXES_AXES_LIMIT_BREAK) * mcMMOPlayer.getAttackStrength();
        }
        event.setDamage(boostedDamage);
        CombatUtils.processCombatXP(mcMMOPlayer, target, PrimarySkillType.AXES);
        CombatUtils.printFinalDamageDebug(player, event, mcMMOPlayer, new String[0]);
    }

    private static void processUnarmedCombat(@NotNull LivingEntity target, @NotNull Player player, @NotNull EntityDamageByEntityEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        double boostedDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        UnarmedManager unarmedManager = mcMMOPlayer.getUnarmedManager();
        if (unarmedManager.canActivateAbility()) {
            mcMMOPlayer.checkAbilityActivation(PrimarySkillType.UNARMED);
        }
        if (unarmedManager.canUseSteelArm()) {
            boostedDamage += unarmedManager.calculateSteelArmStyleDamage() * mcMMOPlayer.getAttackStrength();
        }
        if (unarmedManager.canUseBerserk()) {
            boostedDamage += unarmedManager.berserkDamage(boostedDamage) * mcMMOPlayer.getAttackStrength();
        }
        if (unarmedManager.canDisarm(target)) {
            unarmedManager.disarmCheck((Player)target);
        }
        if (CombatUtils.canUseLimitBreak(player, target, SubSkillType.UNARMED_UNARMED_LIMIT_BREAK)) {
            boostedDamage += (double)CombatUtils.getLimitBreakDamage(player, target, SubSkillType.UNARMED_UNARMED_LIMIT_BREAK) * mcMMOPlayer.getAttackStrength();
        }
        event.setDamage(boostedDamage);
        CombatUtils.processCombatXP(mcMMOPlayer, target, PrimarySkillType.UNARMED);
        CombatUtils.printFinalDamageDebug(player, event, mcMMOPlayer, new String[0]);
    }

    private static void processTamingCombat(@NotNull LivingEntity target, @Nullable Player master, @NotNull Wolf wolf, @NotNull EntityDamageByEntityEvent event) {
        double initialDamage;
        double boostedDamage = initialDamage = event.getDamage();
        if (master != null && master.isOnline() && master.isValid()) {
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(master);
            if (mcMMOPlayer == null) {
                return;
            }
            TamingManager tamingManager = mcMMOPlayer.getTamingManager();
            if (tamingManager.canUseFastFoodService()) {
                tamingManager.fastFoodService(wolf, event.getDamage());
            }
            tamingManager.pummel(target, wolf);
            if (tamingManager.canUseSharpenedClaws()) {
                boostedDamage += tamingManager.sharpenedClaws();
            }
            if (tamingManager.canUseGore()) {
                boostedDamage += tamingManager.gore(target, initialDamage);
            }
            event.setDamage(boostedDamage);
            CombatUtils.processCombatXP(mcMMOPlayer, target, PrimarySkillType.TAMING, 3.0);
        }
    }

    private static void processArcheryCombat(@NotNull LivingEntity target, @NotNull Player player, @NotNull EntityDamageByEntityEvent event, @NotNull AbstractArrow arrow) {
        double initialDamage = event.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            CombatUtils.delayArrowMetaCleanup(arrow);
            return;
        }
        ArcheryManager archeryManager = mcMMOPlayer.getArcheryManager();
        double boostedDamage = event.getDamage();
        if (archeryManager.canSkillShot()) {
            boostedDamage = archeryManager.skillShot(initialDamage);
        }
        if (archeryManager.canDaze(target)) {
            boostedDamage += archeryManager.daze((Player)target);
        }
        if (!arrow.hasMetadata("mcMMO: Infinite Arrow") && archeryManager.canRetrieveArrows()) {
            archeryManager.retrieveArrows(target, (Projectile)arrow);
        }
        if (CombatUtils.canUseLimitBreak(player, target, SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK)) {
            boostedDamage += (double)CombatUtils.getLimitBreakDamage(player, target, SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK);
        }
        double distanceMultiplier = ArcheryManager.distanceXpBonusMultiplier(target, (Entity)arrow);
        double forceMultiplier = 1.0;
        if (arrow.hasMetadata("mcMMO: Bow Force")) {
            forceMultiplier = ((MetadataValue)arrow.getMetadata("mcMMO: Bow Force").get(0)).asDouble();
        }
        event.setDamage(boostedDamage);
        CombatUtils.processCombatXP(mcMMOPlayer, target, PrimarySkillType.ARCHERY, forceMultiplier * distanceMultiplier);
        CombatUtils.printFinalDamageDebug(player, event, mcMMOPlayer, "Distance Multiplier: " + distanceMultiplier, "Force Multiplier: " + forceMultiplier, "Initial Damage: " + initialDamage, "Final Damage: " + boostedDamage);
        CombatUtils.delayArrowMetaCleanup(arrow);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void processCombatAttack(@NotNull EntityDamageByEntityEvent event, @NotNull Entity painSourceRoot, @NotNull LivingEntity target) {
        Player player;
        block30: {
            AbstractArrow arrow;
            block29: {
                ProjectileSource projectileSource;
                Player player2;
                Entity painSource = event.getDamager();
                EntityType entityType = painSource.getType();
                if (target instanceof ArmorStand) {
                    return;
                }
                if (target instanceof Player) {
                    player2 = (Player)target;
                    if (ExperienceConfig.getInstance().isNPCInteractionPrevented() && Misc.isNPCEntityExcludingVillagers((Entity)target)) {
                        return;
                    }
                    if (!UserManager.hasPlayerDataKey((Entity)player2)) {
                        return;
                    }
                    McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player2);
                    AcrobaticsManager acrobaticsManager = mcMMOPlayer.getAcrobaticsManager();
                    if (acrobaticsManager.canDodge((Entity)target)) {
                        event.setDamage(acrobaticsManager.dodgeCheck(painSourceRoot, event.getDamage()));
                    }
                    if (ItemUtils.isSword(player2.getInventory().getItemInMainHand())) {
                        if (!mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.SWORDS, (Entity)target)) {
                            return;
                        }
                        SwordsManager swordsManager = mcMMOPlayer.getSwordsManager();
                        if (swordsManager.canUseCounterAttack(painSource)) {
                            swordsManager.counterAttackChecks((LivingEntity)painSource, event.getDamage());
                        }
                    }
                }
                if (painSourceRoot instanceof Player) {
                    player2 = (Player)painSourceRoot;
                    if (entityType == EntityType.PLAYER) {
                        if (!UserManager.hasPlayerDataKey((Entity)player2)) {
                            return;
                        }
                        ItemStack heldItem = player2.getInventory().getItemInMainHand();
                        if (target instanceof Tameable) {
                            TamingManager tamingManager;
                            if (heldItem.getType() == Material.BONE && (tamingManager = UserManager.getPlayer(player2).getTamingManager()).canUseBeastLore()) {
                                tamingManager.beastLore(target);
                                event.setCancelled(true);
                                return;
                            }
                            if (CombatUtils.isFriendlyPet(player2, (Tameable)target)) {
                                return;
                            }
                        }
                        if (ItemUtils.isSword(heldItem)) {
                            if (!mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.SWORDS, (Entity)target)) {
                                return;
                            }
                            if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player2, PrimarySkillType.SWORDS)) return;
                            CombatUtils.processSwordCombat(target, player2, event);
                            return;
                        }
                        if (ItemUtils.isAxe(heldItem)) {
                            if (!mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.AXES, (Entity)target)) {
                                return;
                            }
                            if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player2, PrimarySkillType.AXES)) return;
                            CombatUtils.processAxeCombat(target, player2, event);
                            return;
                        }
                        if (ItemUtils.isUnarmed(heldItem)) {
                            if (!mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.UNARMED, (Entity)target)) {
                                return;
                            }
                            if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player2, PrimarySkillType.UNARMED)) return;
                            CombatUtils.processUnarmedCombat(target, player2, event);
                            return;
                        }
                        if (ItemUtils.isTrident(heldItem)) {
                            if (!mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.TRIDENTS, (Entity)target)) {
                                return;
                            }
                            if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player2, PrimarySkillType.TRIDENTS)) return;
                            CombatUtils.processTridentCombatMelee(target, player2, event);
                            return;
                        }
                        if (!ItemUtils.isMace(heldItem)) return;
                        if (!mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.MACES, (Entity)target)) {
                            return;
                        }
                        if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player2, PrimarySkillType.MACES)) return;
                        CombatUtils.processMacesCombat(target, player2, event);
                        return;
                    }
                }
                if (entityType == EntityType.WOLF) {
                    Wolf wolf = (Wolf)painSource;
                    AnimalTamer tamer = wolf.getOwner();
                    if (!(tamer instanceof Player)) return;
                    Player master = (Player)tamer;
                    if (!mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.TAMING, (Entity)target)) return;
                    if (Misc.isNPCEntityExcludingVillagers((Entity)master)) return;
                    if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(master, PrimarySkillType.TAMING)) return;
                    CombatUtils.processTamingCombat(target, master, wolf, event);
                    return;
                }
                if (painSource instanceof Trident) {
                    Trident trident = (Trident)painSource;
                    projectileSource = trident.getShooter();
                    if (!(projectileSource instanceof Player)) return;
                    Player player3 = (Player)projectileSource;
                    if (Misc.isNPCEntityExcludingVillagers((Entity)player3)) return;
                    if (!mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.TRIDENTS, (Entity)target)) return;
                    CombatUtils.processTridentCombatRanged(trident, target, player3, event);
                    return;
                }
                if (!(painSource instanceof AbstractArrow)) return;
                arrow = (AbstractArrow)painSource;
                projectileSource = arrow.getShooter();
                boolean isCrossbow = ProjectileUtils.isCrossbowProjectile(arrow);
                if (!(projectileSource instanceof Player)) return;
                player = (Player)projectileSource;
                if (Misc.isNPCEntityExcludingVillagers((Entity)player)) break block29;
                if (!isCrossbow && mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.ARCHERY, (Entity)target)) {
                    CombatUtils.processArcheryCombat(target, player, event, arrow);
                    break block30;
                } else if (isCrossbow && mcMMO.p.getSkillTools().canCombatSkillsTrigger(PrimarySkillType.CROSSBOWS, (Entity)target)) {
                    CombatUtils.processCrossbowsCombat(target, player, event, arrow);
                }
                break block30;
            }
            CombatUtils.delayArrowMetaCleanup(arrow);
        }
        if (target.getType() == EntityType.CREEPER) return;
        if (Misc.isNPCEntityExcludingVillagers((Entity)player)) return;
        if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.TAMING)) return;
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        TamingManager tamingManager = mcMMOPlayer.getTamingManager();
        tamingManager.attackTarget(target);
    }

    public static void fixNames(@NotNull LivingEntity entity) {
        List metadataValue = entity.getMetadata("mcmmo_old_name");
        if (metadataValue.size() <= 0) {
            return;
        }
        OldName oldName = (OldName)((Object)metadataValue.get(0));
        entity.setCustomName(oldName.asString());
        entity.setCustomNameVisible(false);
        entity.removeMetadata("mcmmo_old_name", (Plugin)mcMMO.p);
    }

    public static int getLimitBreakDamage(@NotNull Player attacker, @NotNull LivingEntity defender, @NotNull SubSkillType subSkillType) {
        if (defender instanceof Player) {
            Player playerDefender = (Player)defender;
            return CombatUtils.getLimitBreakDamageAgainstQuality(attacker, subSkillType, CombatUtils.getArmorQualityLevel(playerDefender));
        }
        return CombatUtils.getLimitBreakDamageAgainstQuality(attacker, subSkillType, 1000);
    }

    public static int getLimitBreakDamageAgainstQuality(@NotNull Player attacker, @NotNull SubSkillType subSkillType, int armorQualityLevel) {
        float rawDamageBoost = RankUtils.getRank(attacker, subSkillType);
        if (armorQualityLevel <= 4) {
            rawDamageBoost *= 0.25f;
        } else if (armorQualityLevel <= 8) {
            rawDamageBoost *= 0.5f;
        } else if (armorQualityLevel <= 12) {
            rawDamageBoost *= 0.75f;
        }
        return (int)rawDamageBoost;
    }

    public static int getArmorQualityLevel(@NotNull Player defender) {
        int armorQualityLevel = 0;
        for (ItemStack itemStack : defender.getInventory().getArmorContents()) {
            if (itemStack == null) continue;
            armorQualityLevel += CombatUtils.getArmorQuality(itemStack);
        }
        return armorQualityLevel;
    }

    private static int getArmorQuality(@NotNull ItemStack itemStack) {
        return mcMMO.getMaterialMapStore().getTier(itemStack.getType().getKey().getKey());
    }

    public static boolean canUseLimitBreak(@NotNull Player player, LivingEntity target, @NotNull SubSkillType subSkillType) {
        if (target instanceof Player || mcMMO.p.getAdvancedConfig().canApplyLimitBreakPVE()) {
            return RankUtils.hasUnlockedSubskill(player, subSkillType) && Permissions.isSubSkillEnabled((Permissible)player, subSkillType);
        }
        return false;
    }

    @Deprecated(since="2.2.039")
    public static void dealDamage(@NotNull LivingEntity target, double damage) {
        CombatUtils.safeDealDamage(target, damage, null);
    }

    @Deprecated(since="2.2.039")
    public static void dealDamage(@NotNull LivingEntity target, double damage, @Nullable Entity attacker) {
        CombatUtils.safeDealDamage(target, damage, attacker);
    }

    public static void removeIgnoreDamageMetadata(@NotNull LivingEntity target) {
        target.removeMetadata("mcMMO: Custom Damage", (Plugin)mcMMO.p);
    }

    public static void applyIgnoreDamageMetadata(@NotNull LivingEntity target) {
        target.setMetadata("mcMMO: Custom Damage", (MetadataValue)MetadataConstants.MCMMO_METADATA_VALUE);
    }

    public static boolean hasIgnoreDamageMetadata(@NotNull LivingEntity target) {
        return target.hasMetadata("mcMMO: Custom Damage");
    }

    public static void applyAbilityAoE(@NotNull Player attacker, @NotNull LivingEntity target, double damage, @NotNull PrimarySkillType type) {
        int numberOfTargets = CombatUtils.getTier(attacker.getInventory().getItemInMainHand());
        double damageAmount = Math.max(damage, 1.0);
        for (Entity entity : target.getNearbyEntities(2.5, 2.5, 2.5)) {
            if (numberOfTargets <= 0) break;
            if (ExperienceConfig.getInstance().isNPCInteractionPrevented() && Misc.isNPCEntityExcludingVillagers(entity) || !(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!CombatUtils.shouldBeAffected(attacker, entity)) continue;
            switch (type) {
                case SWORDS: {
                    McMMOPlayer mmoAttacker;
                    if (entity instanceof Player) {
                        NotificationManager.sendPlayerInformation((Player)entity, NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.SS.Struck");
                    }
                    if ((mmoAttacker = UserManager.getPlayer(attacker)) == null) break;
                    mmoAttacker.getSwordsManager().processRupture(livingEntity);
                    break;
                }
                case AXES: {
                    if (!(entity instanceof Player)) break;
                    NotificationManager.sendPlayerInformation((Player)entity, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.SS.Struck");
                    break;
                }
            }
            CombatUtils.safeDealDamage(livingEntity, damageAmount, (Entity)attacker);
            --numberOfTargets;
        }
    }

    public static void processCombatXP(@NotNull McMMOPlayer mcMMOPlayer, @NotNull LivingEntity target, @NotNull PrimarySkillType primarySkillType) {
        CombatUtils.processCombatXP(mcMMOPlayer, target, primarySkillType, 1.0);
    }

    public static void processCombatXP(@NotNull McMMOPlayer mcMMOPlayer, @NotNull LivingEntity target, @NotNull PrimarySkillType primarySkillType, double multiplier) {
        XPGainReason xpGainReason;
        double baseXP = 0.0;
        if (target instanceof Player) {
            Player defender = (Player)target;
            if (!ExperienceConfig.getInstance().getExperienceGainsPlayerVersusPlayerEnabled() || mcMMO.p.getPartyConfig().isPartyEnabled() && mcMMO.p.getPartyManager().inSameParty(mcMMOPlayer.getPlayer(), (Player)target)) {
                return;
            }
            xpGainReason = XPGainReason.PVP;
            if (defender.isOnline() && SkillUtils.cooldownExpired(mcMMOPlayer.getRespawnATS(), 5)) {
                baseXP = 20.0 * ExperienceConfig.getInstance().getPlayerVersusPlayerXP();
            }
        } else {
            if (target instanceof Animals) {
                EntityType type = target.getType();
                baseXP = ExperienceConfig.getInstance().getAnimalsXP(type);
            } else if (target instanceof Monster) {
                EntityType type = target.getType();
                baseXP = ExperienceConfig.getInstance().getCombatXP(type);
            } else {
                EntityType type = target.getType();
                if (ExperienceConfig.getInstance().hasCombatXP(type)) {
                    if (type == EntityType.IRON_GOLEM) {
                        if (!((IronGolem)target).isPlayerCreated()) {
                            baseXP = ExperienceConfig.getInstance().getCombatXP(type);
                        }
                    } else {
                        baseXP = ExperienceConfig.getInstance().getCombatXP(type);
                    }
                } else {
                    baseXP = 1.0;
                }
            }
            if (MobMetadataUtils.hasMobFlag(MobMetaFlagType.COTW_SUMMONED_MOB, target)) {
                baseXP = 0.0;
            } else if (MobMetadataUtils.hasMobFlag(MobMetaFlagType.MOB_SPAWNER_MOB, target) || target.hasMetadata("ES")) {
                baseXP *= ExperienceConfig.getInstance().getSpawnedMobXpMultiplier();
            } else if (MobMetadataUtils.hasMobFlag(MobMetaFlagType.NETHER_PORTAL_MOB, target)) {
                baseXP *= ExperienceConfig.getInstance().getNetherPortalXpMultiplier();
            } else if (MobMetadataUtils.hasMobFlag(MobMetaFlagType.EGG_MOB, target)) {
                baseXP *= ExperienceConfig.getInstance().getEggXpMultiplier();
            } else if (MobMetadataUtils.hasMobFlag(MobMetaFlagType.PLAYER_BRED_MOB, target)) {
                baseXP *= ExperienceConfig.getInstance().getBredMobXpMultiplier();
            } else if (MobMetadataUtils.hasMobFlag(MobMetaFlagType.PLAYER_TAMED_MOB, target)) {
                baseXP *= ExperienceConfig.getInstance().getTamedMobXpMultiplier();
            }
            baseXP *= 10.0;
            xpGainReason = XPGainReason.PVE;
        }
        if ((baseXP *= multiplier) > 0.0) {
            mcMMO.p.getFoliaLib().getScheduler().runAtEntity((Entity)target, (Consumer)new AwardCombatXpTask(mcMMOPlayer, primarySkillType, baseXP, target, xpGainReason));
        }
    }

    private static boolean shouldBeAffected(@NotNull Player player, @NotNull Entity entity) {
        Tameable tameableEntity;
        if (entity instanceof Player) {
            Player defender = (Player)entity;
            if (UserManager.getPlayer(defender) == null) {
                return true;
            }
            if (!defender.getWorld().getPVP() || defender == player || UserManager.getPlayer(defender).getGodMode()) {
                return false;
            }
            if (!(!mcMMO.p.getPartyConfig().isPartyEnabled() || !mcMMO.p.getPartyManager().inSameParty(player, defender) && !mcMMO.p.getPartyManager().areAllies(player, defender) || Permissions.friendlyFire((Permissible)player) && Permissions.friendlyFire((Permissible)defender))) {
                return false;
            }
            if (!player.canSee(defender)) {
                return false;
            }
            return defender.getGameMode() != GameMode.SPECTATOR;
        }
        if (entity instanceof Tameable && CombatUtils.isFriendlyPet(player, tameableEntity = (Tameable)entity)) {
            Player owner = (Player)tameableEntity.getOwner();
            return Permissions.friendlyFire((Permissible)player) && Permissions.friendlyFire((Permissible)owner);
        }
        return true;
    }

    public static boolean isInvincible(@NotNull LivingEntity entity, double eventDamage) {
        return (float)entity.getNoDamageTicks() > (float)entity.getMaximumNoDamageTicks() / 2.0f && eventDamage <= entity.getLastDamage();
    }

    public static boolean isFriendlyPet(@NotNull Player attacker, @NotNull Tameable pet) {
        AnimalTamer tamer;
        if (pet.isTamed() && (tamer = pet.getOwner()) instanceof Player) {
            Player owner = (Player)tamer;
            return owner == attacker || mcMMO.p.getPartyConfig().isPartyEnabled() && (mcMMO.p.getPartyManager().inSameParty(attacker, owner) || mcMMO.p.getPartyManager().areAllies(attacker, owner));
        }
        return false;
    }

    private static int getTier(@NotNull ItemStack inHand) {
        int tier = 0;
        if (ItemUtils.isWoodTool(inHand)) {
            tier = 1;
        } else if (ItemUtils.isStoneTool(inHand)) {
            tier = 2;
        } else if (ItemUtils.isIronTool(inHand)) {
            tier = 3;
        } else if (ItemUtils.isGoldTool(inHand)) {
            tier = 1;
        } else if (ItemUtils.isDiamondTool(inHand)) {
            tier = 4;
        } else if (ItemUtils.isNetheriteTool(inHand)) {
            tier = 5;
        }
        return tier;
    }

    public static void handleHealthbars(@NotNull Entity attacker, @NotNull LivingEntity target, double damage, @NotNull mcMMO plugin) {
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        if (Misc.isNPCEntityExcludingVillagers((Entity)player) || Misc.isNPCEntityExcludingVillagers((Entity)target)) {
            return;
        }
        if (!player.hasMetadata("mcMMO: Player Data")) {
            return;
        }
        MobHealthbarUtils.handleMobHealthbars(target, damage, plugin);
    }

    @Deprecated(forRemoval=true, since="2.2.039")
    public static void modifyMoveSpeed(@NotNull LivingEntity livingEntity, double multiplier) {
        AttributeInstance attributeInstance = livingEntity.getAttribute(AttributeMapper.MAPPED_MOVEMENT_SPEED);
        if (attributeInstance != null) {
            double normalSpeed = attributeInstance.getBaseValue();
            attributeInstance.setBaseValue(normalSpeed * multiplier);
        }
    }

    public static void delayArrowMetaCleanup(@NotNull AbstractArrow arrow) {
        mcMMO.p.getFoliaLib().getScheduler().runLater(() -> ProjectileUtils.cleanupProjectileMetadata(arrow), 2400L);
    }
}

