/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerProfileLoadingTask;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Misc {
    @NotNull
    private static final Random random = new Random();
    public static final int TIME_CONVERSION_FACTOR = 1000;
    public static final int TICK_CONVERSION_FACTOR = 20;
    public static final int PLAYER_RESPAWN_COOLDOWN_SECONDS = 5;
    public static final double SKILL_MESSAGE_MAX_SENDING_DISTANCE = 10.0;
    @NotNull
    public static final Set<String> modNames = ImmutableSet.of((Object)"LOTR", (Object)"BUILDCRAFT", (Object)"ENDERIO", (Object)"ENHANCEDBIOMES", (Object)"IC2", (Object)"METALLURGY", (Object[])new String[]{"FORESTRY", "GALACTICRAFT", "RAILCRAFT", "TWILIGHTFOREST", "THAUMCRAFT", "GRAVESTONEMOD", "GROWTHCRAFT", "ARCTICMOBS", "DEMONMOBS", "INFERNOMOBS", "SWAMPMOBS", "MARICULTURE", "MINESTRAPPOLATION"});

    private Misc() {
    }

    public static boolean isNPCEntityExcludingVillagers(@NotNull Entity entity) {
        return !Misc.isVillager(entity) && Misc.isNPCIncludingVillagers(entity);
    }

    public static boolean isNPCClassType(Entity entity) {
        return entity instanceof NPC;
    }

    public static boolean hasNPCMetadataTag(Entity entity) {
        return entity.hasMetadata("NPC");
    }

    public static boolean isVillager(Entity entity) {
        String entityType = entity.getType().toString();
        return entityType.equalsIgnoreCase("wandering_trader") || entity instanceof Villager;
    }

    public static boolean isNPCIncludingVillagers(@Nullable Entity entity) {
        return entity == null || Misc.hasNPCMetadataTag(entity) || Misc.isNPCClassType(entity) || entity.getClass().getName().equalsIgnoreCase("cofh.entity.PlayerFake");
    }

    public static boolean isNear(@NotNull Location first, @NotNull Location second, double maxDistance) {
        return first.getWorld() == second.getWorld() && (first.distanceSquared(second) < maxDistance * maxDistance || maxDistance == 0.0);
    }

    public static Location getBlockCenter(BlockState blockState) {
        return Misc.getBlockCenter(blockState.getLocation());
    }

    public static Location getBlockCenter(Block block) {
        return Misc.getBlockCenter(block.getLocation());
    }

    public static Location getBlockCenter(Location location) {
        return location.clone().add(0.5, 0.5, 0.5);
    }

    public static void profileCleanup(@NotNull String playerName) {
        Player player = mcMMO.p.getServer().getPlayerExact(playerName);
        if (player != null) {
            UserManager.remove(player);
            mcMMO.p.getFoliaLib().getScheduler().runLaterAsync(new PlayerProfileLoadingTask(player), 1L);
        }
    }

    public static void printProgress(int convertedUsers, int progressInterval, long startMillis) {
        if (convertedUsers % progressInterval == 0) {
            mcMMO.p.getLogger().info(String.format("Conversion progress: %d users at %.2f users/second", convertedUsers, (double)convertedUsers / (double)((System.currentTimeMillis() - startMillis) / 1000L)));
        }
    }

    public static String getModName(@NotNull String materialName) {
        for (String mod : modNames) {
            if (!materialName.contains(mod)) continue;
            return mod;
        }
        String[] materialSplit = materialName.split("_");
        if (materialSplit.length > 1) {
            return materialSplit[0].toLowerCase(Locale.ENGLISH);
        }
        return "UnknownMods";
    }

    public static Location getLocationOffset(@NotNull Location location, double strength) {
        double blockX = location.getBlockX();
        double blockZ = location.getBlockZ();
        double distance = strength * random.nextDouble();
        blockX = random.nextBoolean() ? blockX + distance : blockX - distance;
        distance = strength * random.nextDouble();
        blockZ = random.nextBoolean() ? blockZ + distance : blockZ - distance;
        return new Location(location.getWorld(), blockX, location.getY(), blockZ);
    }

    @NotNull
    public static Random getRandom() {
        return random;
    }

    public static boolean isPartyLeader(@NotNull McMMOPlayer mmoPlayer) {
        return mmoPlayer.getParty().getLeader().getUniqueId().equals(mmoPlayer.getPlayer().getUniqueId());
    }

    public static void spawnExperienceOrb(@NotNull Location location, int experienceValue) {
        if (location.getWorld() == null) {
            return;
        }
        ExperienceOrb experienceOrb = (ExperienceOrb)location.getWorld().spawnEntity(location, EntityType.EXPERIENCE_ORB);
        experienceOrb.setExperience(experienceValue);
    }

    private static class SpawnOrbTask
    implements Runnable {
        private final Location location;
        private int orbExpValue;

        private SpawnOrbTask(Location location, int orbExpValue) {
            this.location = location;
            this.orbExpValue = orbExpValue;
        }

        @Override
        public void run() {
            if (this.location == null || this.location.getWorld() == null) {
                return;
            }
            ExperienceOrb experienceOrb = (ExperienceOrb)this.location.getWorld().spawnEntity(this.location, EntityType.EXPERIENCE_ORB);
            experienceOrb.setExperience(this.orbExpValue);
        }
    }
}

