/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.treasure.FishingTreasureConfig;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.treasure.Rarity;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.Probability;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.StringUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class FishingCommand
extends SkillCommand {
    private int lootTier;
    private String shakeChance;
    private String shakeChanceLucky;
    private int fishermansDietRank;
    private String commonTreasure;
    private String uncommonTreasure;
    private String rareTreasure;
    private String epicTreasure;
    private String legendaryTreasure;
    private String mythicTreasure;
    private String magicChance;
    private boolean canTreasureHunt;
    private boolean canMagicHunt;
    private boolean canShake;
    private boolean canFishermansDiet;
    private boolean canMasterAngler;
    private boolean canIceFish;
    private String maMinWaitTime;
    private String maMaxWaitTime;

    public FishingCommand() {
        super(PrimarySkillType.FISHING);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        FishingManager fishingManager = this.mmoPlayer.getFishingManager();
        if (this.canTreasureHunt) {
            this.lootTier = fishingManager.getLootTier();
            this.commonTreasure = this.percent.format(FishingTreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.COMMON) / 100.0);
            this.uncommonTreasure = this.percent.format(FishingTreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.UNCOMMON) / 100.0);
            this.rareTreasure = this.percent.format(FishingTreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.RARE) / 100.0);
            this.epicTreasure = this.percent.format(FishingTreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.EPIC) / 100.0);
            this.legendaryTreasure = this.percent.format(FishingTreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.LEGENDARY) / 100.0);
            this.mythicTreasure = this.percent.format(FishingTreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.MYTHIC) / 100.0);
            double totalEnchantChance = 0.0;
            for (Rarity rarity : Rarity.values()) {
                if (rarity == Rarity.MYTHIC) continue;
                totalEnchantChance += FishingTreasureConfig.getInstance().getEnchantmentDropRate(this.lootTier, rarity);
            }
            this.magicChance = totalEnchantChance >= 1.0 ? this.percent.format(totalEnchantChance / 100.0) : this.percent.format(0L);
        }
        if (this.canShake) {
            Probability shakeProbability = Probability.ofPercent(fishingManager.getShakeChance());
            String[] shakeStrings = ProbabilityUtil.getRNGDisplayValues(shakeProbability);
            this.shakeChance = shakeStrings[0];
            this.shakeChanceLucky = shakeStrings[1];
        }
        if (this.canFishermansDiet) {
            this.fishermansDietRank = RankUtils.getRank(player, SubSkillType.FISHING_FISHERMANS_DIET);
        }
        if (this.canMasterAngler) {
            this.maMinWaitTime = StringUtils.ticksToSeconds(fishingManager.getMasterAnglerTickMinWaitReduction(RankUtils.getRank(player, SubSkillType.FISHING_MASTER_ANGLER), false));
            this.maMaxWaitTime = StringUtils.ticksToSeconds(fishingManager.getMasterAnglerTickMaxWaitReduction(RankUtils.getRank(player, SubSkillType.FISHING_MASTER_ANGLER), false, 0));
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canTreasureHunt = Permissions.canUseSubSkill(player, SubSkillType.FISHING_TREASURE_HUNTER);
        this.canMagicHunt = Permissions.canUseSubSkill(player, SubSkillType.FISHING_MAGIC_HUNTER) && Permissions.canUseSubSkill(player, SubSkillType.FISHING_TREASURE_HUNTER);
        this.canShake = Permissions.canUseSubSkill(player, SubSkillType.FISHING_SHAKE);
        this.canFishermansDiet = Permissions.canUseSubSkill(player, SubSkillType.FISHING_FISHERMANS_DIET);
        this.canMasterAngler = mcMMO.getCompatibilityManager().getMasterAnglerCompatibilityLayer() != null && Permissions.canUseSubSkill(player, SubSkillType.FISHING_MASTER_ANGLER);
        this.canIceFish = Permissions.canUseSubSkill(player, SubSkillType.FISHING_ICE_FISHING);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canFishermansDiet) {
            messages.add(this.getStatMessage(false, true, SubSkillType.FISHING_FISHERMANS_DIET, String.valueOf(this.fishermansDietRank)));
        }
        if (this.canIceFish) {
            messages.add(this.getStatMessage(SubSkillType.FISHING_ICE_FISHING, SubSkillType.FISHING_ICE_FISHING.getLocaleStatDescription()));
        }
        if (this.canMagicHunt) {
            messages.add(this.getStatMessage(SubSkillType.FISHING_MAGIC_HUNTER, this.magicChance));
        }
        if (this.canMasterAngler) {
            messages.add(this.getStatMessage(false, true, SubSkillType.FISHING_MASTER_ANGLER, this.maMinWaitTime));
            messages.add(this.getStatMessage(true, true, SubSkillType.FISHING_MASTER_ANGLER, this.maMaxWaitTime));
        }
        if (this.canShake) {
            messages.add(this.getStatMessage(SubSkillType.FISHING_SHAKE, this.shakeChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.shakeChanceLucky) : ""));
        }
        if (this.canTreasureHunt) {
            messages.add(this.getStatMessage(false, true, SubSkillType.FISHING_TREASURE_HUNTER, String.valueOf(this.lootTier), String.valueOf(RankUtils.getHighestRank(SubSkillType.FISHING_TREASURE_HUNTER))));
            messages.add(this.getStatMessage(true, true, SubSkillType.FISHING_TREASURE_HUNTER, String.valueOf(this.commonTreasure), String.valueOf(this.uncommonTreasure), String.valueOf(this.rareTreasure), String.valueOf(this.epicTreasure), String.valueOf(this.legendaryTreasure), String.valueOf(this.mythicTreasure)));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.FISHING);
        return textComponents;
    }
}

