/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta;

import com.gmail.nossr50.util.blockmeta.ChunkStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitSetChunkStore
implements ChunkStore {
    private static final int CURRENT_VERSION = 9;
    private static final int MAGIC_NUMBER = -362881349;
    private final int cx;
    private final int cz;
    private final int worldMin;
    private final int worldMax;
    @NotNull
    private final UUID worldUid;
    @NotNull
    private final BitSet store;
    private transient boolean dirty = false;

    public BitSetChunkStore(@NotNull World world, int cx, int cz) {
        this(world.getUID(), world.getMinHeight(), world.getMaxHeight(), cx, cz);
    }

    private BitSetChunkStore(@NotNull UUID worldUid, int worldMin, int worldMax, int cx, int cz) {
        this.cx = cx;
        this.cz = cz;
        this.worldUid = worldUid;
        this.worldMin = worldMin;
        this.worldMax = worldMax;
        this.store = new BitSet(256 * (worldMax - worldMin));
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public int getChunkX() {
        return this.cx;
    }

    @Override
    public int getChunkZ() {
        return this.cz;
    }

    @Override
    public int getChunkMin() {
        return this.worldMin;
    }

    @Override
    public int getChunkMax() {
        return this.worldMax;
    }

    @Override
    @NotNull
    public UUID getWorldId() {
        return this.worldUid;
    }

    @Override
    public boolean isTrue(int x, int y, int z) {
        return this.store.get(this.coordToIndex(x, y, z));
    }

    @Override
    public void setTrue(int x, int y, int z) {
        this.set(x, y, z, true);
    }

    @Override
    public void setFalse(int x, int y, int z) {
        this.set(x, y, z, false);
    }

    @Override
    public void set(int x, int y, int z, boolean value) {
        this.store.set(this.coordToIndex(x, y, z), value);
        this.dirty = true;
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    private int coordToIndex(int x, int y, int z) {
        return BitSetChunkStore.coordToIndex(x, y, z, this.worldMin, this.worldMax);
    }

    private static int coordToIndex(int x, int y, int z, int worldMin, int worldMax) {
        if (x < 0 || x >= 16 || y < worldMin || y > worldMax || z < 0 || z >= 16) {
            throw new IndexOutOfBoundsException(String.format("x: %d y: %d z: %d World Min: %d World Max: %d", x, y, z, worldMin, worldMax));
        }
        int yOffset = -worldMin;
        return z * 16 + x + 256 * (y + yOffset);
    }

    private static int getWorldMin(@NotNull UUID worldUid) {
        World world = Bukkit.getWorld((UUID)worldUid);
        if (world == null) {
            throw new RuntimeException("Cannot grab a minimum world height for an unloaded world");
        }
        return world.getMinHeight();
    }

    private static int getWorldMax(@NotNull UUID worldUid) {
        World world = Bukkit.getWorld((UUID)worldUid);
        if (world == null) {
            throw new RuntimeException("Cannot grab a maximum world height for an unloaded world");
        }
        return world.getMaxHeight();
    }

    private void serialize(@NotNull DataOutputStream out) throws IOException {
        out.writeInt(-362881349);
        out.writeInt(9);
        out.writeLong(this.worldUid.getLeastSignificantBits());
        out.writeLong(this.worldUid.getMostSignificantBits());
        out.writeInt(this.cx);
        out.writeInt(this.cz);
        out.writeInt(this.worldMin);
        out.writeInt(this.worldMax);
        byte[] storeData = this.store.toByteArray();
        out.writeInt(storeData.length);
        out.write(storeData);
        this.dirty = false;
    }

    @NotNull
    private static BitSetChunkStore deserialize(@NotNull DataInputStream in) throws IOException {
        int magic = in.readInt();
        int fileVersionNumber = in.readInt();
        if (magic != -362881349 || fileVersionNumber < 8) {
            throw new IOException();
        }
        long lsb = in.readLong();
        long msb = in.readLong();
        UUID worldUid = new UUID(msb, lsb);
        int cx = in.readInt();
        int cz = in.readInt();
        int worldMin = 0;
        if (fileVersionNumber >= 9) {
            worldMin = in.readInt();
        }
        int worldMax = in.readInt();
        byte[] temp = new byte[in.readInt()];
        in.readFully(temp);
        BitSet stored = BitSet.valueOf(temp);
        int currentWorldMin = BitSetChunkStore.getWorldMin(worldUid);
        int currentWorldMax = BitSetChunkStore.getWorldMax(worldUid);
        if (currentWorldMax < worldMax) {
            stored.clear(BitSetChunkStore.coordToIndex(16, currentWorldMax, 16, worldMin, worldMax), stored.length());
        }
        if (currentWorldMin > worldMin) {
            stored = stored.get(currentWorldMin, stored.length());
        }
        if (currentWorldMin < worldMin) {
            int offset = (worldMin - currentWorldMin) * 16 * 16;
            BitSet shifted = new BitSet();
            for (int i = 0; i < stored.length(); ++i) {
                shifted.set(i + offset, stored.get(i));
            }
            stored = shifted;
        }
        BitSetChunkStore chunkStore = new BitSetChunkStore(worldUid, currentWorldMin, currentWorldMax, cx, cz);
        chunkStore.store.or(stored);
        chunkStore.dirty = currentWorldMin != worldMin || currentWorldMax != worldMax;
        return chunkStore;
    }

    public static class Serialization {
        public static final short STREAM_MAGIC = -21284;

        @Nullable
        public static ChunkStore readChunkStore(@NotNull DataInputStream inputStream) throws IOException {
            short magicNumber;
            if (inputStream.markSupported()) {
                inputStream.mark(2);
            }
            if ((magicNumber = inputStream.readShort()) == -21267) {
                if (inputStream.markSupported()) {
                    inputStream.reset();
                } else {
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
                    pushbackInputStream.unread(magicNumber & 0xFF);
                    pushbackInputStream.unread(magicNumber >>> 8 & 0xFF);
                    inputStream = new DataInputStream(pushbackInputStream);
                }
                return new LegacyDeserializationInputStream(inputStream).readLegacyChunkStore();
            }
            if (magicNumber == -21284) {
                return BitSetChunkStore.deserialize(inputStream);
            }
            throw new IOException("Bad Data Format");
        }

        public static void writeChunkStore(@NotNull DataOutputStream outputStream, @NotNull ChunkStore chunkStore) throws IOException {
            if (!(chunkStore instanceof BitSetChunkStore)) {
                throw new InvalidClassException("ChunkStore must be instance of BitSetChunkStore");
            }
            outputStream.writeShort(-21284);
            ((BitSetChunkStore)chunkStore).serialize(outputStream);
        }

        private static class LegacyDeserializationInputStream
        extends ObjectInputStream {
            public LegacyDeserializationInputStream(@NotNull InputStream in) throws IOException {
                super(in);
                this.enableResolveObject(true);
            }

            @Override
            @NotNull
            protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                ObjectStreamClass read = super.readClassDescriptor();
                if (read.getName().contentEquals("com.gmail.nossr50.util.blockmeta.chunkmeta.PrimitiveChunkStore")) {
                    return ObjectStreamClass.lookup(LegacyChunkStoreDeserializer.class);
                }
                return read;
            }

            @Nullable
            public ChunkStore readLegacyChunkStore() {
                try {
                    LegacyChunkStoreDeserializer deserializer = (LegacyChunkStoreDeserializer)this.readObject();
                    return deserializer.convert();
                }
                catch (IOException | ClassNotFoundException e) {
                    return null;
                }
            }

            private static class LegacyChunkStoreDeserializer
            implements Serializable {
                private static final long serialVersionUID = -1L;
                private int cx;
                private int cz;
                private int worldMax;
                private UUID worldUid;
                private boolean[][][] store;

                private LegacyChunkStoreDeserializer() {
                }

                @Deprecated
                private void writeObject(@NotNull ObjectOutputStream out) throws IOException {
                    throw new UnsupportedOperationException("You goofed.");
                }

                @Deprecated
                private void readObject(@NotNull ObjectInputStream in) throws IOException, ClassNotFoundException {
                    in.readInt();
                    in.readInt();
                    long lsb = in.readLong();
                    long msb = in.readLong();
                    this.worldUid = new UUID(msb, lsb);
                    this.cx = in.readInt();
                    this.cz = in.readInt();
                    this.store = (boolean[][][])in.readObject();
                    this.worldMax = this.store[0][0].length;
                }

                @NotNull
                public BitSetChunkStore convert() {
                    int currentWorldMin = BitSetChunkStore.getWorldMin(this.worldUid);
                    int currentWorldMax = BitSetChunkStore.getWorldMax(this.worldUid);
                    BitSetChunkStore converted = new BitSetChunkStore(this.worldUid, currentWorldMin, currentWorldMax, this.cx, this.cz);
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            for (int y = 0; y < this.worldMax && y < currentWorldMax; ++y) {
                                converted.store.set(converted.coordToIndex(x, y, z), this.store[x][z][y]);
                            }
                        }
                    }
                    converted.dirty = true;
                    return converted;
                }
            }
        }
    }
}

