/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.chat;

import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.acf.BaseCommand;
import com.gmail.nossr50.mcmmo.acf.BukkitCommandIssuer;
import com.gmail.nossr50.mcmmo.acf.annotation.CommandAlias;
import com.gmail.nossr50.mcmmo.acf.annotation.CommandPermission;
import com.gmail.nossr50.mcmmo.acf.annotation.Conditions;
import com.gmail.nossr50.mcmmo.acf.annotation.Default;
import com.gmail.nossr50.util.player.UserManager;
import org.jetbrains.annotations.NotNull;

@CommandPermission(value="mcmmo.chat.adminchat")
@CommandAlias(value="ac|a|adminchat|achat")
public class AdminChatCommand
extends BaseCommand {
    @NotNull
    private final mcMMO pluginRef;

    public AdminChatCommand(@NotNull mcMMO pluginRef) {
        this.pluginRef = pluginRef;
    }

    @Default
    @Conditions(value="adminCondition")
    public void processCommand(String[] args) {
        BukkitCommandIssuer bukkitCommandIssuer = (BukkitCommandIssuer)this.getCurrentCommandIssuer();
        if (args == null || args.length == 0) {
            if (bukkitCommandIssuer.isPlayer()) {
                McMMOPlayer mmoPlayer = UserManager.getPlayer(bukkitCommandIssuer.getPlayer());
                this.pluginRef.getChatManager().setOrToggleChatChannel(mmoPlayer, ChatChannel.ADMIN);
            } else {
                mcMMO.p.getLogger().info("You cannot switch chat channels as console, please provide full arguments.");
            }
        } else if (bukkitCommandIssuer.isPlayer()) {
            McMMOPlayer mmoPlayer = UserManager.getPlayer(bukkitCommandIssuer.getPlayer());
            if (mmoPlayer == null) {
                return;
            }
            this.pluginRef.getChatManager().processPlayerMessage(mmoPlayer, args, ChatChannel.ADMIN);
        } else {
            this.pluginRef.getChatManager().processConsoleMessage(args);
        }
    }
}

