/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.repair;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.repair.ArcaneForging;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permissible;

public class RepairManager
extends SkillManager {
    private boolean placedAnvil;
    private int lastClick;

    public RepairManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.REPAIR);
    }

    public void placedAnvilCheck() {
        Player player = this.getPlayer();
        if (this.getPlacedAnvil()) {
            return;
        }
        if (mcMMO.p.getGeneralConfig().getRepairAnvilMessagesEnabled()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Repair.Listener.Anvil");
        }
        if (mcMMO.p.getGeneralConfig().getRepairAnvilPlaceSoundsEnabled()) {
            SoundManager.sendCategorizedSound(player, player.getLocation(), SoundType.ANVIL, SoundCategory.BLOCKS);
        }
        this.togglePlacedAnvil();
    }

    public void handleRepair(ItemStack item) {
        int minimumRepairableLevel;
        Player player = this.getPlayer();
        Repairable repairable = mcMMO.getRepairableManager().getRepairable(item.getType());
        if (item.getItemMeta() != null) {
            if (item.getItemMeta().hasCustomModelData() && !mcMMO.p.getCustomItemSupportConfig().isCustomRepairAllowed()) {
                NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Anvil.Repair.Reject.CustomModelData");
                return;
            }
            if (item.getItemMeta().isUnbreakable()) {
                NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Anvil.Unbreakable");
                return;
            }
        }
        if (!Permissions.repairMaterialType((Permissible)player, repairable.getRepairMaterialType())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        if (!Permissions.repairItemType((Permissible)player, repairable.getRepairItemType())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        int skillLevel = this.getSkillLevel();
        if (skillLevel < (minimumRepairableLevel = repairable.getMinimumLevel())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Repair.Skills.Adept", String.valueOf(minimumRepairableLevel), StringUtils.getPrettyMaterialString(item.getType()));
            return;
        }
        PlayerInventory inventory = player.getInventory();
        Material repairMaterial = repairable.getRepairMaterial();
        ItemStack toRemove = new ItemStack(repairMaterial);
        short startDurability = item.getDurability();
        if (startDurability <= 0) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Repair.Skills.FullDurability");
            return;
        }
        if (!inventory.contains(repairMaterial)) {
            String prettyName = repairable.getRepairMaterialPrettyName() == null ? StringUtils.getPrettyMaterialString(repairMaterial) : repairable.getRepairMaterialPrettyName();
            String materialsNeeded = "";
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Skills.NeedMore.Extra", prettyName, materialsNeeded);
            return;
        }
        if (item.getAmount() != 1) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Repair.Skills.StackedItems");
            return;
        }
        SkillUtils.removeAbilityBuff(item);
        short baseRepairAmount = repairable.getBaseRepairDurability(item);
        short newDurability = this.repairCalculate(startDurability, baseRepairAmount);
        toRemove = inventory.getItem(inventory.first(repairMaterial)).clone();
        if (!mcMMO.p.getAdvancedConfig().getAllowEnchantedRepairMaterials() && toRemove.getEnchantments().size() > 0) {
            Optional<ItemStack> possibleMaterial = Arrays.stream(inventory.getContents()).filter(Objects::nonNull).filter(p -> p.getType() == repairMaterial).filter(p -> p.getEnchantments().isEmpty()).findFirst();
            if (possibleMaterial.isEmpty()) {
                String prettyName = repairable.getRepairMaterialPrettyName() == null ? StringUtils.getPrettyMaterialString(repairMaterial) : repairable.getRepairMaterialPrettyName();
                String materialsNeeded = "";
                NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Skills.NeedMore.Extra", prettyName, materialsNeeded);
                return;
            }
            toRemove = possibleMaterial.get().clone();
        }
        if (EventUtils.callRepairCheckEvent(player, (short)(startDurability - newDurability), toRemove, item).isCancelled()) {
            return;
        }
        if (ArcaneForging.arcaneForgingEnchantLoss && !Permissions.hasRepairEnchantBypassPerk((Permissible)player)) {
            this.addEnchants(item);
        }
        toRemove.setAmount(1);
        inventory.removeItem(new ItemStack[]{toRemove});
        this.applyXpGain((float)((double)this.getPercentageRepaired(startDurability, newDurability, repairable.getMaximumDurability()) * repairable.getXpMultiplier() * ExperienceConfig.getInstance().getRepairXPBase() * ExperienceConfig.getInstance().getRepairXP(repairable.getRepairMaterialType())), XPGainReason.PVE);
        if (mcMMO.p.getGeneralConfig().getRepairAnvilUseSoundsEnabled()) {
            SoundManager.sendCategorizedSound(player, player.getLocation(), SoundType.ANVIL, SoundCategory.BLOCKS);
            SoundManager.sendCategorizedSound(player, player.getLocation(), SoundType.ITEM_BREAK, SoundCategory.PLAYERS);
        }
        item.setDurability(newDurability);
    }

    private float getPercentageRepaired(short startDurability, short newDurability, short totalDurability) {
        return (float)(startDurability - newDurability) / (float)totalDurability;
    }

    public boolean checkConfirmation(boolean actualize) {
        Player player = this.getPlayer();
        long lastUse = this.getLastAnvilUse();
        if (!SkillUtils.cooldownExpired(lastUse, 3) || !mcMMO.p.getGeneralConfig().getRepairConfirmRequired()) {
            return true;
        }
        if (!actualize) {
            return false;
        }
        this.actualizeLastAnvilUse();
        NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Skills.ConfirmOrCancel", LocaleLoader.getString("Repair.Pretty.Name"));
        return false;
    }

    public int getArcaneForgingRank() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.REPAIR_ARCANE_FORGING);
    }

    public double getKeepEnchantChance() {
        return mcMMO.p.getAdvancedConfig().getArcaneForgingKeepEnchantsChance(this.getArcaneForgingRank());
    }

    public double getDowngradeEnchantChance() {
        return mcMMO.p.getAdvancedConfig().getArcaneForgingDowngradeChance(this.getArcaneForgingRank());
    }

    private short repairCalculate(short durability, int repairAmount) {
        Player player = this.getPlayer();
        if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.REPAIR_REPAIR_MASTERY) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.REPAIR_REPAIR_MASTERY)) {
            double maxBonusCalc = Repair.repairMasteryMaxBonus / 100.0;
            double skillLevelBonusCalc = Repair.repairMasteryMaxBonus / (double)Repair.repairMasteryMaxBonusLevel * ((double)this.getSkillLevel() / 100.0);
            double bonus = (double)repairAmount * Math.min(skillLevelBonusCalc, maxBonusCalc);
            repairAmount = (int)((double)repairAmount + bonus);
        }
        if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.REPAIR_SUPER_REPAIR) && this.checkPlayerProcRepair()) {
            repairAmount = (int)((double)repairAmount * 2.0);
        }
        if (repairAmount <= 0 || repairAmount > Short.MAX_VALUE) {
            repairAmount = Short.MAX_VALUE;
        }
        return (short)Math.max(durability - repairAmount, 0);
    }

    private boolean checkPlayerProcRepair() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.REPAIR_SUPER_REPAIR)) {
            return false;
        }
        if (ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.REPAIR_SUPER_REPAIR, this.mmoPlayer)) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Repair.Skills.FeltEasy");
            return true;
        }
        return false;
    }

    private void addEnchants(ItemStack item) {
        Player player = this.getPlayer();
        Map enchants = item.getEnchantments();
        if (enchants.isEmpty()) {
            return;
        }
        if (Permissions.arcaneBypass((Permissible)player)) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Repair.Arcane.Perfect");
            return;
        }
        if (this.getArcaneForgingRank() == 0 || !Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.REPAIR_ARCANE_FORGING)) {
            for (Enchantment enchant : enchants.keySet()) {
                item.removeEnchantment(enchant);
            }
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE_FAILED, "Repair.Arcane.Lost");
            return;
        }
        boolean downgraded = false;
        for (Map.Entry enchant : enchants.entrySet()) {
            int enchantLevel = (Integer)enchant.getValue();
            if (!ExperienceConfig.getInstance().allowUnsafeEnchantments() && enchantLevel > ((Enchantment)enchant.getKey()).getMaxLevel()) {
                enchantLevel = ((Enchantment)enchant.getKey()).getMaxLevel();
                item.addEnchantment((Enchantment)enchant.getKey(), enchantLevel);
            }
            Enchantment enchantment = (Enchantment)enchant.getKey();
            if (ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.REPAIR, this.mmoPlayer, this.getKeepEnchantChance())) {
                if (!ArcaneForging.arcaneForgingDowngrades || enchantLevel <= 1 || ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.REPAIR, this.mmoPlayer, 100.0 - this.getDowngradeEnchantChance())) continue;
                item.addUnsafeEnchantment(enchantment, enchantLevel - 1);
                downgraded = true;
                continue;
            }
            item.removeEnchantment(enchantment);
        }
        Map newEnchants = item.getEnchantments();
        if (newEnchants.isEmpty()) {
            NotificationManager.sendPlayerInformationChatOnly(this.getPlayer(), "Repair.Arcane.Fail", new String[0]);
        } else if (downgraded || newEnchants.size() < enchants.size()) {
            NotificationManager.sendPlayerInformationChatOnly(this.getPlayer(), "Repair.Arcane.Downgrade", new String[0]);
        } else {
            NotificationManager.sendPlayerInformationChatOnly(this.getPlayer(), "Repair.Arcane.Perfect", new String[0]);
        }
    }

    public boolean getPlacedAnvil() {
        return this.placedAnvil;
    }

    public void togglePlacedAnvil() {
        this.placedAnvil = !this.placedAnvil;
    }

    public int getLastAnvilUse() {
        return this.lastClick;
    }

    public void setLastAnvilUse(int value) {
        this.lastClick = value;
    }

    public void actualizeLastAnvilUse() {
        this.lastClick = (int)(System.currentTimeMillis() / 1000L);
    }
}

