/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.events.party.McMMOPartyChangeEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PartyRenameCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 2) {
            String newPartyName;
            if (UserManager.getPlayer((Player)sender) == null) {
                sender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                return true;
            }
            McMMOPlayer mmoPlayer = UserManager.getPlayer((Player)sender);
            Party playerParty = mmoPlayer.getParty();
            String oldPartyName = playerParty.getName();
            if (oldPartyName.equalsIgnoreCase(newPartyName = args[1].replace(".", ""))) {
                sender.sendMessage(LocaleLoader.getString("Party.Rename.Same"));
                return true;
            }
            Player player = mmoPlayer.getPlayer();
            if (mcMMO.p.getPartyManager().checkPartyExistence(player, newPartyName)) {
                return true;
            }
            String leaderName = playerParty.getLeader().getPlayerName();
            for (Player member : playerParty.getOnlineMembers()) {
                if (!mcMMO.p.getPartyManager().handlePartyChangeEvent(member, oldPartyName, newPartyName, McMMOPartyChangeEvent.EventReason.CHANGED_PARTIES)) {
                    return true;
                }
                if (member.getName().equalsIgnoreCase(leaderName)) continue;
                member.sendMessage(LocaleLoader.getString("Party.InformedOnNameChange", leaderName, newPartyName));
            }
            playerParty.setName(newPartyName);
            sender.sendMessage(LocaleLoader.getString("Commands.Party.Rename", newPartyName));
            return true;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "rename", "<" + LocaleLoader.getString("Commands.Usage.PartyName") + ">"));
        return true;
    }
}

