/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.compat;

import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.compat.CompatibilityType;
import com.gmail.nossr50.util.compat.layers.bungee.AbstractBungeeSerializerCompatibilityLayer;
import com.gmail.nossr50.util.compat.layers.bungee.BungeeLegacySerializerCompatibilityLayer;
import com.gmail.nossr50.util.compat.layers.bungee.BungeeModernSerializerCompatibilityLayer;
import com.gmail.nossr50.util.compat.layers.skills.AbstractMasterAnglerCompatibility;
import com.gmail.nossr50.util.compat.layers.skills.MasterAnglerCompatibilityLayer;
import com.gmail.nossr50.util.nms.NMSVersion;
import com.gmail.nossr50.util.platform.MinecraftGameVersion;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityManager {
    @NotNull
    private HashMap<CompatibilityType, Boolean> supportedLayers;
    private boolean isFullyCompatibleServerSoftware = true;
    @NotNull
    private final MinecraftGameVersion minecraftGameVersion;
    @NotNull
    private final NMSVersion nmsVersion;
    private AbstractBungeeSerializerCompatibilityLayer bungeeSerializerCompatibilityLayer;
    private AbstractMasterAnglerCompatibility masterAnglerCompatibility;

    public CompatibilityManager(@NotNull MinecraftGameVersion minecraftGameVersion) {
        LogUtils.debug(mcMMO.p.getLogger(), "Loading compatibility layers...");
        this.minecraftGameVersion = minecraftGameVersion;
        this.nmsVersion = this.determineNMSVersion();
        this.init();
        LogUtils.debug(mcMMO.p.getLogger(), "Finished loading compatibility layers.");
    }

    private void init() {
        this.initSupportedLayersMap();
        this.initCompatibilityLayers();
    }

    private void initSupportedLayersMap() {
        this.supportedLayers = new HashMap();
        for (CompatibilityType compatibilityType : CompatibilityType.values()) {
            this.supportedLayers.put(compatibilityType, false);
        }
    }

    private void initCompatibilityLayers() {
        this.initBungeeSerializerLayer();
        this.initMasterAnglerLayer();
        this.isFullyCompatibleServerSoftware = true;
    }

    private void initMasterAnglerLayer() {
        this.masterAnglerCompatibility = this.minecraftGameVersion.isAtLeast(1, 16, 3) ? new MasterAnglerCompatibilityLayer() : null;
    }

    private void initBungeeSerializerLayer() {
        this.bungeeSerializerCompatibilityLayer = this.minecraftGameVersion.isAtLeast(1, 16, 0) ? new BungeeModernSerializerCompatibilityLayer() : new BungeeLegacySerializerCompatibilityLayer();
        this.supportedLayers.put(CompatibilityType.BUNGEE_SERIALIZER, true);
    }

    public void reportCompatibilityStatus(@NotNull CommandSender commandSender) {
        if (this.isFullyCompatibleServerSoftware) {
            commandSender.sendMessage(LocaleLoader.getString("mcMMO.Template.Prefix", "mcMMO is fully compatible with the currently running server software."));
        } else {
            for (CompatibilityType compatibilityType : CompatibilityType.values()) {
                if (this.supportedLayers.get((Object)compatibilityType).booleanValue()) continue;
                commandSender.sendMessage(LocaleLoader.getString("mcMMO.Template.Prefix", LocaleLoader.getString("Compatibility.Layer.Unsupported", StringUtils.getCapitalized(compatibilityType.toString()))));
            }
        }
        commandSender.sendMessage(LocaleLoader.getString("mcMMO.Template.Prefix", "NMS Status - " + String.valueOf((Object)this.nmsVersion)));
    }

    public boolean isCompatibilityLayerOperational(@NotNull CompatibilityType compatibilityType) {
        return this.supportedLayers.get((Object)compatibilityType);
    }

    public boolean isFullyCompatibleServerSoftware() {
        return this.isFullyCompatibleServerSoftware;
    }

    @NotNull
    public NMSVersion getNmsVersion() {
        return this.nmsVersion;
    }

    @NotNull
    private NMSVersion determineNMSVersion() {
        if (this.minecraftGameVersion.isAtLeast(1, 17, 0)) {
            return NMSVersion.NMS_1_17;
        }
        if (this.minecraftGameVersion.getMajorVersion().asInt() == 1) {
            switch (this.minecraftGameVersion.getMinorVersion().asInt()) {
                case 12: {
                    return NMSVersion.NMS_1_12_2;
                }
                case 13: {
                    return NMSVersion.NMS_1_13_2;
                }
                case 14: {
                    return NMSVersion.NMS_1_14_4;
                }
                case 15: {
                    return NMSVersion.NMS_1_15_2;
                }
                case 16: {
                    if (this.minecraftGameVersion.getPatchVersion().asInt() == 1) {
                        return NMSVersion.NMS_1_16_1;
                    }
                    if (this.minecraftGameVersion.getPatchVersion().asInt() == 2) {
                        return NMSVersion.NMS_1_16_2;
                    }
                    if (this.minecraftGameVersion.getPatchVersion().asInt() == 3) {
                        return NMSVersion.NMS_1_16_3;
                    }
                    if (this.minecraftGameVersion.getPatchVersion().asInt() == 4) {
                        return NMSVersion.NMS_1_16_4;
                    }
                    if (this.minecraftGameVersion.getPatchVersion().asInt() >= 5) {
                        return NMSVersion.NMS_1_16_5;
                    }
                }
                case 17: {
                    return NMSVersion.NMS_1_17;
                }
            }
        }
        return NMSVersion.UNSUPPORTED;
    }

    public AbstractBungeeSerializerCompatibilityLayer getBungeeSerializerCompatibilityLayer() {
        return this.bungeeSerializerCompatibilityLayer;
    }

    @Nullable
    public AbstractMasterAnglerCompatibility getMasterAnglerCompatibilityLayer() {
        return this.masterAnglerCompatibility;
    }

    @NotNull
    public MinecraftGameVersion getMinecraftGameVersion() {
        return this.minecraftGameVersion;
    }
}

