/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.woodcutting;

import com.gmail.nossr50.api.FakeBlockBreakEventType;
import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class WoodcuttingManager
extends SkillManager {
    public static final String SAPLING = "sapling";
    public static final String PROPAGULE = "propagule";
    private static final Predicate<ItemStack> IS_SAPLING_OR_PROPAGULE = p -> p.getType().getKey().getKey().toLowerCase().contains(SAPLING) || p.getType().getKey().getKey().toLowerCase().contains(PROPAGULE);
    private boolean treeFellerReachedThreshold = false;
    private static int treeFellerThreshold;
    private static final int[][] directions;

    public WoodcuttingManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.WOODCUTTING);
        treeFellerThreshold = mcMMO.p.getGeneralConfig().getTreeFellerThreshold();
    }

    public boolean canUseLeafBlower(ItemStack heldItem) {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.WOODCUTTING_LEAF_BLOWER) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.WOODCUTTING_LEAF_BLOWER) && ItemUtils.isAxe(heldItem);
    }

    public boolean canUseTreeFeller(ItemStack heldItem) {
        return this.mmoPlayer.getAbilityMode(SuperAbilityType.TREE_FELLER) && ItemUtils.isAxe(heldItem);
    }

    private boolean checkHarvestLumberActivation(Material material) {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.WOODCUTTING_HARVEST_LUMBER) && RankUtils.hasReachedRank(1, this.getPlayer(), SubSkillType.WOODCUTTING_HARVEST_LUMBER) && ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.WOODCUTTING_HARVEST_LUMBER, this.mmoPlayer) && mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.WOODCUTTING, material);
    }

    private boolean checkCleanCutsActivation(Material material) {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.WOODCUTTING_HARVEST_LUMBER) && RankUtils.hasReachedRank(1, this.getPlayer(), SubSkillType.WOODCUTTING_HARVEST_LUMBER) && ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.WOODCUTTING_CLEAN_CUTS, this.mmoPlayer) && mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.WOODCUTTING, material);
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    public void processBonusDropCheck(@NotNull BlockState blockState) {
        this.processBonusDropCheck(blockState.getBlock());
    }

    public void processBonusDropCheck(@NotNull Block block) {
        if (mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.WOODCUTTING, block.getType())) {
            if (Permissions.canUseSubSkill(this.getPlayer(), SubSkillType.WOODCUTTING_CLEAN_CUTS)) {
                if (this.checkCleanCutsActivation(block.getType())) {
                    this.spawnHarvestLumberBonusDrops(block);
                    this.spawnHarvestLumberBonusDrops(block);
                } else if (this.checkHarvestLumberActivation(block.getType())) {
                    this.spawnHarvestLumberBonusDrops(block);
                }
            } else if (Permissions.canUseSubSkill(this.getPlayer(), SubSkillType.WOODCUTTING_HARVEST_LUMBER) && this.checkHarvestLumberActivation(block.getType())) {
                this.spawnHarvestLumberBonusDrops(block);
            }
        }
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    public void processWoodcuttingBlockXP(@NotNull BlockState blockState) {
        this.processWoodcuttingBlockXP(blockState.getBlock());
    }

    public void processWoodcuttingBlockXP(@NotNull Block block) {
        if (mcMMO.getUserBlockTracker().isIneligible(block)) {
            return;
        }
        int xp = WoodcuttingManager.getExperienceFromLog(block);
        this.applyXpGain(xp, XPGainReason.PVE, XPGainSource.SELF);
    }

    public void processTreeFeller(Block startingBlock) {
        Player player = this.getPlayer();
        HashSet<Block> treeFellerBlocks = new HashSet<Block>();
        this.treeFellerReachedThreshold = false;
        this.processTree(startingBlock, treeFellerBlocks);
        if (!WoodcuttingManager.handleDurabilityLoss(treeFellerBlocks, player.getInventory().getItemInMainHand(), player)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Woodcutting.Skills.TreeFeller.Splinter");
            double health = player.getHealth();
            if (health > 1.0) {
                int dmg = Misc.getRandom().nextInt((int)(health - 1.0));
                CombatUtils.safeDealDamage((LivingEntity)player, dmg);
            }
            return;
        }
        this.dropTreeFellerLootFromBlocks(treeFellerBlocks);
        this.treeFellerReachedThreshold = false;
    }

    private void processTree(Block block, Set<Block> treeFellerBlocks) {
        ArrayList<Block> futureCenterBlocks = new ArrayList<Block>();
        if (this.processTreeFellerTargetBlock(block.getRelative(BlockFace.UP), futureCenterBlocks, treeFellerBlocks)) {
            for (int[] dir : directions) {
                this.processTreeFellerTargetBlock(block.getRelative(dir[0], 0, dir[1]), futureCenterBlocks, treeFellerBlocks);
                if (!this.treeFellerReachedThreshold) continue;
                return;
            }
        } else {
            this.processTreeFellerTargetBlock(block.getRelative(BlockFace.DOWN), futureCenterBlocks, treeFellerBlocks);
            for (int y = -1; y <= 1; ++y) {
                for (int[] dir : directions) {
                    this.processTreeFellerTargetBlock(block.getRelative(dir[0], y, dir[1]), futureCenterBlocks, treeFellerBlocks);
                    if (!this.treeFellerReachedThreshold) continue;
                    return;
                }
            }
        }
        Object object = futureCenterBlocks.iterator();
        while (object.hasNext()) {
            Block futureCenterBlock = (Block)object.next();
            if (this.treeFellerReachedThreshold) {
                return;
            }
            this.processTree(futureCenterBlock, treeFellerBlocks);
        }
    }

    private static boolean handleDurabilityLoss(@NotNull Set<Block> treeFellerBlocks, @NotNull ItemStack inHand, @NotNull Player player) {
        ItemMeta meta = inHand.getItemMeta();
        if (meta != null && meta.isUnbreakable()) {
            return true;
        }
        int durabilityLoss = 0;
        Material type = inHand.getType();
        for (Block block : treeFellerBlocks) {
            if (!BlockUtils.hasWoodcuttingXP(block)) continue;
            durabilityLoss += mcMMO.p.getGeneralConfig().getAbilityToolDamage();
        }
        PlayerItemDamageEvent event = new PlayerItemDamageEvent(player, inHand, durabilityLoss);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return true;
        }
        SkillUtils.handleDurabilityChange(inHand, durabilityLoss);
        int durability = meta instanceof Damageable ? ((Damageable)meta).getDamage() : 0;
        return durability < (mcMMO.getRepairableManager().isRepairable(type) ? mcMMO.getRepairableManager().getRepairable(type).getMaximumDurability() : type.getMaxDurability());
    }

    private boolean processTreeFellerTargetBlock(@NotNull Block block, @NotNull List<Block> futureCenterBlocks, @NotNull Set<Block> treeFellerBlocks) {
        if (treeFellerBlocks.contains(block) || mcMMO.getUserBlockTracker().isIneligible(block)) {
            return false;
        }
        if (treeFellerBlocks.size() > treeFellerThreshold) {
            this.treeFellerReachedThreshold = true;
        }
        if (BlockUtils.hasWoodcuttingXP(block)) {
            treeFellerBlocks.add(block);
            futureCenterBlocks.add(block);
            return true;
        }
        if (BlockUtils.isNonWoodPartOfTree(block)) {
            treeFellerBlocks.add(block);
            return false;
        }
        return false;
    }

    private void dropTreeFellerLootFromBlocks(@NotNull Set<Block> treeFellerBlocks) {
        Player player = this.getPlayer();
        int xp = 0;
        int processedLogCount = 0;
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        for (Block block : treeFellerBlocks) {
            int beforeXP = xp;
            if (!EventUtils.simulateBlockBreak(block, player, FakeBlockBreakEventType.TREE_FELLER)) continue;
            if (BlockUtils.hasWoodcuttingXP(block)) {
                xp += WoodcuttingManager.processTreeFellerXPGains(block, processedLogCount);
                ItemUtils.spawnItemsFromCollection(player, Misc.getBlockCenter(block), block.getDrops(itemStack), ItemSpawnReason.TREE_FELLER_DISPLACED_BLOCK);
                this.processBonusDropCheck(block);
            } else if (BlockUtils.isNonWoodPartOfTree(block)) {
                if (ThreadLocalRandom.current().nextInt(100) > 75) {
                    ItemUtils.spawnItemsFromCollection(player, Misc.getBlockCenter(block), block.getDrops(itemStack), ItemSpawnReason.TREE_FELLER_DISPLACED_BLOCK);
                } else if (RankUtils.hasUnlockedSubskill(player, SubSkillType.WOODCUTTING_KNOCK_ON_WOOD)) {
                    ItemUtils.spawnItemsConditionally(block.getDrops(itemStack), IS_SAPLING_OR_PROPAGULE, ItemSpawnReason.TREE_FELLER_DISPLACED_BLOCK, Misc.getBlockCenter(block), player);
                }
                if (RankUtils.hasUnlockedSubskill(player, SubSkillType.WOODCUTTING_KNOCK_ON_WOOD) && RankUtils.hasReachedRank(2, player, SubSkillType.WOODCUTTING_KNOCK_ON_WOOD) && mcMMO.p.getAdvancedConfig().isKnockOnWoodXPOrbEnabled() && ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.WOODCUTTING, this.mmoPlayer, 10.0)) {
                    int randOrbCount = Math.max(1, Misc.getRandom().nextInt(100));
                    Misc.spawnExperienceOrb(block.getLocation(), randOrbCount);
                }
            }
            block.setType(Material.AIR);
            processedLogCount = this.updateProcessedLogCount(xp, processedLogCount, beforeXP);
        }
        this.applyXpGain(xp, XPGainReason.PVE, XPGainSource.SELF);
    }

    private int updateProcessedLogCount(int xp, int processedLogCount, int beforeXP) {
        if (beforeXP != xp) {
            ++processedLogCount;
        }
        return processedLogCount;
    }

    private static int processTreeFellerXPGains(Block block, int woodCount) {
        if (mcMMO.getUserBlockTracker().isIneligible(block)) {
            return 0;
        }
        int rawXP = ExperienceConfig.getInstance().getXp(PrimarySkillType.WOODCUTTING, block.getType());
        if (rawXP <= 0) {
            return 0;
        }
        if (ExperienceConfig.getInstance().isTreeFellerXPReduced()) {
            int reducedXP = rawXP - woodCount * 5;
            rawXP = Math.max(1, reducedXP);
            return rawXP;
        }
        return ExperienceConfig.getInstance().getXp(PrimarySkillType.WOODCUTTING, block.getType());
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    protected static int getExperienceFromLog(BlockState blockState) {
        return WoodcuttingManager.getExperienceFromLog(blockState.getBlock());
    }

    protected static int getExperienceFromLog(Block block) {
        return ExperienceConfig.getInstance().getXp(PrimarySkillType.WOODCUTTING, block.getType());
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    void spawnHarvestLumberBonusDrops(@NotNull BlockState blockState) {
        this.spawnHarvestLumberBonusDrops(blockState.getBlock());
    }

    void spawnHarvestLumberBonusDrops(@NotNull Block block) {
        ItemUtils.spawnItemsFromCollection(this.getPlayer(), Misc.getBlockCenter(block), block.getDrops(this.getPlayer().getInventory().getItemInMainHand()), ItemSpawnReason.BONUS_DROPS);
    }

    static {
        directions = new int[][]{{-2, -1}, {-2, 0}, {-2, 1}, {-1, -2}, {-1, -1}, {-1, 0}, {-1, 1}, {-1, 2}, {0, -2}, {0, -1}, {0, 1}, {0, 2}, {1, -2}, {1, -1}, {1, 0}, {1, 1}, {1, 2}, {2, -1}, {2, 0}, {2, 1}};
    }
}

