/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.events.skills;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.util.player.UserManager;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

public abstract class McMMOPlayerSkillEvent
extends PlayerEvent {
    @NotNull
    protected PrimarySkillType skill;
    protected int skillLevel;
    protected McMMOPlayer mmoPlayer;
    private static final HandlerList handlers = new HandlerList();

    @Deprecated(forRemoval=true, since="2.2.010")
    protected McMMOPlayerSkillEvent(@NotNull Player player, @NotNull PrimarySkillType skill) {
        super(player);
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        Objects.requireNonNull(mmoPlayer, "Player not found in UserManager,contact the dev and tell them to use the constructor for McMMOPlayerSkillEvent(McMMOPlayer, PrimarySkillType) instead");
        this.skill = skill;
        this.skillLevel = UserManager.getPlayer(player).getSkillLevel(skill);
    }

    protected McMMOPlayerSkillEvent(@NotNull McMMOPlayer mmoPlayer, @NotNull PrimarySkillType primarySkillType) {
        super(mmoPlayer.getPlayer());
        Objects.requireNonNull(mmoPlayer, "mmoPlayer cannot be null");
        Objects.requireNonNull(primarySkillType, "primarySkillType cannot be null");
        this.skill = primarySkillType;
        this.skillLevel = mmoPlayer.getSkillLevel(primarySkillType);
    }

    @NotNull
    public PrimarySkillType getSkill() {
        return this.skill;
    }

    public int getSkillLevel() {
        return this.skillLevel;
    }

    @NotNull
    public McMMOPlayer getMcMMOPlayer() {
        return this.mmoPlayer;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

