/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.events.fake.FakeBrewEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerUpdateInventoryTask;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.alchemy.AlchemyPotionBrewer;
import com.gmail.nossr50.util.ContainerMetadataUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Furnace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permissible;

public class InventoryListener
implements Listener {
    private final mcMMO plugin;

    public InventoryListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceBurnEvent(FurnaceBurnEvent event) {
        ItemStack smelting;
        if (WorldBlacklist.isWorldBlacklisted(event.getBlock().getWorld())) {
            return;
        }
        Block furnaceBlock = event.getBlock();
        BlockState furnaceState = furnaceBlock.getState();
        ItemStack itemStack = smelting = furnaceState instanceof Furnace ? ((Furnace)furnaceState).getInventory().getSmelting() : null;
        if (!ItemUtils.isSmeltable(smelting) || event.getBurnTime() <= 0) {
            return;
        }
        Furnace furnace = (Furnace)furnaceState;
        OfflinePlayer offlinePlayer = ContainerMetadataUtils.getContainerOwner((BlockState)furnace);
        if (offlinePlayer != null && offlinePlayer.isOnline() && offlinePlayer instanceof Player) {
            Player player = (Player)offlinePlayer;
            if (!Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.SMELTING_FUEL_EFFICIENCY)) {
                return;
            }
            McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
            if (mmoPlayer != null) {
                boolean debugMode = mmoPlayer.isDebugMode();
                if (debugMode) {
                    player.sendMessage("FURNACE FUEL EFFICIENCY DEBUG REPORT");
                    player.sendMessage("Furnace - " + furnace.hashCode());
                    player.sendMessage("Furnace Type: " + String.valueOf(furnaceBlock.getType()));
                    player.sendMessage("Burn Length before Fuel Efficiency is applied - " + event.getBurnTime());
                }
                event.setBurnTime(mmoPlayer.getSmeltingManager().fuelEfficiency(event.getBurnTime()));
                if (debugMode) {
                    player.sendMessage("New Furnace Burn Length (after applying fuel efficiency) " + event.getBurnTime());
                    player.sendMessage("");
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceSmeltEvent(FurnaceSmeltEvent event) {
        McMMOPlayer offlineProfile;
        Furnace furnace;
        OfflinePlayer offlinePlayer;
        if (WorldBlacklist.isWorldBlacklisted(event.getBlock().getWorld())) {
            return;
        }
        BlockState blockState = event.getBlock().getState();
        ItemStack smelting = event.getSource();
        if (!ItemUtils.isSmeltable(smelting)) {
            return;
        }
        if (blockState instanceof Furnace && (offlinePlayer = ContainerMetadataUtils.getContainerOwner((BlockState)(furnace = (Furnace)blockState))) != null && (offlineProfile = UserManager.getOfflinePlayer(offlinePlayer)) != null) {
            offlineProfile.getSmeltingManager().smeltProcessing(event, furnace);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceExtractEvent(FurnaceExtractEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getPlayer().getWorld())) {
            return;
        }
        BlockState furnaceBlock = event.getBlock().getState();
        if (!ItemUtils.isSmelted(new ItemStack(event.getItemType(), event.getItemAmount()))) {
            return;
        }
        Player player = event.getPlayer();
        if (furnaceBlock instanceof Furnace) {
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                return;
            }
            if (!UserManager.hasPlayerDataKey((Entity)player) || !Permissions.vanillaXpBoost((Permissible)player, PrimarySkillType.SMELTING)) {
                return;
            }
            if (UserManager.getPlayer(player) == null) {
                return;
            }
            int xpToDrop = event.getExpToDrop();
            int exp = UserManager.getPlayer(player).getSmeltingManager().vanillaXPBoost(xpToDrop);
            event.setExpToDrop(exp);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryClickEventNormal(InventoryClickEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getWhoClicked().getWorld())) {
            return;
        }
        Inventory inventory = event.getInventory();
        Player player = ((Player)event.getWhoClicked()).getPlayer();
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        Inventory inventory2 = event.getInventory();
        if (inventory2 instanceof FurnaceInventory) {
            FurnaceInventory furnaceInventory = (FurnaceInventory)inventory2;
            if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.SMELTING)) {
                return;
            }
            ContainerMetadataUtils.processContainerOwnership((BlockState)furnaceInventory.getHolder(), player);
        }
        if ((inventory2 = event.getInventory()) instanceof BrewerInventory) {
            BrewerInventory brewerInventory = (BrewerInventory)inventory2;
            if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.ALCHEMY)) {
                return;
            }
            ContainerMetadataUtils.processContainerOwnership((BlockState)brewerInventory.getHolder(), player);
        }
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof BrewingStand)) {
            return;
        }
        BrewingStand stand = (BrewingStand)holder;
        HumanEntity whoClicked = event.getWhoClicked();
        if (mmoPlayer == null || !Permissions.isSubSkillEnabled((Permissible)whoClicked, SubSkillType.ALCHEMY_CONCOCTIONS)) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        ItemStack cursor = event.getCursor();
        if (clicked != null && (clicked.getType() == Material.POTION || clicked.getType() == Material.SPLASH_POTION || clicked.getType() == Material.LINGERING_POTION) || cursor != null && (cursor.getType() == Material.POTION || cursor.getType() == Material.SPLASH_POTION || cursor.getType() == Material.LINGERING_POTION)) {
            AlchemyPotionBrewer.scheduleCheck(stand);
            return;
        }
        ClickType click = event.getClick();
        InventoryType.SlotType slot = event.getSlotType();
        if (click.isShiftClick()) {
            switch (slot) {
                case FUEL: {
                    AlchemyPotionBrewer.scheduleCheck(stand);
                    return;
                }
                case CONTAINER: 
                case QUICKBAR: {
                    if (!AlchemyPotionBrewer.isValidIngredientByPlayer(player, clicked)) {
                        return;
                    }
                    if (!AlchemyPotionBrewer.transferItems(event.getView(), event.getRawSlot(), click)) {
                        return;
                    }
                    event.setCancelled(true);
                    AlchemyPotionBrewer.scheduleUpdate(inventory);
                    AlchemyPotionBrewer.scheduleCheck(stand);
                    return;
                }
            }
        } else if (slot == InventoryType.SlotType.FUEL) {
            boolean emptyClicked = AlchemyPotionBrewer.isEmpty(clicked);
            if (AlchemyPotionBrewer.isEmpty(cursor)) {
                if (emptyClicked && click == ClickType.NUMBER_KEY) {
                    AlchemyPotionBrewer.scheduleCheck(stand);
                    return;
                }
                AlchemyPotionBrewer.scheduleCheck(stand);
            } else if (emptyClicked && AlchemyPotionBrewer.isValidIngredientByPlayer(player, cursor)) {
                int amount = cursor.getAmount();
                if (click == ClickType.LEFT || click == ClickType.RIGHT && amount == 1) {
                    event.setCancelled(true);
                    event.setCurrentItem(cursor.clone());
                    event.setCursor(null);
                    AlchemyPotionBrewer.scheduleUpdate(inventory);
                    AlchemyPotionBrewer.scheduleCheck(stand);
                } else if (click == ClickType.RIGHT) {
                    event.setCancelled(true);
                    ItemStack one = cursor.clone();
                    one.setAmount(1);
                    ItemStack rest = cursor.clone();
                    rest.setAmount(amount - 1);
                    event.setCurrentItem(one);
                    event.setCursor(rest);
                    AlchemyPotionBrewer.scheduleUpdate(inventory);
                    AlchemyPotionBrewer.scheduleCheck(stand);
                }
            }
        }
    }

    public boolean isOutsideWindowClick(InventoryClickEvent event) {
        return event.getHotbarButton() == -1;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryDragEvent(InventoryDragEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getWhoClicked().getWorld())) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof BrewingStand)) {
            return;
        }
        HumanEntity whoClicked = event.getWhoClicked();
        if (!UserManager.hasPlayerDataKey((Entity)event.getWhoClicked()) || !Permissions.isSubSkillEnabled((Permissible)whoClicked, SubSkillType.ALCHEMY_CONCOCTIONS)) {
            return;
        }
        if (!event.getInventorySlots().contains(3)) {
            return;
        }
        ItemStack cursor = event.getCursor();
        ItemStack ingredient = ((BrewerInventory)inventory).getIngredient();
        if (AlchemyPotionBrewer.isEmpty(ingredient) || ingredient.isSimilar(cursor)) {
            Player player = (Player)whoClicked;
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                return;
            }
            if (AlchemyPotionBrewer.isValidIngredientByPlayer(player, cursor)) {
                AlchemyPotionBrewer.scheduleCheck((BrewingStand)holder);
                return;
            }
            event.setCancelled(true);
            AlchemyPotionBrewer.scheduleUpdate(inventory);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBrew(BrewEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getBlock().getWorld())) {
            return;
        }
        if (event instanceof FakeBrewEvent) {
            return;
        }
        Location location = event.getBlock().getLocation();
        if (Alchemy.brewingStandMap.containsKey(location)) {
            Alchemy.brewingStandMap.get(location).finishImmediately();
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        if (event.getSource().getLocation() != null && WorldBlacklist.isWorldBlacklisted(event.getSource().getLocation().getWorld())) {
            return;
        }
        Inventory inventory = event.getDestination();
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof BrewingStand) {
            McMMOPlayer mmoPlayer;
            BrewingStand brewingStand = (BrewingStand)holder;
            ItemStack item = event.getItem();
            if (mcMMO.p.getGeneralConfig().getPreventHopperTransferIngredients() && item.getType() != Material.POTION && item.getType() != Material.SPLASH_POTION && item.getType() != Material.LINGERING_POTION) {
                event.setCancelled(true);
                return;
            }
            if (mcMMO.p.getGeneralConfig().getPreventHopperTransferBottles() && (item.getType() == Material.POTION || item.getType() == Material.SPLASH_POTION || item.getType() == Material.LINGERING_POTION)) {
                event.setCancelled(true);
                return;
            }
            int ingredientLevel = 1;
            OfflinePlayer offlinePlayer = ContainerMetadataUtils.getContainerOwner((BlockState)brewingStand);
            if (offlinePlayer != null && offlinePlayer.isOnline() && (mmoPlayer = UserManager.getPlayer(offlinePlayer.getPlayer())) != null) {
                ingredientLevel = mmoPlayer.getAlchemyManager().getTier();
            }
            if (mcMMO.p.getGeneralConfig().getEnabledForHoppers() && AlchemyPotionBrewer.isValidIngredientByLevel(ingredientLevel, item)) {
                AlchemyPotionBrewer.scheduleCheck(brewingStand);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (event.getCurrentItem() == null) {
            return;
        }
        SkillUtils.removeAbilityBuff(event.getCurrentItem());
        if (event.getAction() == InventoryAction.HOTBAR_SWAP) {
            if (this.isOutsideWindowClick(event)) {
                return;
            }
            PlayerInventory playerInventory = event.getWhoClicked().getInventory();
            if (playerInventory.getItem(event.getHotbarButton()) != null) {
                SkillUtils.removeAbilityBuff(playerInventory.getItem(event.getHotbarButton()));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpenEvent(InventoryOpenEvent event) {
        SkillUtils.removeAbilityBuff(event.getPlayer().getInventory().getItemInMainHand());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraftItem(CraftItemEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getWhoClicked().getWorld())) {
            return;
        }
        HumanEntity whoClicked = event.getWhoClicked();
        if (!whoClicked.hasMetadata("mcMMO: Player Data")) {
            return;
        }
        ItemStack result = event.getRecipe().getResult();
        if (!ItemUtils.isMcMMOItem(result)) {
            return;
        }
        Player player = (Player)whoClicked;
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        mcMMO.p.getFoliaLib().getScheduler().runAtEntity((Entity)whoClicked, (Consumer)new PlayerUpdateInventoryTask((Player)whoClicked));
    }
}

