/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.api.exceptions.InvalidSkillException;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.player.UniqueDataType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.database.tomcat.jdbc.pool.DataSource;
import com.gmail.nossr50.mcmmo.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.runnables.database.UUIDUpdateAsyncTask;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.skills.SkillTools;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SQLDatabaseManager
implements DatabaseManager {
    private static final String ALL_QUERY_VERSION = "total";
    public static final String MOBHEALTHBAR_VARCHAR = "VARCHAR(50)";
    public static final String UUID_VARCHAR = "VARCHAR(36)";
    public static final String USER_VARCHAR = "VARCHAR(40)";
    public static final int CHILD_SKILLS_SIZE = 2;
    public static final String LEGACY_DRIVER_PATH = "com.mysql.jdbc.Driver";
    public static final int MAGIC_NUMBER = 44;
    private final String tablePrefix = mcMMO.p.getGeneralConfig().getMySQLTablePrefix();
    private final Map<UUID, Integer> cachedUserIDs = new HashMap<UUID, Integer>();
    private DataSource miscPool;
    private DataSource loadPool;
    private DataSource savePool;
    private boolean debug = false;
    private final ReentrantLock massUpdateLock = new ReentrantLock();
    private final String CHARSET_SQL = "utf8mb4";
    private final Logger logger;
    private final boolean h2;

    SQLDatabaseManager(Logger logger, String driverPath) {
        this(logger, driverPath, false);
    }

    SQLDatabaseManager(Logger logger, String driverPath, boolean h2) {
        this.logger = logger;
        this.h2 = h2;
        Object connectionString = SQLDatabaseManager.getConnectionString(h2);
        if (!h2 && mcMMO.p.getGeneralConfig().getMySQLPublicKeyRetrieval()) {
            connectionString = (String)connectionString + "&allowPublicKeyRetrieval=true";
        }
        try {
            Class.forName(driverPath);
        }
        catch (ClassNotFoundException e) {
            try {
                driverPath = LEGACY_DRIVER_PATH;
                Class.forName(driverPath);
            }
            catch (ClassNotFoundException ex) {
                e.printStackTrace();
                ex.printStackTrace();
                logger.severe("Neither driver found");
                return;
            }
        }
        this.debug = mcMMO.p.getGeneralConfig().getMySQLDebug();
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setDriverClassName(driverPath);
        poolProperties.setUrl((String)connectionString);
        poolProperties.setUsername(mcMMO.p.getGeneralConfig().getMySQLUserName());
        poolProperties.setPassword(mcMMO.p.getGeneralConfig().getMySQLUserPassword());
        poolProperties.setMaxIdle(mcMMO.p.getGeneralConfig().getMySQLMaxPoolSize(PoolIdentifier.MISC));
        poolProperties.setMaxActive(mcMMO.p.getGeneralConfig().getMySQLMaxConnections(PoolIdentifier.MISC));
        poolProperties.setInitialSize(0);
        poolProperties.setMaxWait(-1);
        poolProperties.setRemoveAbandoned(true);
        poolProperties.setRemoveAbandonedTimeout(60);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery("SELECT 1");
        poolProperties.setValidationInterval(30000L);
        this.miscPool = new DataSource(poolProperties);
        poolProperties = new PoolProperties();
        poolProperties.setDriverClassName(driverPath);
        poolProperties.setUrl((String)connectionString);
        poolProperties.setUsername(mcMMO.p.getGeneralConfig().getMySQLUserName());
        poolProperties.setPassword(mcMMO.p.getGeneralConfig().getMySQLUserPassword());
        poolProperties.setInitialSize(0);
        poolProperties.setMaxIdle(mcMMO.p.getGeneralConfig().getMySQLMaxPoolSize(PoolIdentifier.SAVE));
        poolProperties.setMaxActive(mcMMO.p.getGeneralConfig().getMySQLMaxConnections(PoolIdentifier.SAVE));
        poolProperties.setMaxWait(-1);
        poolProperties.setRemoveAbandoned(true);
        poolProperties.setRemoveAbandonedTimeout(60);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery("SELECT 1");
        poolProperties.setValidationInterval(30000L);
        this.savePool = new DataSource(poolProperties);
        poolProperties = new PoolProperties();
        poolProperties.setDriverClassName(driverPath);
        poolProperties.setUrl((String)connectionString);
        poolProperties.setUsername(mcMMO.p.getGeneralConfig().getMySQLUserName());
        poolProperties.setPassword(mcMMO.p.getGeneralConfig().getMySQLUserPassword());
        poolProperties.setInitialSize(0);
        poolProperties.setMaxIdle(mcMMO.p.getGeneralConfig().getMySQLMaxPoolSize(PoolIdentifier.LOAD));
        poolProperties.setMaxActive(mcMMO.p.getGeneralConfig().getMySQLMaxConnections(PoolIdentifier.LOAD));
        poolProperties.setMaxWait(-1);
        poolProperties.setRemoveAbandoned(true);
        poolProperties.setRemoveAbandonedTimeout(60);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery("SELECT 1");
        poolProperties.setValidationInterval(30000L);
        this.loadPool = new DataSource(poolProperties);
        this.checkStructure();
    }

    @NotNull
    private static String getConnectionString(boolean h2) {
        if (h2) {
            return "jdbc:h2:mem:testdb;DB_CLOSE_DELAY=-1;MODE=MySQL";
        }
        String connectionString = "jdbc:mysql://" + mcMMO.p.getGeneralConfig().getMySQLServerName() + ":" + mcMMO.p.getGeneralConfig().getMySQLServerPort() + "/" + mcMMO.p.getGeneralConfig().getMySQLDatabaseName();
        connectionString = !mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 17, 0) && mcMMO.p.getGeneralConfig().getMySQLSSL() ? connectionString + "?verifyServerCertificate=false&useSSL=true&requireSSL=true" : connectionString + "?useSSL=false";
        return connectionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int purgePowerlessUsers() {
        this.massUpdateLock.lock();
        this.logger.info("Purging powerless users...");
        Connection connection = null;
        Statement statement = null;
        int purged = 0;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.createStatement();
            purged = statement.executeUpdate("DELETE FROM " + this.tablePrefix + "skills WHERE taming = 0 AND mining = 0 AND woodcutting = 0 AND repair = 0 AND unarmed = 0 AND herbalism = 0 AND excavation = 0 AND archery = 0 AND swords = 0 AND axes = 0 AND acrobatics = 0 AND fishing = 0 AND alchemy = 0 AND crossbows = 0 AND tridents = 0 AND maces = 0;");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "experience` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "experience`.`user_id` = `s`.`user_id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "huds` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "huds`.`user_id` = `s`.`user_id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "cooldowns` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "cooldowns`.`user_id` = `s`.`user_id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "users` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "users`.`id` = `s`.`user_id`)");
            this.tryClose(statement);
            this.tryClose(connection);
            this.massUpdateLock.unlock();
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
            }
            catch (Throwable throwable) {
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
                throw throwable;
            }
        }
        this.logger.info("Purged " + purged + " users from the database.");
        return purged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeOldUsers() {
        this.massUpdateLock.lock();
        this.logger.info("Purging inactive users older than " + mcMMO.p.getPurgeTime() / 2630000000L + " months...");
        Connection connection = null;
        Statement statement = null;
        int purged = 0;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.createStatement();
            purged = statement.executeUpdate("DELETE FROM u, e, h, s, c USING " + this.tablePrefix + "users u JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) WHERE ((UNIX_TIMESTAMP() - lastlogin) > " + mcMMO.p.getPurgeTime() + ")");
            this.tryClose(statement);
            this.tryClose(connection);
            this.massUpdateLock.unlock();
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
            }
            catch (Throwable throwable) {
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
                throw throwable;
            }
        }
        this.logger.info("Purged " + purged + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(String playerName, UUID uuid) {
        boolean success = false;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("DELETE FROM u, e, h, s, c USING " + this.tablePrefix + "users u JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) WHERE u.`user` = ?");
            statement.setString(1, playerName);
            success = statement.executeUpdate() != 0;
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(statement);
            this.tryClose(connection);
        }
        if (success) {
            if (uuid != null) {
                this.cleanupUser(uuid);
            }
            Misc.profileCleanup(playerName);
        }
        return success;
    }

    @Override
    public void cleanupUser(UUID uuid) {
        this.cachedUserIDs.remove(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveUser(PlayerProfile profile) {
        Connection connection;
        PreparedStatement statement;
        boolean success;
        block22: {
            boolean bl;
            block21: {
                boolean bl2;
                block20: {
                    boolean bl3;
                    block19: {
                        boolean bl4;
                        block18: {
                            boolean bl5;
                            block17: {
                                success = true;
                                statement = null;
                                connection = null;
                                try {
                                    connection = this.getConnection(PoolIdentifier.SAVE);
                                    int id = this.getUserID(connection, profile.getPlayerName(), profile.getUniqueId());
                                    if (id == -1 && (id = this.newUser(connection, profile.getPlayerName(), profile.getUniqueId())) == -1) {
                                        this.logger.severe("Failed to create new account for " + profile.getPlayerName());
                                        boolean bl6 = false;
                                        this.tryClose(statement);
                                        this.tryClose(connection);
                                        return bl6;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "users SET lastlogin = UNIX_TIMESTAMP() WHERE id = ?");
                                    statement.setInt(1, id);
                                    boolean bl7 = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!(success &= bl7)) {
                                        this.logger.severe("Failed to update last login for " + profile.getPlayerName());
                                        bl5 = false;
                                        this.tryClose(statement);
                                        break block17;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "skills SET  taming = ?, mining = ?, repair = ?, woodcutting = ?, unarmed = ?, herbalism = ?, excavation = ?, archery = ?, swords = ?, axes = ?, acrobatics = ?, fishing = ?, alchemy = ?, crossbows = ?, tridents = ?, maces = ?, total = ? WHERE user_id = ?");
                                    statement.setInt(1, profile.getSkillLevel(PrimarySkillType.TAMING));
                                    statement.setInt(2, profile.getSkillLevel(PrimarySkillType.MINING));
                                    statement.setInt(3, profile.getSkillLevel(PrimarySkillType.REPAIR));
                                    statement.setInt(4, profile.getSkillLevel(PrimarySkillType.WOODCUTTING));
                                    statement.setInt(5, profile.getSkillLevel(PrimarySkillType.UNARMED));
                                    statement.setInt(6, profile.getSkillLevel(PrimarySkillType.HERBALISM));
                                    statement.setInt(7, profile.getSkillLevel(PrimarySkillType.EXCAVATION));
                                    statement.setInt(8, profile.getSkillLevel(PrimarySkillType.ARCHERY));
                                    statement.setInt(9, profile.getSkillLevel(PrimarySkillType.SWORDS));
                                    statement.setInt(10, profile.getSkillLevel(PrimarySkillType.AXES));
                                    statement.setInt(11, profile.getSkillLevel(PrimarySkillType.ACROBATICS));
                                    statement.setInt(12, profile.getSkillLevel(PrimarySkillType.FISHING));
                                    statement.setInt(13, profile.getSkillLevel(PrimarySkillType.ALCHEMY));
                                    statement.setInt(14, profile.getSkillLevel(PrimarySkillType.CROSSBOWS));
                                    statement.setInt(15, profile.getSkillLevel(PrimarySkillType.TRIDENTS));
                                    statement.setInt(16, profile.getSkillLevel(PrimarySkillType.MACES));
                                    int total = 0;
                                    for (PrimarySkillType primarySkillType : SkillTools.NON_CHILD_SKILLS) {
                                        total += profile.getSkillLevel(primarySkillType);
                                    }
                                    statement.setInt(17, total);
                                    statement.setInt(18, id);
                                    boolean bl8 = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!(success &= bl8)) {
                                        this.logger.severe("Failed to update skills for " + profile.getPlayerName());
                                        bl4 = false;
                                        this.tryClose(statement);
                                        break block18;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "experience SET  taming = ?, mining = ?, repair = ?, woodcutting = ?, unarmed = ?, herbalism = ?, excavation = ?, archery = ?, swords = ?, axes = ?, acrobatics = ?, fishing = ?, alchemy = ?, crossbows = ?, tridents = ?, maces = ? WHERE user_id = ?");
                                    statement.setInt(1, profile.getSkillXpLevel(PrimarySkillType.TAMING));
                                    statement.setInt(2, profile.getSkillXpLevel(PrimarySkillType.MINING));
                                    statement.setInt(3, profile.getSkillXpLevel(PrimarySkillType.REPAIR));
                                    statement.setInt(4, profile.getSkillXpLevel(PrimarySkillType.WOODCUTTING));
                                    statement.setInt(5, profile.getSkillXpLevel(PrimarySkillType.UNARMED));
                                    statement.setInt(6, profile.getSkillXpLevel(PrimarySkillType.HERBALISM));
                                    statement.setInt(7, profile.getSkillXpLevel(PrimarySkillType.EXCAVATION));
                                    statement.setInt(8, profile.getSkillXpLevel(PrimarySkillType.ARCHERY));
                                    statement.setInt(9, profile.getSkillXpLevel(PrimarySkillType.SWORDS));
                                    statement.setInt(10, profile.getSkillXpLevel(PrimarySkillType.AXES));
                                    statement.setInt(11, profile.getSkillXpLevel(PrimarySkillType.ACROBATICS));
                                    statement.setInt(12, profile.getSkillXpLevel(PrimarySkillType.FISHING));
                                    statement.setInt(13, profile.getSkillXpLevel(PrimarySkillType.ALCHEMY));
                                    statement.setInt(14, profile.getSkillXpLevel(PrimarySkillType.CROSSBOWS));
                                    statement.setInt(15, profile.getSkillXpLevel(PrimarySkillType.TRIDENTS));
                                    statement.setInt(16, profile.getSkillXpLevel(PrimarySkillType.MACES));
                                    statement.setInt(17, id);
                                    boolean bl9 = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!(success &= bl9)) {
                                        this.logger.severe("Failed to update experience for " + profile.getPlayerName());
                                        bl3 = false;
                                        this.tryClose(statement);
                                        break block19;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "cooldowns SET   mining = ?, woodcutting = ?, unarmed = ?, herbalism = ?, excavation = ?, swords = ?, axes = ?, blast_mining = ?, chimaera_wing = ?, crossbows = ?, tridents = ?, maces = ? WHERE user_id = ?");
                                    statement.setLong(1, profile.getAbilityDATS(SuperAbilityType.SUPER_BREAKER));
                                    statement.setLong(2, profile.getAbilityDATS(SuperAbilityType.TREE_FELLER));
                                    statement.setLong(3, profile.getAbilityDATS(SuperAbilityType.BERSERK));
                                    statement.setLong(4, profile.getAbilityDATS(SuperAbilityType.GREEN_TERRA));
                                    statement.setLong(5, profile.getAbilityDATS(SuperAbilityType.GIGA_DRILL_BREAKER));
                                    statement.setLong(6, profile.getAbilityDATS(SuperAbilityType.SERRATED_STRIKES));
                                    statement.setLong(7, profile.getAbilityDATS(SuperAbilityType.SKULL_SPLITTER));
                                    statement.setLong(8, profile.getAbilityDATS(SuperAbilityType.BLAST_MINING));
                                    statement.setLong(9, profile.getUniqueData(UniqueDataType.CHIMAERA_WING_DATS));
                                    statement.setLong(10, profile.getAbilityDATS(SuperAbilityType.SUPER_SHOTGUN));
                                    statement.setLong(11, profile.getAbilityDATS(SuperAbilityType.TRIDENTS_SUPER_ABILITY));
                                    statement.setLong(12, profile.getAbilityDATS(SuperAbilityType.MACES_SUPER_ABILITY));
                                    statement.setInt(13, id);
                                    success = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!success) {
                                        this.logger.severe("Failed to update cooldowns for " + profile.getPlayerName());
                                        bl2 = false;
                                        this.tryClose(statement);
                                        break block20;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "huds SET mobhealthbar = ?, scoreboardtips = ? WHERE user_id = ?");
                                    statement.setString(1, MobHealthbarType.HEARTS.name());
                                    statement.setInt(2, profile.getScoreboardTipsShown());
                                    statement.setInt(3, id);
                                    success = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!success) {
                                        this.logger.severe("Failed to update hud settings for " + profile.getPlayerName());
                                        bl = false;
                                        this.tryClose(statement);
                                        break block21;
                                    }
                                    this.tryClose(statement);
                                    break block22;
                                }
                                catch (SQLException ex) {
                                    this.printErrors(ex);
                                    return success;
                                }
                            }
                            this.tryClose(connection);
                            return bl5;
                        }
                        this.tryClose(connection);
                        return bl4;
                    }
                    this.tryClose(connection);
                    return bl3;
                }
                this.tryClose(connection);
                return bl2;
            }
            this.tryClose(connection);
            return bl;
        }
        this.tryClose(connection);
        return success;
        finally {
            this.tryClose(statement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<PlayerStat> readLeaderboard(@Nullable PrimarySkillType skill, int pageNumber, int statsPerPage) throws InvalidSkillException {
        ArrayList<PlayerStat> stats = new ArrayList<PlayerStat>();
        if (skill != null && SkillTools.isChildSkill(skill)) {
            this.logger.severe("A plugin hooking into mcMMO is being naughty with our database commands, update all plugins that hook into mcMMO and contact their devs!");
            throw new InvalidSkillException("A plugin hooking into mcMMO that you are using is attempting to read leaderboard skills for child skills, child skills do not have leaderboards! This is NOT an mcMMO error!");
        }
        String query = skill == null ? ALL_QUERY_VERSION : skill.name().toLowerCase(Locale.ENGLISH);
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("SELECT " + query + ", `user` FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON (user_id = id) WHERE " + query + " > 0 AND NOT `user` = '\\_INVALID\\_OLD\\_USERNAME\\_' ORDER BY " + query + " DESC, `user` LIMIT ?, ?");
            statement.setInt(1, pageNumber * statsPerPage - statsPerPage);
            statement.setInt(2, statsPerPage);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                ArrayList<String> column = new ArrayList<String>();
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    column.add(resultSet.getString(i));
                }
                stats.add(new PlayerStat((String)column.get(1), Integer.parseInt((String)column.get(0))));
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<PrimarySkillType, Integer> readRank(String playerName) {
        HashMap<PrimarySkillType, Integer> skills = new HashMap<PrimarySkillType, Integer>();
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            for (PrimarySkillType primarySkillType : SkillTools.NON_CHILD_SKILLS) {
                String skillName = primarySkillType.name().toLowerCase(Locale.ENGLISH);
                String sql = "SELECT COUNT(*) AS 'rank' FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + skillName + " > 0 AND " + skillName + " > (SELECT " + skillName + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE `user` = ?)";
                statement = connection.prepareStatement(sql);
                statement.setString(1, playerName);
                resultSet = statement.executeQuery();
                resultSet.next();
                int rank = resultSet.getInt("rank");
                sql = "SELECT user, " + skillName + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + skillName + " > 0 AND " + skillName + " = (SELECT " + skillName + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE `user` = '" + playerName + "') ORDER BY user";
                resultSet.close();
                statement.close();
                statement = connection.prepareStatement(sql);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    if (!resultSet.getString("user").equalsIgnoreCase(playerName)) continue;
                    skills.put(primarySkillType, rank + resultSet.getRow());
                    break;
                }
                resultSet.close();
                statement.close();
            }
            String sql = "SELECT COUNT(*) AS 'rank' FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE total > 0 AND total > (SELECT total FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE `user` = ?)";
            statement = connection.prepareStatement(sql);
            statement.setString(1, playerName);
            resultSet = statement.executeQuery();
            resultSet.next();
            int rank = resultSet.getInt("rank");
            resultSet.close();
            statement.close();
            sql = "SELECT user, total FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE total > 0 AND total = (SELECT total FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE `user` = ?) ORDER BY user";
            statement = connection.prepareStatement(sql);
            statement.setString(1, playerName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (!resultSet.getString("user").equalsIgnoreCase(playerName)) continue;
                skills.put(null, rank + resultSet.getRow());
                break;
            }
            resultSet.close();
            statement.close();
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        return skills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PlayerProfile newUser(String playerName, UUID uuid) {
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            this.newUser(connection, playerName, uuid);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(connection);
        }
        return new PlayerProfile(playerName, uuid, true, mcMMO.p.getAdvancedConfig().getStartingLevel());
    }

    @Override
    @NotNull
    public PlayerProfile newUser(@NotNull Player player) {
        try {
            Connection connection = this.getConnection(PoolIdentifier.SAVE);
            int id = this.newUser(connection, player.getName(), player.getUniqueId());
            if (id == -1) {
                return new PlayerProfile(player.getName(), player.getUniqueId(), false, mcMMO.p.getAdvancedConfig().getStartingLevel());
            }
            return this.loadPlayerProfile((OfflinePlayer)player);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return new PlayerProfile(player.getName(), player.getUniqueId(), false, mcMMO.p.getAdvancedConfig().getStartingLevel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newUser(Connection connection, String playerName, UUID uuid) {
        block7: {
            int n;
            ResultSet resultSet = null;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement("UPDATE `" + this.tablePrefix + "users` SET `user` = ? WHERE `user` = ?");
                statement.setString(1, "_INVALID_OLD_USERNAME_");
                statement.setString(2, playerName);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement("INSERT INTO " + this.tablePrefix + "users (user, uuid, lastlogin) VALUES (?, ?, UNIX_TIMESTAMP())", 1);
                statement.setString(1, playerName);
                statement.setString(2, uuid != null ? uuid.toString() : null);
                statement.executeUpdate();
                resultSet = statement.getGeneratedKeys();
                if (!resultSet.next()) {
                    this.logger.severe("Unable to create new user account in DB");
                    int n2 = -1;
                    this.tryClose(resultSet);
                    this.tryClose(statement);
                    return n2;
                }
                this.writeMissingRows(connection, resultSet.getInt(1));
                n = resultSet.getInt(1);
                this.tryClose(resultSet);
            }
            catch (SQLException ex) {
                this.printErrors(ex);
                break block7;
            }
            finally {
                this.tryClose(resultSet);
                this.tryClose(statement);
            }
            this.tryClose(statement);
            return n;
        }
        return -1;
    }

    @Override
    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull String playerName) {
        try {
            return this.loadPlayerFromDB(null, playerName);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return new PlayerProfile(playerName, false, mcMMO.p.getAdvancedConfig().getStartingLevel());
        }
    }

    @Override
    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull OfflinePlayer offlinePlayer) {
        return this.loadPlayerFromDB(offlinePlayer.getUniqueId(), offlinePlayer.getName());
    }

    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull UUID uuid, @Nullable String playerName) {
        return this.loadPlayerFromDB(uuid, playerName);
    }

    @Override
    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull UUID uuid) {
        return this.loadPlayerFromDB(uuid, null);
    }

    /*
     * Exception decompiling
     */
    private PlayerProfile loadPlayerFromDB(@Nullable UUID uuid, @Nullable String playerName) throws RuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertUsers(DatabaseManager destination) {
        PreparedStatement statement = null;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("SELECT s.taming, s.mining, s.repair, s.woodcutting, s.unarmed, s.herbalism, s.excavation, s.archery, s.swords, s.axes, s.acrobatics, s.fishing, s.alchemy, e.taming, e.mining, e.repair, e.woodcutting, e.unarmed, e.herbalism, e.excavation, e.archery, e.swords, e.axes, e.acrobatics, e.fishing, e.alchemy, c.taming, c.mining, c.repair, c.woodcutting, c.unarmed, c.herbalism, c.excavation, c.archery, c.swords, c.axes, c.acrobatics, c.blast_mining, c.chimaera_wing, h.mobhealthbar, h.scoreboardtips, u.uuid FROM " + this.tablePrefix + "users u JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) WHERE u.`user` = ?");
            List<String> usernames = this.getStoredUsers();
            int convertedUsers = 0;
            long startMillis = System.currentTimeMillis();
            for (String playerName : usernames) {
                statement.setString(1, playerName);
                try {
                    resultSet = statement.executeQuery();
                    resultSet.next();
                    destination.saveUser(this.loadFromResult(playerName, resultSet));
                    resultSet.close();
                }
                catch (SQLException e) {
                    this.printErrors(e);
                }
                Misc.printProgress(++convertedUsers, 200, startMillis);
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException e) {
            this.printErrors(e);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUID(String userName, UUID uuid) {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("UPDATE `" + this.tablePrefix + "users` SET   uuid = ? WHERE `user` = ?");
            statement.setString(1, uuid.toString());
            statement.setString(2, userName);
            statement.execute();
            boolean bl = true;
            this.tryClose(statement);
            this.tryClose(connection);
            return bl;
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                boolean bl = false;
                this.tryClose(statement);
                this.tryClose(connection);
                return bl;
            }
            catch (Throwable throwable) {
                this.tryClose(statement);
                this.tryClose(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUIDs(Map<String, UUID> fetchedUUIDs) {
        PreparedStatement statement = null;
        int count = 0;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "users SET uuid = ? WHERE `user` = ?");
            for (Map.Entry<String, UUID> entry : fetchedUUIDs.entrySet()) {
                statement.setString(1, entry.getValue().toString());
                statement.setString(2, entry.getKey());
                statement.addBatch();
                if (++count % 500 != 0) continue;
                statement.executeBatch();
                count = 0;
            }
            if (count != 0) {
                statement.executeBatch();
            }
            boolean bl = true;
            this.tryClose(statement);
            this.tryClose(connection);
            return bl;
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                boolean bl = false;
                this.tryClose(statement);
                this.tryClose(connection);
                return bl;
            }
            catch (Throwable throwable) {
                this.tryClose(statement);
                this.tryClose(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoredUsers() {
        ArrayList<String> users = new ArrayList<String>();
        Statement statement = null;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT `user` FROM " + this.tablePrefix + "users");
            while (resultSet.next()) {
                users.add(resultSet.getString("user"));
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException e) {
            this.printErrors(e);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStructure() {
        PreparedStatement statement = null;
        Statement createStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            String schemaQuery = this.h2 ? "SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_name = ?" : "SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = ? AND table_name = ?";
            statement = connection.prepareStatement(schemaQuery);
            this.setStatementQuery(statement, "users");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                createStatement = connection.createStatement();
                String sql = "CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "users` (`id` int AUTO_INCREMENT,`user` varchar(40) NOT NULL,`uuid` varchar(36),`lastlogin` bigint NOT NULL,PRIMARY KEY (`id`),INDEX `user_index`(`user`),UNIQUE(`uuid`))";
                createStatement.executeUpdate(sql);
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            this.setStatementQuery(statement, "huds");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                createStatement = connection.createStatement();
                createStatement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "huds` (`user_id` int(10) unsigned NOT NULL,`mobhealthbar` varchar(50) NOT NULL DEFAULT '" + String.valueOf((Object)mcMMO.p.getGeneralConfig().getMobHealthbarDefault()) + "',`scoreboardtips` int(10) NOT NULL DEFAULT '0',PRIMARY KEY (`user_id`)) DEFAULT CHARSET=utf8mb4;");
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            this.setStatementQuery(statement, "cooldowns");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                createStatement = connection.createStatement();
                createStatement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "cooldowns` (`user_id` int(10) unsigned NOT NULL,`taming` int(32) unsigned NOT NULL DEFAULT '0',`mining` int(32) unsigned NOT NULL DEFAULT '0',`woodcutting` int(32) unsigned NOT NULL DEFAULT '0',`repair` int(32) unsigned NOT NULL DEFAULT '0',`unarmed` int(32) unsigned NOT NULL DEFAULT '0',`herbalism` int(32) unsigned NOT NULL DEFAULT '0',`excavation` int(32) unsigned NOT NULL DEFAULT '0',`archery` int(32) unsigned NOT NULL DEFAULT '0',`swords` int(32) unsigned NOT NULL DEFAULT '0',`axes` int(32) unsigned NOT NULL DEFAULT '0',`acrobatics` int(32) unsigned NOT NULL DEFAULT '0',`blast_mining` int(32) unsigned NOT NULL DEFAULT '0',`chimaera_wing` int(32) unsigned NOT NULL DEFAULT '0',`crossbows` int(32) unsigned NOT NULL DEFAULT '0',`tridents` int(32) unsigned NOT NULL DEFAULT '0',`maces` int(32) unsigned NOT NULL DEFAULT '0',PRIMARY KEY (`user_id`)) DEFAULT CHARSET=utf8mb4;");
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            this.setStatementQuery(statement, "skills");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                String startingLevel = "'" + mcMMO.p.getAdvancedConfig().getStartingLevel() + "'";
                String totalLevel = "'" + mcMMO.p.getAdvancedConfig().getStartingLevel() * (PrimarySkillType.values().length - 2) + "'";
                createStatement = connection.createStatement();
                createStatement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "skills` (`user_id` int(10) unsigned NOT NULL,`taming` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`mining` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`woodcutting` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`repair` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`unarmed` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`herbalism` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`excavation` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`archery` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`swords` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`axes` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`acrobatics` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`fishing` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`alchemy` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`crossbows` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`tridents` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`maces` int(10) unsigned NOT NULL DEFAULT " + startingLevel + ",`total` int(10) unsigned NOT NULL DEFAULT " + totalLevel + ",PRIMARY KEY (`user_id`)) DEFAULT CHARSET=utf8mb4;");
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            this.setStatementQuery(statement, "experience");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                createStatement = connection.createStatement();
                createStatement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "experience` (`user_id` int(10) unsigned NOT NULL,`taming` int(10) unsigned NOT NULL DEFAULT '0',`mining` int(10) unsigned NOT NULL DEFAULT '0',`woodcutting` int(10) unsigned NOT NULL DEFAULT '0',`repair` int(10) unsigned NOT NULL DEFAULT '0',`unarmed` int(10) unsigned NOT NULL DEFAULT '0',`herbalism` int(10) unsigned NOT NULL DEFAULT '0',`excavation` int(10) unsigned NOT NULL DEFAULT '0',`archery` int(10) unsigned NOT NULL DEFAULT '0',`swords` int(10) unsigned NOT NULL DEFAULT '0',`axes` int(10) unsigned NOT NULL DEFAULT '0',`acrobatics` int(10) unsigned NOT NULL DEFAULT '0',`fishing` int(10) unsigned NOT NULL DEFAULT '0',`alchemy` int(10) unsigned NOT NULL DEFAULT '0',`crossbows` int(10) unsigned NOT NULL DEFAULT '0',`tridents` int(10) unsigned NOT NULL DEFAULT '0',PRIMARY KEY (`user_id`)) DEFAULT CHARSET=utf8mb4;");
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
            for (UpgradeType updateType : UpgradeType.values()) {
                this.checkDatabaseStructure(connection, updateType);
            }
            if (mcMMO.p.getGeneralConfig().getTruncateSkills()) {
                for (PrimarySkillType skill : SkillTools.NON_CHILD_SKILLS) {
                    int cap = mcMMO.p.getSkillTools().getLevelCap(skill);
                    if (cap == Integer.MAX_VALUE) continue;
                    statement = connection.prepareStatement("UPDATE `" + this.tablePrefix + "skills` SET `" + skill.name().toLowerCase(Locale.ENGLISH) + "` = " + cap + " WHERE `" + skill.name().toLowerCase(Locale.ENGLISH) + "` > " + cap);
                    statement.executeUpdate();
                    this.tryClose(statement);
                }
            }
            LogUtils.debug(this.logger, "Killing orphans");
            createStatement = connection.createStatement();
            createStatement.executeUpdate("DELETE FROM `" + this.tablePrefix + "experience` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "experience`.`user_id` = `u`.`id`)");
            createStatement.executeUpdate("DELETE FROM `" + this.tablePrefix + "huds` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "huds`.`user_id` = `u`.`id`)");
            createStatement.executeUpdate("DELETE FROM `" + this.tablePrefix + "cooldowns` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "cooldowns`.`user_id` = `u`.`id`)");
            createStatement.executeUpdate("DELETE FROM `" + this.tablePrefix + "skills` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "skills`.`user_id` = `u`.`id`)");
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(createStatement);
            this.tryClose(connection);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(createStatement);
            this.tryClose(connection);
        }
        String skills = "skills";
        String crossbows = "crossbows";
        String tridents = "tridents";
        String maces = "maces";
        String experience = "experience";
        String cooldowns = "cooldowns";
        this.updateStructure("skills", "crossbows", String.valueOf(32));
        this.updateStructure("skills", "tridents", String.valueOf(32));
        this.updateStructure("skills", "maces", String.valueOf(32));
        this.updateStructure("experience", "crossbows", String.valueOf(10));
        this.updateStructure("experience", "tridents", String.valueOf(10));
        this.updateStructure("experience", "maces", String.valueOf(10));
        this.updateStructure("cooldowns", "crossbows", String.valueOf(10));
        this.updateStructure("cooldowns", "tridents", String.valueOf(10));
        this.updateStructure("cooldowns", "maces", String.valueOf(10));
    }

    private void updateStructure(String tableName, String columnName, String columnSize) {
        block14: {
            try (Connection connection = this.getConnection(PoolIdentifier.MISC);){
                if (this.columnExists(connection, mcMMO.p.getGeneralConfig().getMySQLDatabaseName(), this.tablePrefix + tableName, columnName)) break block14;
                try (Statement createStatement = connection.createStatement();){
                    String startingLevel = "'" + mcMMO.p.getAdvancedConfig().getStartingLevel() + "'";
                    createStatement.executeUpdate("ALTER TABLE `" + this.tablePrefix + tableName + "` ADD COLUMN `" + columnName + "` int(" + columnSize + ") unsigned NOT NULL DEFAULT " + startingLevel);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private boolean columnExists(Connection connection, String database, String tableName, String columnName) throws SQLException {
        boolean bl;
        block8: {
            Statement createStatement = connection.createStatement();
            try {
                String sql = "SELECT `COLUMN_NAME`\nFROM `INFORMATION_SCHEMA`.`COLUMNS`\nWHERE `TABLE_SCHEMA`='" + database + "'\n  AND `TABLE_NAME`='" + tableName + "'\n  AND `COLUMN_NAME`='" + columnName + "'";
                ResultSet resultSet = createStatement.executeQuery(sql);
                bl = resultSet.next();
                if (createStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (createStatement != null) {
                        try {
                            createStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.info("Failed to check if column exists in table " + tableName + " for column " + columnName);
                    e.printStackTrace();
                    throw e;
                }
            }
            createStatement.close();
        }
        return bl;
    }

    private void setStatementQuery(PreparedStatement statement, String tableName) throws SQLException {
        if (!this.h2) {
            statement.setString(1, mcMMO.p.getGeneralConfig().getMySQLDatabaseName());
            statement.setString(2, this.tablePrefix + tableName);
        } else {
            statement.setString(1, this.tablePrefix + tableName);
        }
    }

    Connection getConnection(PoolIdentifier identifier) throws SQLException {
        Connection connection;
        switch (identifier.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: {
                Connection connection2 = this.loadPool.getConnection();
                break;
            }
            case 0: {
                Connection connection2 = this.miscPool.getConnection();
                break;
            }
            case 2: {
                Connection connection2 = connection = this.savePool.getConnection();
            }
        }
        if (connection == null) {
            throw new RuntimeException("getConnection() for " + identifier.name().toLowerCase(Locale.ENGLISH) + " pool timed out.  Increase max connections settings.");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkDatabaseStructure(Connection connection, UpgradeType upgrade) {
        if (!mcMMO.getUpgradeManager().shouldUpgrade(upgrade)) {
            LogUtils.debug(this.logger, "Skipping " + upgrade.name() + " upgrade (unneeded)");
            return;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            switch (upgrade) {
                case ADD_FISHING: {
                    this.checkUpgradeAddFishing(statement);
                    return;
                }
                case ADD_BLAST_MINING_COOLDOWN: {
                    this.checkUpgradeAddBlastMiningCooldown(statement);
                    return;
                }
                case ADD_SQL_INDEXES: {
                    return;
                }
                case ADD_MOB_HEALTHBARS: {
                    this.checkUpgradeAddMobHealthbars(statement);
                    return;
                }
                case DROP_SQL_PARTY_NAMES: {
                    this.checkUpgradeDropPartyNames(statement);
                    return;
                }
                case DROP_SPOUT: {
                    this.checkUpgradeDropSpout(statement);
                    return;
                }
                case ADD_ALCHEMY: {
                    this.checkUpgradeAddAlchemy(statement);
                    return;
                }
                case ADD_UUIDS: {
                    this.checkUpgradeAddUUIDs(statement);
                    return;
                }
                case ADD_SCOREBOARD_TIPS: {
                    this.checkUpgradeAddScoreboardTips(statement);
                    return;
                }
                case DROP_NAME_UNIQUENESS: {
                    this.checkNameUniqueness(statement);
                    return;
                }
                case ADD_SKILL_TOTAL: {
                    this.checkUpgradeSkillTotal(connection);
                    return;
                }
                case ADD_UNIQUE_PLAYER_DATA: {
                    this.checkUpgradeAddUniqueChimaeraWing(statement);
                    return;
                }
                case SQL_CHARSET_UTF8MB4: {
                    this.updateCharacterSet(statement);
                    return;
                }
            }
            return;
        }
        catch (SQLException ex) {
            this.printErrors(ex);
            return;
        }
        finally {
            this.tryClose(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMissingRows(Connection connection, int id) {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "experience (user_id) VALUES (?)");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            statement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "skills (user_id) VALUES (?)");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            statement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "cooldowns (user_id) VALUES (?)");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            statement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "huds (user_id, mobhealthbar, scoreboardtips) VALUES (?, ?, ?)");
            statement.setInt(1, id);
            statement.setString(2, mcMMO.p.getGeneralConfig().getMobHealthbarDefault().name());
            statement.setInt(3, 0);
            statement.execute();
            statement.close();
            this.tryClose(statement);
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                this.tryClose(statement);
            }
            catch (Throwable throwable) {
                this.tryClose(statement);
                throw throwable;
            }
        }
    }

    private PlayerProfile loadFromResult(String playerName, ResultSet result) throws SQLException {
        UUID uuid;
        int scoreboardTipsShown;
        EnumMap<PrimarySkillType, Integer> skills = new EnumMap<PrimarySkillType, Integer>(PrimarySkillType.class);
        EnumMap<PrimarySkillType, Float> skillsXp = new EnumMap<PrimarySkillType, Float>(PrimarySkillType.class);
        EnumMap<SuperAbilityType, Integer> skillsDATS = new EnumMap<SuperAbilityType, Integer>(SuperAbilityType.class);
        EnumMap<UniqueDataType, Integer> uniqueData = new EnumMap<UniqueDataType, Integer>(UniqueDataType.class);
        int SKILL_COLUMNS = 16;
        boolean OFFSET_SKILLS = false;
        int OFFSET_XP = 16;
        int OFFSET_DATS = 32;
        int OFFSET_OTHER = 48;
        skills.put(PrimarySkillType.TAMING, result.getInt(1));
        skills.put(PrimarySkillType.MINING, result.getInt(2));
        skills.put(PrimarySkillType.REPAIR, result.getInt(3));
        skills.put(PrimarySkillType.WOODCUTTING, result.getInt(4));
        skills.put(PrimarySkillType.UNARMED, result.getInt(5));
        skills.put(PrimarySkillType.HERBALISM, result.getInt(6));
        skills.put(PrimarySkillType.EXCAVATION, result.getInt(7));
        skills.put(PrimarySkillType.ARCHERY, result.getInt(8));
        skills.put(PrimarySkillType.SWORDS, result.getInt(9));
        skills.put(PrimarySkillType.AXES, result.getInt(10));
        skills.put(PrimarySkillType.ACROBATICS, result.getInt(11));
        skills.put(PrimarySkillType.FISHING, result.getInt(12));
        skills.put(PrimarySkillType.ALCHEMY, result.getInt(13));
        skills.put(PrimarySkillType.CROSSBOWS, result.getInt(14));
        skills.put(PrimarySkillType.TRIDENTS, result.getInt(15));
        skills.put(PrimarySkillType.MACES, result.getInt(16));
        skillsXp.put(PrimarySkillType.TAMING, Float.valueOf(result.getFloat(17)));
        skillsXp.put(PrimarySkillType.MINING, Float.valueOf(result.getFloat(18)));
        skillsXp.put(PrimarySkillType.REPAIR, Float.valueOf(result.getFloat(19)));
        skillsXp.put(PrimarySkillType.WOODCUTTING, Float.valueOf(result.getFloat(20)));
        skillsXp.put(PrimarySkillType.UNARMED, Float.valueOf(result.getFloat(21)));
        skillsXp.put(PrimarySkillType.HERBALISM, Float.valueOf(result.getFloat(22)));
        skillsXp.put(PrimarySkillType.EXCAVATION, Float.valueOf(result.getFloat(23)));
        skillsXp.put(PrimarySkillType.ARCHERY, Float.valueOf(result.getFloat(24)));
        skillsXp.put(PrimarySkillType.SWORDS, Float.valueOf(result.getFloat(25)));
        skillsXp.put(PrimarySkillType.AXES, Float.valueOf(result.getFloat(26)));
        skillsXp.put(PrimarySkillType.ACROBATICS, Float.valueOf(result.getFloat(27)));
        skillsXp.put(PrimarySkillType.FISHING, Float.valueOf(result.getFloat(28)));
        skillsXp.put(PrimarySkillType.ALCHEMY, Float.valueOf(result.getFloat(29)));
        skillsXp.put(PrimarySkillType.CROSSBOWS, Float.valueOf(result.getFloat(30)));
        skillsXp.put(PrimarySkillType.TRIDENTS, Float.valueOf(result.getFloat(31)));
        skillsXp.put(PrimarySkillType.MACES, Float.valueOf(result.getFloat(32)));
        skillsDATS.put(SuperAbilityType.SUPER_BREAKER, result.getInt(34));
        skillsDATS.put(SuperAbilityType.TREE_FELLER, result.getInt(36));
        skillsDATS.put(SuperAbilityType.BERSERK, result.getInt(37));
        skillsDATS.put(SuperAbilityType.GREEN_TERRA, result.getInt(38));
        skillsDATS.put(SuperAbilityType.GIGA_DRILL_BREAKER, result.getInt(39));
        skillsDATS.put(SuperAbilityType.EXPLOSIVE_SHOT, result.getInt(40));
        skillsDATS.put(SuperAbilityType.SERRATED_STRIKES, result.getInt(41));
        skillsDATS.put(SuperAbilityType.SKULL_SPLITTER, result.getInt(42));
        skillsDATS.put(SuperAbilityType.BLAST_MINING, result.getInt(44));
        uniqueData.put(UniqueDataType.CHIMAERA_WING_DATS, result.getInt(45));
        skillsDATS.put(SuperAbilityType.SUPER_SHOTGUN, result.getInt(46));
        skillsDATS.put(SuperAbilityType.TRIDENTS_SUPER_ABILITY, result.getInt(47));
        skillsDATS.put(SuperAbilityType.MACES_SUPER_ABILITY, result.getInt(48));
        try {
            scoreboardTipsShown = result.getInt(50);
        }
        catch (Exception e) {
            scoreboardTipsShown = 0;
        }
        try {
            uuid = UUID.fromString(result.getString(51));
        }
        catch (Exception e) {
            uuid = null;
        }
        return new PlayerProfile(playerName, uuid, skills, skillsXp, skillsDATS, scoreboardTipsShown, uniqueData, null);
    }

    private void printErrors(SQLException ex) {
        ex.printStackTrace();
        this.logger.severe("SQLState: " + ex.getSQLState());
        this.logger.severe("VendorError: " + ex.getErrorCode());
        for (SQLException nextException = ex.getNextException(); nextException != null; nextException = nextException.getNextException()) {
            this.logger.severe("Caused by: " + nextException.getMessage());
        }
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNameUniqueness(Statement statement) {
        ResultSet resultSet;
        block5: {
            resultSet = null;
            resultSet = statement.executeQuery("SHOW INDEXES FROM `" + this.tablePrefix + "users` WHERE Column_name='user'  AND NOT Non_unique");
            if (resultSet.next()) break block5;
            this.tryClose(resultSet);
            return;
        }
        try {
            resultSet.close();
            this.logger.info("Updating mcMMO MySQL tables to drop name uniqueness...");
            statement.execute("ALTER TABLE `" + this.tablePrefix + "users` DROP INDEX `user`,ADD INDEX `user` (`user`(20) ASC)");
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.DROP_NAME_UNIQUENESS);
            this.tryClose(resultSet);
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                this.tryClose(resultSet);
            }
            catch (Throwable throwable) {
                this.tryClose(resultSet);
                throw throwable;
            }
        }
    }

    private void checkUpgradeAddAlchemy(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `alchemy` FROM `" + this.tablePrefix + "skills` LIMIT 1");
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_ALCHEMY);
        }
        catch (SQLException ex) {
            this.logger.info("Updating mcMMO MySQL tables for Alchemy...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD `alchemy` int(10) NOT NULL DEFAULT '0'");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "experience` ADD `alchemy` int(10) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddBlastMiningCooldown(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `blast_mining` FROM `" + this.tablePrefix + "cooldowns` LIMIT 1");
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_BLAST_MINING_COOLDOWN);
        }
        catch (SQLException ex) {
            this.logger.info("Updating mcMMO MySQL tables for Blast Mining...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "cooldowns` ADD `blast_mining` int(32) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddUniqueChimaeraWing(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `chimaera_wing` FROM `" + this.tablePrefix + "cooldowns` LIMIT 1");
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_UNIQUE_PLAYER_DATA);
        }
        catch (SQLException ex) {
            this.logger.info("Updating mcMMO MySQL tables for Chimaera Wing...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "cooldowns` ADD `chimaera_wing` int(32) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddFishing(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `fishing` FROM `" + this.tablePrefix + "skills` LIMIT 1");
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_FISHING);
        }
        catch (SQLException ex) {
            this.logger.info("Updating mcMMO MySQL tables for Fishing...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD `fishing` int(10) NOT NULL DEFAULT '0'");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "experience` ADD `fishing` int(10) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddMobHealthbars(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `mobhealthbar` FROM `" + this.tablePrefix + "huds` LIMIT 1");
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_MOB_HEALTHBARS);
        }
        catch (SQLException ex) {
            this.logger.info("Updating mcMMO MySQL tables for mob healthbars...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "huds` ADD `mobhealthbar` varchar(50) NOT NULL DEFAULT '" + String.valueOf((Object)mcMMO.p.getGeneralConfig().getMobHealthbarDefault()) + "'");
        }
    }

    private void checkUpgradeAddScoreboardTips(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `scoreboardtips` FROM `" + this.tablePrefix + "huds` LIMIT 1");
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_SCOREBOARD_TIPS);
        }
        catch (SQLException ex) {
            this.logger.info("Updating mcMMO MySQL tables for scoreboard tips...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "huds` ADD `scoreboardtips` int(10) NOT NULL DEFAULT '0' ;");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeAddSQLIndexes(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SHOW INDEX FROM `" + this.tablePrefix + "skills` WHERE `Key_name` LIKE 'idx\\_%'");
            resultSet.last();
            if (resultSet.getRow() != SkillTools.NON_CHILD_SKILLS.size()) {
                this.logger.info("Indexing tables, this may take a while on larger databases");
                for (PrimarySkillType skill : SkillTools.NON_CHILD_SKILLS) {
                    String skill_name = skill.name().toLowerCase(Locale.ENGLISH);
                    try {
                        statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD INDEX `idx_" + skill_name + "` (`" + skill_name + "`) USING BTREE");
                    }
                    catch (SQLException sQLException) {}
                }
            }
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_SQL_INDEXES);
            this.tryClose(resultSet);
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                this.tryClose(resultSet);
            }
            catch (Throwable throwable) {
                this.tryClose(resultSet);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeAddUUIDs(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "users` LIMIT 1");
            ResultSetMetaData rsmeta = resultSet.getMetaData();
            boolean column_exists = false;
            for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                if (!rsmeta.getColumnName(i).equalsIgnoreCase("uuid")) continue;
                column_exists = true;
                break;
            }
            if (!column_exists) {
                this.logger.info("Adding UUIDs to mcMMO MySQL user table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "users` ADD `uuid` varchar(36) NULL DEFAULT NULL");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "users` ADD UNIQUE INDEX `uuid` (`uuid`) USING BTREE");
                mcMMO.p.getFoliaLib().getScheduler().runLaterAsync(new GetUUIDUpdatesRequired(), 100L);
            }
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_UUIDS);
            this.tryClose(resultSet);
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                this.tryClose(resultSet);
            }
            catch (Throwable throwable) {
                this.tryClose(resultSet);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeDropPartyNames(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "users` LIMIT 1");
            ResultSetMetaData rsmeta = resultSet.getMetaData();
            boolean column_exists = false;
            for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                if (!rsmeta.getColumnName(i).equalsIgnoreCase("party")) continue;
                column_exists = true;
                break;
            }
            if (column_exists) {
                this.logger.info("Removing party name from users table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "users` DROP COLUMN `party`");
            }
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.DROP_SQL_PARTY_NAMES);
            this.tryClose(resultSet);
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                this.tryClose(resultSet);
            }
            catch (Throwable throwable) {
                this.tryClose(resultSet);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeSkillTotal(Connection connection) throws SQLException {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "skills` LIMIT 1");
            ResultSetMetaData rsmeta = resultSet.getMetaData();
            boolean column_exists = false;
            for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                if (!rsmeta.getColumnName(i).equalsIgnoreCase(ALL_QUERY_VERSION)) continue;
                column_exists = true;
                break;
            }
            if (!column_exists) {
                this.logger.info("Adding skill total column to skills table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD COLUMN `total` int NOT NULL DEFAULT '0'");
                statement.executeUpdate("UPDATE `" + this.tablePrefix + "skills` SET `total` = (taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy)");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD INDEX `idx_total` (`total`) USING BTREE");
                connection.commit();
            }
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_SKILL_TOTAL);
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
            }
            catch (Throwable throwable) {
                connection.setAutoCommit(true);
                this.tryClose(resultSet);
                this.tryClose(statement);
                throw throwable;
            }
            connection.setAutoCommit(true);
            this.tryClose(resultSet);
            this.tryClose(statement);
        }
        connection.setAutoCommit(true);
        this.tryClose(resultSet);
        this.tryClose(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeDropSpout(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "huds` LIMIT 1");
            ResultSetMetaData rsmeta = resultSet.getMetaData();
            boolean column_exists = false;
            for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                if (!rsmeta.getColumnName(i).equalsIgnoreCase("hudtype")) continue;
                column_exists = true;
                break;
            }
            if (column_exists) {
                this.logger.info("Removing Spout HUD type from huds table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "huds` DROP COLUMN `hudtype`");
            }
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.DROP_SPOUT);
            this.tryClose(resultSet);
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                this.tryClose(resultSet);
            }
            catch (Throwable throwable) {
                this.tryClose(resultSet);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserID(Connection connection, String playerName, UUID uuid) {
        if (uuid == null) {
            return this.getUserIDByName(connection, playerName);
        }
        if (this.cachedUserIDs.containsKey(uuid)) {
            return this.cachedUserIDs.get(uuid);
        }
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("SELECT id, `user` FROM " + this.tablePrefix + "users WHERE uuid = ? OR (uuid IS NULL AND `user` = ?)");
            statement.setString(1, uuid.toString());
            statement.setString(2, playerName);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int id = resultSet.getInt("id");
                this.cachedUserIDs.put(uuid, id);
                int n = id;
                this.tryClose(resultSet);
                this.tryClose(statement);
                return n;
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserIDByName(Connection connection, String playerName) {
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("SELECT id, `user` FROM " + this.tablePrefix + "users WHERE `user` = ?");
            statement.setString(1, playerName);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt("id");
                this.tryClose(resultSet);
                this.tryClose(statement);
                return n;
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
        }
        return -1;
    }

    private void tryClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onDisable() {
        LogUtils.debug(this.logger, "Releasing connection pool resource...");
        this.miscPool.close();
        this.loadPool.close();
        this.savePool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMobHealthSettings() {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "huds SET mobhealthbar = ?");
            statement.setString(1, mcMMO.p.getGeneralConfig().getMobHealthbarDefault().toString());
            statement.executeUpdate();
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(statement);
            this.tryClose(connection);
        }
    }

    private void updateCharacterSet(@NotNull Statement statement) {
        this.logger.info("SQL Converting tables from latin1 to utf8mb4");
        try {
            this.logger.info("Updating user column to new encoding");
            statement.executeUpdate(this.getUpdateUserInUsersTableSQLQuery());
            this.logger.info("Updating user column to new encoding");
            statement.executeUpdate(this.getUpdateUUIDInUsersTableSQLQuery());
            this.logger.info("Updating mobhealthbar column to new encoding");
            statement.executeUpdate(this.getUpdateMobHealthBarInHudsTableSQLQuery());
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.SQL_CHARSET_UTF8MB4);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    private String getUpdateUserInUsersTableSQLQuery() {
        return "ALTER TABLE\n    " + this.tablePrefix + "users\n    CHANGE `user` user\n    VARCHAR(40)\n    CHARACTER SET utf8mb4\n    COLLATE utf8mb4_unicode_ci;";
    }

    @NotNull
    private String getUpdateUUIDInUsersTableSQLQuery() {
        return "ALTER TABLE\n    " + this.tablePrefix + "users\n    CHANGE uuid uuid\n    VARCHAR(36)\n    CHARACTER SET utf8mb4\n    COLLATE utf8mb4_unicode_ci;";
    }

    @NotNull
    private String getUpdateMobHealthBarInHudsTableSQLQuery() {
        return "ALTER TABLE\n    " + this.tablePrefix + "huds\n    CHANGE mobhealthbar mobhealthbar\n    VARCHAR(50)\n    CHARACTER SET utf8mb4\n    COLLATE utf8mb4_unicode_ci;";
    }

    public void printAllTablesWithColumns(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet tables = metaData.getTables(null, null, "%", types);
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                System.out.println("Table: " + tableName);
                ResultSet columns = metaData.getColumns(null, null, tableName, "%");
                while (columns.next()) {
                    String columnName = columns.getString("COLUMN_NAME");
                    String columnType = columns.getString("TYPE_NAME");
                    System.out.println("  Column: " + columnName + " Type: " + columnType);
                }
                columns.close();
            }
            tables.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static enum PoolIdentifier {
        MISC,
        LOAD,
        SAVE;

    }

    private class GetUUIDUpdatesRequired
    implements Runnable {
        private GetUUIDUpdatesRequired() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SQLDatabaseManager.this.massUpdateLock.lock();
            ArrayList<String> names = new ArrayList<String>();
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    connection = SQLDatabaseManager.this.miscPool.getConnection();
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("SELECT `user` FROM `" + SQLDatabaseManager.this.tablePrefix + "users` WHERE `uuid` IS NULL");
                    while (resultSet.next()) {
                        names.add(resultSet.getString("user"));
                    }
                    SQLDatabaseManager.this.tryClose(resultSet);
                    SQLDatabaseManager.this.tryClose(statement);
                    SQLDatabaseManager.this.tryClose(connection);
                }
                catch (SQLException ex) {
                    SQLDatabaseManager.this.printErrors(ex);
                }
                finally {
                    SQLDatabaseManager.this.tryClose(resultSet);
                    SQLDatabaseManager.this.tryClose(statement);
                    SQLDatabaseManager.this.tryClose(connection);
                }
                if (!names.isEmpty()) {
                    UUIDUpdateAsyncTask updateTask = new UUIDUpdateAsyncTask(mcMMO.p, names);
                    updateTask.start();
                    updateTask.waitUntilFinished();
                }
            }
            finally {
                SQLDatabaseManager.this.massUpdateLock.unlock();
            }
        }
    }
}

