/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.meta.BonusDropMeta;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.events.fake.FakeBlockBreakEvent;
import com.gmail.nossr50.events.fake.FakeBlockDamageEvent;
import com.gmail.nossr50.events.fake.FakeEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.woodcutting.WoodcuttingManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.ContainerMetadataUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Furnace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    private final mcMMO plugin;

    public BlockListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onBlockDropItemEvent(BlockDropItemEvent event) {
        if (event.isCancelled()) {
            if (event.getBlock().hasMetadata("mcMMO: Double Drops")) {
                event.getBlock().removeMetadata("mcMMO: Double Drops", (Plugin)this.plugin);
            }
            return;
        }
        int tileEntityTolerance = 1;
        if (event.getBlock().getType() == Material.BEETROOTS) {
            tileEntityTolerance = 2;
        }
        HashSet<Material> uniqueMaterials = new HashSet<Material>();
        boolean dontRewardTE = false;
        int blockCount = 0;
        for (Item item : event.getItems()) {
            uniqueMaterials.add(item.getItemStack().getType());
            if (!item.getItemStack().getType().isBlock()) continue;
            ++blockCount;
        }
        if (uniqueMaterials.size() > tileEntityTolerance) {
            dontRewardTE = true;
        }
        if (blockCount <= 1) {
            for (Item item : event.getItems()) {
                ItemStack is = new ItemStack(item.getItemStack());
                if (is.getAmount() <= 0 || !mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.MINING, is.getType()) && !mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.HERBALISM, is.getType()) && !mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.WOODCUTTING, is.getType()) || dontRewardTE && !is.getType().isBlock() || event.getBlock().getMetadata("mcMMO: Double Drops").size() <= 0) continue;
                BonusDropMeta bonusDropMeta = (BonusDropMeta)((Object)event.getBlock().getMetadata("mcMMO: Double Drops").get(0));
                int bonusCount = bonusDropMeta.asInt();
                Location centeredLocation = Misc.getBlockCenter(event.getBlock());
                for (int i = 0; i < bonusCount; ++i) {
                    ItemUtils.spawnItemNaturally(event.getPlayer(), centeredLocation, is, ItemSpawnReason.BONUS_DROPS);
                }
            }
        }
        if (event.getBlock().hasMetadata("mcMMO: Double Drops")) {
            event.getBlock().removeMetadata("mcMMO: Double Drops", (Plugin)this.plugin);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getBlock().getWorld())) {
            return;
        }
        if (!ExperienceConfig.getInstance().isPistonCheatingPrevented()) {
            return;
        }
        BlockFace direction = event.getDirection();
        for (Block block : event.getBlocks()) {
            mcMMO.p.getFoliaLib().getScheduler().runAtLocation(block.getLocation(), t -> {
                Block movedBlock = block.getRelative(direction);
                if (BlockUtils.isWithinWorldBounds(movedBlock)) {
                    BlockUtils.setUnnaturalBlock(movedBlock);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getBlock().getWorld())) {
            return;
        }
        if (!ExperienceConfig.getInstance().isPistonCheatingPrevented()) {
            return;
        }
        BlockFace direction = event.getDirection();
        Block movedBlock = event.getBlock().getRelative(direction);
        if (BlockUtils.isWithinWorldBounds(movedBlock)) {
            BlockUtils.setUnnaturalBlock(movedBlock);
        }
        for (Block block : event.getBlocks()) {
            if (!BlockUtils.isWithinWorldBounds(block) || !BlockUtils.isWithinWorldBounds(block.getRelative(direction))) continue;
            Block relativeBlock = block.getRelative(direction);
            BlockUtils.setUnnaturalBlock(relativeBlock);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityBlockFormEvent(EntityBlockFormEvent event) {
        Block block;
        if (WorldBlacklist.isWorldBlacklisted(event.getBlock().getWorld())) {
            return;
        }
        BlockState blockState = event.getNewState();
        if (ExperienceConfig.getInstance().isSnowExploitPrevented() && BlockUtils.shouldBeWatched(blockState) && BlockUtils.isWithinWorldBounds(block = blockState.getBlock())) {
            BlockUtils.setUnnaturalBlock(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFormEvent(BlockFormEvent event) {
        Block block;
        BlockState newState;
        World world = event.getBlock().getWorld();
        if (WorldBlacklist.isWorldBlacklisted(world)) {
            return;
        }
        if (ExperienceConfig.getInstance().preventStoneLavaFarming() && (newState = event.getNewState()).getType() != Material.OBSIDIAN && ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.MINING, newState.getType()) && BlockUtils.isWithinWorldBounds(block = newState.getBlock())) {
            BlockUtils.setUnnaturalBlock(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player;
        BlockState blockState = event.getBlock().getState();
        Block block = blockState.getBlock();
        if (WorldBlacklist.isWorldBlacklisted(block.getWorld())) {
            return;
        }
        if (BlockUtils.isWithinWorldBounds(block) && !(event instanceof BlockMultiPlaceEvent)) {
            BlockUtils.setUnnaturalBlock(block);
        }
        if (!UserManager.hasPlayerDataKey((Entity)(player = event.getPlayer()))) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            return;
        }
        if (blockState.getType() == Repair.anvilMaterial && mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.REPAIR)) {
            mmoPlayer.getRepairManager().placedAnvilCheck();
        } else if (blockState.getType() == Salvage.anvilMaterial && mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.SALVAGE)) {
            mmoPlayer.getSalvageManager().placedAnvilCheck();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
        for (BlockState replacedBlockState : event.getReplacedBlockStates()) {
            BlockState blockState = replacedBlockState.getBlock().getState();
            Block block = blockState.getBlock();
            if (!BlockUtils.isWithinWorldBounds(block)) continue;
            if (BlockUtils.isPartOfTree(event.getBlockPlaced())) {
                return;
            }
            for (BlockState replacedState : event.getReplacedBlockStates()) {
                BlockUtils.setUnnaturalBlock(replacedState.getBlock());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent event) {
        Block block = event.getBlock();
        World world = block.getWorld();
        if (WorldBlacklist.isWorldBlacklisted(world)) {
            return;
        }
        if (BlockUtils.isWithinWorldBounds(block)) {
            mcMMO.getUserBlockTracker().setEligible(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player;
        BlockState blockState;
        Block block = event.getBlock();
        if (event instanceof FakeBlockBreakEvent) {
            return;
        }
        if (WorldBlacklist.isWorldBlacklisted(block.getWorld())) {
            BlockUtils.cleanupBlockMetadata(block);
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(event.getPlayer())) {
            BlockUtils.cleanupBlockMetadata(block);
            return;
        }
        Location location = block.getLocation();
        if (block.getType() == Material.BREWING_STAND && (blockState = block.getState()) instanceof BrewingStand && Alchemy.brewingStandMap.containsKey(location)) {
            Alchemy.brewingStandMap.get(location).cancelBrew();
        }
        if (!UserManager.hasPlayerDataKey((Entity)(player = event.getPlayer())) || player.getGameMode() == GameMode.CREATIVE) {
            BlockUtils.cleanupBlockMetadata(block);
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            BlockUtils.cleanupBlockMetadata(block);
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (BlockUtils.affectedByGreenTerra(block)) {
            HerbalismManager herbalismManager = mmoPlayer.getHerbalismManager();
            if (herbalismManager.canActivateAbility()) {
                mmoPlayer.checkAbilityActivation(PrimarySkillType.HERBALISM);
            }
            if (mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.HERBALISM)) {
                herbalismManager.processHerbalismBlockBreakEvent(event);
            }
            return;
        }
        if (BlockUtils.affectedBySuperBreaker(block) && (ItemUtils.isPickaxe(heldItem) || ItemUtils.isHoe(heldItem)) && mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.MINING) && !mcMMO.getUserBlockTracker().isIneligible(block)) {
            MiningManager miningManager = mmoPlayer.getMiningManager();
            miningManager.miningBlockCheck(block);
        } else if (BlockUtils.hasWoodcuttingXP(block) && ItemUtils.isAxe(heldItem) && mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.WOODCUTTING) && !mcMMO.getUserBlockTracker().isIneligible(block)) {
            WoodcuttingManager woodcuttingManager = mmoPlayer.getWoodcuttingManager();
            if (woodcuttingManager.canUseTreeFeller(heldItem)) {
                woodcuttingManager.processTreeFeller(block);
            } else {
                woodcuttingManager.processWoodcuttingBlockXP(block);
                woodcuttingManager.processBonusDropCheck(block);
            }
        } else if (BlockUtils.affectedByGigaDrillBreaker(block) && ItemUtils.isShovel(heldItem) && mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.EXCAVATION) && !mcMMO.getUserBlockTracker().isIneligible(block)) {
            ExcavationManager excavationManager = mmoPlayer.getExcavationManager();
            excavationManager.excavationBlockCheck(block);
            if (mmoPlayer.getAbilityMode(SuperAbilityType.GIGA_DRILL_BREAKER)) {
                excavationManager.gigaDrillBreaker(block);
            }
        }
        BlockUtils.cleanupBlockMetadata(block);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreakHigher(BlockBreakEvent event) {
        HerbalismManager herbalismManager;
        if (event instanceof FakeEvent) {
            return;
        }
        if (WorldBlacklist.isWorldBlacklisted(event.getBlock().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(event.getPlayer())) {
            return;
        }
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        BlockState blockState = event.getBlock().getState();
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (ItemUtils.isSword(heldItem) && (herbalismManager = UserManager.getPlayer(player).getHerbalismManager()).canUseHylianLuck()) {
            if (herbalismManager.processHylianLuck(blockState)) {
                blockState.update(true);
                event.setCancelled(true);
            } else if (blockState.getType() == Material.FLOWER_POT) {
                blockState.setType(Material.AIR);
                blockState.update(true);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (WorldBlacklist.isWorldBlacklisted(event.getBlock().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(event.getPlayer())) {
            return;
        }
        if (event instanceof FakeBlockDamageEvent) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            return;
        }
        if (BlockUtils.canActivateAbilities(block)) {
            ItemStack heldItem = player.getInventory().getItemInMainHand();
            if (mmoPlayer.getToolPreparationMode(ToolType.HOE) && ItemUtils.isHoe(heldItem) && (BlockUtils.affectedByGreenTerra(block) || BlockUtils.canMakeMossy(block)) && Permissions.greenTerra((Permissible)player)) {
                mmoPlayer.checkAbilityActivation(PrimarySkillType.HERBALISM);
            } else if (mmoPlayer.getToolPreparationMode(ToolType.AXE) && ItemUtils.isAxe(heldItem) && BlockUtils.hasWoodcuttingXP(block) && Permissions.treeFeller((Permissible)player)) {
                mmoPlayer.checkAbilityActivation(PrimarySkillType.WOODCUTTING);
            } else if (mmoPlayer.getToolPreparationMode(ToolType.PICKAXE) && ItemUtils.isPickaxe(heldItem) && BlockUtils.affectedBySuperBreaker(block) && Permissions.superBreaker((Permissible)player)) {
                mmoPlayer.checkAbilityActivation(PrimarySkillType.MINING);
            } else if (mmoPlayer.getToolPreparationMode(ToolType.SHOVEL) && ItemUtils.isShovel(heldItem) && BlockUtils.affectedByGigaDrillBreaker(block) && Permissions.gigaDrillBreaker((Permissible)player)) {
                mmoPlayer.checkAbilityActivation(PrimarySkillType.EXCAVATION);
            } else if (mmoPlayer.getToolPreparationMode(ToolType.FISTS) && heldItem.getType() == Material.AIR && (BlockUtils.affectedByGigaDrillBreaker(block) || mcMMO.getMaterialMapStore().isGlass(block.getType()) || block.getType() == Material.SNOW || BlockUtils.affectedByBlockCracker(block) && Permissions.berserk((Permissible)player))) {
                mmoPlayer.checkAbilityActivation(PrimarySkillType.UNARMED);
                if (mmoPlayer.getAbilityMode(SuperAbilityType.BERSERK) && SuperAbilityType.BERSERK.blockCheck(block) && EventUtils.simulateBlockBreak(block, player)) {
                    event.setInstaBreak(true);
                    if (block.getType().getKey().getKey().contains("glass")) {
                        SoundManager.worldSendSound(player.getWorld(), block.getLocation(), SoundType.GLASS);
                    } else {
                        SoundManager.sendSound(player, block.getLocation(), SoundType.POP);
                    }
                }
            }
        }
        if (mmoPlayer.getAbilityMode(SuperAbilityType.TREE_FELLER) && BlockUtils.hasWoodcuttingXP(block) && mcMMO.p.getGeneralConfig().getTreeFellerSoundsEnabled()) {
            SoundManager.sendSound(player, block.getLocation(), SoundType.FIZZ);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDamageHigher(BlockDamageEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getBlock().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(event.getPlayer())) {
            return;
        }
        if (event instanceof FakeBlockDamageEvent) {
            return;
        }
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        if (mmoPlayer.getAbilityMode(SuperAbilityType.GREEN_TERRA) && BlockUtils.canMakeMossy(block)) {
            mmoPlayer.getHerbalismManager().processGreenTerraBlockConversion(block);
        } else if (mmoPlayer.getAbilityMode(SuperAbilityType.BERSERK) && (heldItem.getType() == Material.AIR || mcMMO.p.getGeneralConfig().getUnarmedItemsAsUnarmed())) {
            if (mmoPlayer.getUnarmedManager().canUseBlockCracker() && BlockUtils.affectedByBlockCracker(block)) {
                if (EventUtils.simulateBlockBreak(block, player)) {
                    mmoPlayer.getUnarmedManager().blockCrackerCheck(block);
                }
            } else if (!event.getInstaBreak() && SuperAbilityType.BERSERK.blockCheck(block) && EventUtils.simulateBlockBreak(block, player)) {
                event.setInstaBreak(true);
                if (block.getType().getKey().getKey().contains("glass")) {
                    SoundManager.worldSendSound(player.getWorld(), block.getLocation(), SoundType.GLASS);
                } else {
                    SoundManager.sendSound(player, block.getLocation(), SoundType.POP);
                }
            }
        } else if (mmoPlayer.getWoodcuttingManager().canUseLeafBlower(heldItem) && BlockUtils.isNonWoodPartOfTree(block) && EventUtils.simulateBlockBreak(block, player)) {
            event.setInstaBreak(true);
            SoundManager.sendSound(player, block.getLocation(), SoundType.POP);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockDamageCleanup(BlockDamageEvent event) {
        Player player = event.getPlayer();
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        this.cleanupAbilityTools(mmoPlayer, event.getBlock(), heldItem);
        this.debugStickDump(player, event.getBlock());
    }

    private void debugStickDump(Player player, Block block) {
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            return;
        }
        BlockState blockState = block.getState();
        if (mmoPlayer.isDebugMode()) {
            if (mcMMO.getUserBlockTracker().isIneligible(blockState)) {
                player.sendMessage("[mcMMO DEBUG] This block is not natural and does not reward treasures/XP");
            } else {
                player.sendMessage("[mcMMO DEBUG] This block is considered natural by mcMMO");
                mmoPlayer.getExcavationManager().printExcavationDebug(player, block);
            }
            if (WorldGuardUtils.isWorldGuardLoaded()) {
                if (WorldGuardManager.getInstance().hasMainFlag(player)) {
                    player.sendMessage("[mcMMO DEBUG] World Guard main flag is permitted for this player in this region");
                } else {
                    player.sendMessage("[mcMMO DEBUG] World Guard main flag is DENIED for this player in this region");
                }
                if (WorldGuardManager.getInstance().hasXPFlag(player)) {
                    player.sendMessage("[mcMMO DEBUG] World Guard xp flag is permitted for this player in this region");
                } else {
                    player.sendMessage("[mcMMO DEBUG] World Guard xp flag is not permitted for this player in this region");
                }
            }
            if (blockState instanceof Furnace || blockState instanceof BrewingStand) {
                if (ContainerMetadataUtils.isContainerOwned(blockState)) {
                    player.sendMessage("[mcMMO DEBUG] This container has a registered owner");
                    OfflinePlayer furnacePlayer = ContainerMetadataUtils.getContainerOwner(blockState);
                    if (furnacePlayer != null) {
                        player.sendMessage("[mcMMO DEBUG] This container is owned by player " + furnacePlayer.getName());
                    }
                } else {
                    player.sendMessage("[mcMMO DEBUG] This container does not have a registered owner");
                }
            }
            if (ExperienceConfig.getInstance().isExperienceBarsEnabled()) {
                player.sendMessage("[mcMMO DEBUG] XP bars are enabled, however you should check per-skill settings to make sure those are enabled.");
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + "You can turn this debug info off by typing " + String.valueOf(ChatColor.GOLD) + "/mmodebug");
        }
    }

    private void cleanupAbilityTools(McMMOPlayer mmoPlayer, Block block, ItemStack heldItem) {
        if (HiddenConfig.getInstance().useEnchantmentBuffs()) {
            if (ItemUtils.isPickaxe(heldItem) && !mmoPlayer.getAbilityMode(SuperAbilityType.SUPER_BREAKER) || ItemUtils.isShovel(heldItem) && !mmoPlayer.getAbilityMode(SuperAbilityType.GIGA_DRILL_BREAKER)) {
                SkillUtils.removeAbilityBuff(heldItem);
            }
        } else if (mmoPlayer.getAbilityMode(SuperAbilityType.SUPER_BREAKER) && !BlockUtils.affectedBySuperBreaker(block) || mmoPlayer.getAbilityMode(SuperAbilityType.GIGA_DRILL_BREAKER) && !BlockUtils.affectedByGigaDrillBreaker(block)) {
            SkillUtils.removeAbilityBoostsFromInventory(mmoPlayer.getPlayer());
        }
    }
}

