/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.alchemy;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.alchemy.PotionStage;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.ConfigStringUtils;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class AlchemyManager
extends SkillManager {
    private final double LUCKY_MODIFIER = 1.3333333333333333;

    public AlchemyManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.ALCHEMY);
    }

    public int getTier() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.ALCHEMY_CONCOCTIONS);
    }

    public List<ItemStack> getIngredients() {
        return mcMMO.p.getPotionConfig().getIngredients(this.getTier());
    }

    public String getIngredientList() {
        StringBuilder list = new StringBuilder();
        for (ItemStack ingredient : this.getIngredients()) {
            String string = ConfigStringUtils.getMaterialConfigString(ingredient.getType());
            list.append(", ").append(string);
        }
        return list.substring(2);
    }

    public double calculateBrewSpeed(boolean isLucky) {
        int skillLevel = this.getSkillLevel();
        if (skillLevel < RankUtils.getUnlockLevel(SubSkillType.ALCHEMY_CATALYSIS)) {
            return Alchemy.catalysisMinSpeed;
        }
        return Math.min(Alchemy.catalysisMaxSpeed, Alchemy.catalysisMinSpeed + (Alchemy.catalysisMaxSpeed - Alchemy.catalysisMinSpeed) * (double)(skillLevel - RankUtils.getUnlockLevel(SubSkillType.ALCHEMY_CATALYSIS)) / (double)(Alchemy.catalysisMaxBonusLevel - RankUtils.getUnlockLevel(SubSkillType.ALCHEMY_CATALYSIS))) * (isLucky ? 1.3333333333333333 : 1.0);
    }

    public void handlePotionBrewSuccesses(PotionStage potionStage, int amount) {
        this.applyXpGain((float)(ExperienceConfig.getInstance().getPotionXP(potionStage) * (double)amount), XPGainReason.PVE, XPGainSource.PASSIVE);
    }
}

