/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.smelting;

import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.smelting.Smelting;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import org.bukkit.block.Furnace;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class SmeltingManager
extends SkillManager {
    public SmeltingManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.SMELTING);
    }

    public boolean isSecondSmeltSuccessful() {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.SMELTING_SECOND_SMELT) && ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.SMELTING_SECOND_SMELT, this.mmoPlayer);
    }

    public int fuelEfficiency(int burnTime) {
        if (burnTime <= 0) {
            return 0;
        }
        return Math.min(Short.MAX_VALUE, Math.max(1, burnTime * this.getFuelEfficiencyMultiplier()));
    }

    public int getFuelEfficiencyMultiplier() {
        return switch (RankUtils.getRank(this.getPlayer(), SubSkillType.SMELTING_FUEL_EFFICIENCY)) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            default -> 1;
        };
    }

    public void smeltProcessing(@NotNull FurnaceSmeltEvent furnaceSmeltEvent, @NotNull Furnace furnace) {
        this.applyXpGain(Smelting.getSmeltXP(furnaceSmeltEvent.getSource()), XPGainReason.PVE, XPGainSource.PASSIVE);
        this.processDoubleSmelt(furnaceSmeltEvent, furnace);
    }

    private void processDoubleSmelt(@NotNull FurnaceSmeltEvent furnaceSmeltEvent, @NotNull Furnace furnace) {
        ItemStack resultItemStack = furnaceSmeltEvent.getResult();
        if (mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.SMELTING, resultItemStack.getType()) && this.canDoubleSmeltItemStack(furnace) && this.isSecondSmeltSuccessful()) {
            ItemStack doubleSmeltStack = resultItemStack.clone();
            doubleSmeltStack.setAmount(resultItemStack.getAmount() + 1);
            furnaceSmeltEvent.setResult(doubleSmeltStack);
        }
    }

    private boolean canDoubleSmeltItemStack(@NotNull Furnace furnace) {
        int itemLimit;
        int doubleSmeltCondition;
        FurnaceInventory furnaceInventory = furnace.getInventory();
        ItemStack furnaceResult = furnaceInventory.getResult();
        if (furnaceResult == null) {
            return true;
        }
        int resultAmount = furnaceResult.getAmount();
        return resultAmount <= (doubleSmeltCondition = (itemLimit = furnaceResult.getMaxStackSize()) - 2);
    }

    public int vanillaXPBoost(int experience) {
        return experience * this.getVanillaXpMultiplier();
    }

    public int getVanillaXpMultiplier() {
        return Math.max(1, RankUtils.getRank(this.getPlayer(), SubSkillType.SMELTING_UNDERSTANDING_THE_ART));
    }
}

