/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills;

import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.Locale;

public enum SubSkillType {
    ACROBATICS_DODGE(1),
    ACROBATICS_ROLL,
    ALCHEMY_CATALYSIS(1),
    ALCHEMY_CONCOCTIONS(8),
    ARCHERY_ARROW_RETRIEVAL(1),
    ARCHERY_DAZE,
    ARCHERY_SKILL_SHOT(20),
    ARCHERY_ARCHERY_LIMIT_BREAK(10),
    AXES_ARMOR_IMPACT(20),
    AXES_AXE_MASTERY(4),
    AXES_AXES_LIMIT_BREAK(10),
    AXES_CRITICAL_STRIKES(1),
    AXES_GREATER_IMPACT(1),
    AXES_SKULL_SPLITTER(1),
    CROSSBOWS_CROSSBOWS_LIMIT_BREAK(10),
    CROSSBOWS_TRICK_SHOT(3),
    CROSSBOWS_POWERED_SHOT(20),
    EXCAVATION_ARCHAEOLOGY(8),
    EXCAVATION_GIGA_DRILL_BREAKER(1),
    FISHING_FISHERMANS_DIET(5),
    FISHING_ICE_FISHING(1),
    FISHING_MAGIC_HUNTER(1),
    FISHING_MASTER_ANGLER(8),
    FISHING_TREASURE_HUNTER(8),
    FISHING_SHAKE(8),
    HERBALISM_DOUBLE_DROPS(1),
    HERBALISM_VERDANT_BOUNTY(1),
    HERBALISM_FARMERS_DIET(5),
    HERBALISM_GREEN_TERRA(1),
    HERBALISM_GREEN_THUMB(4),
    HERBALISM_HYLIAN_LUCK,
    HERBALISM_SHROOM_THUMB,
    MACES_MACES_LIMIT_BREAK(10),
    MACES_CRUSH(4),
    MACES_CRIPPLE(4),
    MINING_BIGGER_BOMBS(1),
    MINING_BLAST_MINING(8),
    MINING_DEMOLITIONS_EXPERTISE(1),
    MINING_DOUBLE_DROPS(1),
    MINING_SUPER_BREAKER(1),
    MINING_MOTHER_LODE(1),
    REPAIR_ARCANE_FORGING(8),
    REPAIR_REPAIR_MASTERY(1),
    REPAIR_SUPER_REPAIR(1),
    SALVAGE_SCRAP_COLLECTOR(8),
    SALVAGE_ARCANE_SALVAGE(8),
    SMELTING_FUEL_EFFICIENCY(3),
    SMELTING_SECOND_SMELT,
    SMELTING_UNDERSTANDING_THE_ART(8),
    SWORDS_COUNTER_ATTACK(1),
    SWORDS_RUPTURE(4),
    SWORDS_SERRATED_STRIKES(1),
    SWORDS_STAB(2),
    SWORDS_SWORDS_LIMIT_BREAK(10),
    TAMING_BEAST_LORE(1),
    TAMING_CALL_OF_THE_WILD(1),
    TAMING_ENVIRONMENTALLY_AWARE(1),
    TAMING_FAST_FOOD_SERVICE(1),
    TAMING_GORE(1),
    TAMING_HOLY_HOUND(1),
    TAMING_PUMMEL(1),
    TAMING_SHARPENED_CLAWS(1),
    TAMING_SHOCK_PROOF(1),
    TAMING_THICK_FUR(1),
    TRIDENTS_IMPALE(10),
    TRIDENTS_TRIDENTS_LIMIT_BREAK(10),
    UNARMED_ARROW_DEFLECT(1),
    UNARMED_BERSERK(1),
    UNARMED_BLOCK_CRACKER,
    UNARMED_DISARM(1),
    UNARMED_STEEL_ARM_STYLE(20),
    UNARMED_IRON_GRIP(1),
    UNARMED_UNARMED_LIMIT_BREAK(10),
    WOODCUTTING_KNOCK_ON_WOOD(2),
    WOODCUTTING_HARVEST_LUMBER(1),
    WOODCUTTING_LEAF_BLOWER(1),
    WOODCUTTING_TREE_FELLER(1),
    WOODCUTTING_CLEAN_CUTS(1);

    private final int numRanks;

    private SubSkillType(int numRanks) {
        this.numRanks = numRanks;
    }

    private SubSkillType() {
        this.numRanks = 0;
    }

    public int getNumRanks() {
        return this.numRanks;
    }

    public PrimarySkillType getParentSkill() {
        return mcMMO.p.getSkillTools().getPrimarySkillBySubSkill(this);
    }

    public String getAdvConfigAddress() {
        return "Skills." + StringUtils.getCapitalized(this.getParentSkill().toString()) + "." + this.getConfigName(this.toString());
    }

    public String getRankConfigAddress() {
        return StringUtils.getCapitalized(this.getParentSkill().toString()) + "." + this.getConfigName(this.toString());
    }

    public String getPermissionNodeAddress() {
        return "mcmmo.ability." + this.getParentSkill().toString().toLowerCase(Locale.ENGLISH) + "." + this.getConfigName(this.toString()).toLowerCase(Locale.ENGLISH);
    }

    private String getConfigName(String subSkillName) {
        StringBuilder endResult = new StringBuilder();
        int subStringIndex = this.getSubStringIndex(subSkillName);
        String subskillNameWithoutPrefix = subSkillName.substring(subStringIndex);
        if (subskillNameWithoutPrefix.contains("_")) {
            String[] splitStrings;
            for (String string : splitStrings = subskillNameWithoutPrefix.split("_")) {
                endResult.append(StringUtils.getCapitalized(string));
            }
        } else {
            endResult.append(StringUtils.getCapitalized(subskillNameWithoutPrefix));
        }
        return endResult.toString();
    }

    public String getWikiUrl() {
        int subStringIndex = this.getSubStringIndex(this.name());
        String afterPrefix = this.name().substring(subStringIndex);
        return afterPrefix.replace("_", "-").replace(" ", "-").toLowerCase(Locale.ENGLISH);
    }

    public String getParentNiceNameLocale() {
        return LocaleLoader.getString(StringUtils.getCapitalized(this.getParentSkill().toString()) + ".SkillName");
    }

    public String getNiceNameNoSpaces(SubSkillType subSkillType) {
        return this.getConfigName(subSkillType.toString());
    }

    private int getSubStringIndex(String subSkillName) {
        char[] enumNameCharArray = subSkillName.toCharArray();
        int subStringIndex = 0;
        for (int i = 0; i < enumNameCharArray.length; ++i) {
            if (enumNameCharArray[i] != '_') continue;
            subStringIndex = i + 1;
            break;
        }
        return subStringIndex;
    }

    public String getLocaleKeyRoot() {
        return StringUtils.getCapitalized(this.getParentSkill().toString()) + ".SubSkill." + this.getConfigName(this.toString());
    }

    public String getLocaleName() {
        return this.getFromLocaleSubAddress(".Name");
    }

    public String getLocaleDescription() {
        return this.getFromLocaleSubAddress(".Description");
    }

    public String getLocaleStatDescription() {
        return this.getFromLocaleSubAddress(".Stat");
    }

    public String getLocaleKeyStatDescription() {
        return this.getLocaleKeyFromSubAddress(".Stat");
    }

    public String getLocaleStatExtraDescription() {
        return this.getFromLocaleSubAddress(".Stat.Extra");
    }

    public String getLocaleKeyStatExtraDescription() {
        return this.getLocaleKeyFromSubAddress(".Stat.Extra");
    }

    public String getLocaleStat(String ... vars) {
        return LocaleLoader.getString("Ability.Generic.Template", vars);
    }

    public String getCustomLocaleStat(String ... vars) {
        return LocaleLoader.getString("Ability.Generic.Template.Custom", vars);
    }

    private String getFromLocaleSubAddress(String s) {
        return LocaleLoader.getString(this.getLocaleKeyRoot() + s);
    }

    private String getLocaleKeyFromSubAddress(String s) {
        return this.getLocaleKeyRoot() + s;
    }
}

