/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.sounds;

import com.gmail.nossr50.config.SoundConfig;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.sounds.SoundRegistryUtils;
import com.gmail.nossr50.util.sounds.SoundType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class SoundManager {
    private static final Map<SoundType, Sound> soundCache = new ConcurrentHashMap<SoundType, Sound>();
    private static final String NULL_FALLBACK_ID = null;
    private static Sound CRIPPLE_SOUND;
    private static final String ITEM_MACE_SMASH_GROUND = "ITEM_MACE_SMASH_GROUND";
    private static final String VALUE_OF = "valueOf";
    private static final String ORG_BUKKIT_SOUND = "org.bukkit.Sound";

    public static void sendSound(Player player, Location location, SoundType soundType) {
        if (SoundConfig.getInstance().getIsEnabled(soundType)) {
            player.playSound(location, SoundManager.getSound(soundType), SoundCategory.MASTER, SoundManager.getVolume(soundType), SoundManager.getPitch(soundType));
        }
    }

    public static void sendCategorizedSound(Location location, SoundType soundType, SoundCategory soundCategory) {
        World world;
        if (SoundConfig.getInstance().getIsEnabled(soundType) && (world = location.getWorld()) != null) {
            world.playSound(location, SoundManager.getSound(soundType), soundCategory, SoundManager.getVolume(soundType), SoundManager.getPitch(soundType));
        }
    }

    public static void sendCategorizedSound(Location location, SoundType soundType, SoundCategory soundCategory, float pitchModifier) {
        World world;
        if (SoundConfig.getInstance().getIsEnabled(soundType) && (world = location.getWorld()) != null) {
            float totalPitch = Math.min(2.0f, SoundManager.getPitch(soundType) + pitchModifier);
            world.playSound(location, SoundManager.getSound(soundType), soundCategory, SoundManager.getVolume(soundType), totalPitch);
        }
    }

    public static void sendCategorizedSound(Player player, Location location, SoundType soundType, SoundCategory soundCategory) {
        if (SoundConfig.getInstance().getIsEnabled(soundType)) {
            player.playSound(location, SoundManager.getSound(soundType), soundCategory, SoundManager.getVolume(soundType), SoundManager.getPitch(soundType));
        }
    }

    public static void sendCategorizedSound(Player player, Location location, SoundType soundType, SoundCategory soundCategory, float pitchModifier) {
        float totalPitch = Math.min(2.0f, SoundManager.getPitch(soundType) + pitchModifier);
        if (SoundConfig.getInstance().getIsEnabled(soundType)) {
            player.playSound(location, SoundManager.getSound(soundType), soundCategory, SoundManager.getVolume(soundType), totalPitch);
        }
    }

    public static void worldSendSound(World world, Location location, SoundType soundType) {
        if (SoundConfig.getInstance().getIsEnabled(soundType)) {
            world.playSound(location, SoundManager.getSound(soundType), SoundManager.getVolume(soundType), SoundManager.getPitch(soundType));
        }
    }

    public static void worldSendSoundMaxPitch(World world, Location location, SoundType soundType) {
        if (SoundConfig.getInstance().getIsEnabled(soundType)) {
            world.playSound(location, SoundManager.getSound(soundType), SoundManager.getVolume(soundType), 2.0f);
        }
    }

    private static float getVolume(SoundType soundType) {
        return SoundConfig.getInstance().getVolume(soundType) * SoundConfig.getInstance().getMasterVolume();
    }

    private static float getPitch(SoundType soundType) {
        return switch (soundType) {
            case SoundType.FIZZ -> SoundManager.getFizzPitch();
            case SoundType.POP -> SoundManager.getPopPitch();
            default -> SoundConfig.getInstance().getPitch(soundType);
        };
    }

    private static Sound getSound(SoundType soundType) {
        String soundId = SoundConfig.getInstance().getSound(soundType);
        if (SoundRegistryUtils.useLegacyLookup()) {
            return SoundManager.getSoundLegacyCustom(soundId, soundType);
        }
        if (soundCache.containsKey((Object)soundType)) {
            return soundCache.get((Object)soundType);
        }
        Sound sound = soundId != null && !soundId.isEmpty() ? SoundRegistryUtils.getSound(soundId, soundType.id()) : SoundRegistryUtils.getSound(soundType.id(), NULL_FALLBACK_ID);
        if (sound != null) {
            soundCache.putIfAbsent(soundType, sound);
            return sound;
        }
        throw new RuntimeException("Could not find Sound for SoundType: " + String.valueOf((Object)soundType));
    }

    private static Sound getSoundLegacyCustom(String id, SoundType soundType) {
        if (soundCache.containsKey((Object)soundType)) {
            return soundCache.get((Object)soundType);
        }
        if (id != null && !id.isEmpty()) {
            if (Sound.class.isEnum()) {
                try {
                    Method method = Sound.class.getMethod("getKey", new Class[0]);
                    for (Sound legacyEnumEntry : (Sound[])Sound.class.getEnumConstants()) {
                        if (!method.invoke((Object)legacyEnumEntry, new Object[0]).toString().equals(id)) continue;
                        Sound sound = legacyEnumEntry;
                        soundCache.putIfAbsent(soundType, sound);
                        return sound;
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Unable to find legacy sound by ID %s for SoundType %s".formatted(new Object[]{id, soundType}));
        }
        Sound sound = SoundManager.getSoundLegacyFallBack(soundType);
        soundCache.putIfAbsent(soundType, sound);
        return sound;
    }

    private static Sound getSoundLegacyFallBack(SoundType soundType) {
        return switch (soundType) {
            default -> throw new IncompatibleClassChangeError();
            case SoundType.ANVIL -> Sound.BLOCK_ANVIL_PLACE;
            case SoundType.ITEM_BREAK -> Sound.ENTITY_ITEM_BREAK;
            case SoundType.POP -> Sound.ENTITY_ITEM_PICKUP;
            case SoundType.CHIMAERA_WING -> Sound.ENTITY_BAT_TAKEOFF;
            case SoundType.LEVEL_UP -> Sound.ENTITY_PLAYER_LEVELUP;
            case SoundType.FIZZ -> Sound.BLOCK_FIRE_EXTINGUISH;
            case SoundType.TOOL_READY -> Sound.ITEM_ARMOR_EQUIP_GOLD;
            case SoundType.ROLL_ACTIVATED -> Sound.ENTITY_LLAMA_SWAG;
            case SoundType.SKILL_UNLOCKED -> Sound.UI_TOAST_CHALLENGE_COMPLETE;
            case SoundType.ABILITY_ACTIVATED_BERSERK, SoundType.TIRED -> Sound.BLOCK_CONDUIT_AMBIENT;
            case SoundType.ABILITY_ACTIVATED_GENERIC -> Sound.ITEM_TRIDENT_RIPTIDE_3;
            case SoundType.DEFLECT_ARROWS, SoundType.BLEED -> Sound.ENTITY_ENDER_EYE_DEATH;
            case SoundType.GLASS -> Sound.BLOCK_GLASS_BREAK;
            case SoundType.ITEM_CONSUMED -> Sound.ITEM_BOTTLE_EMPTY;
            case SoundType.CRIPPLE -> SoundManager.getCrippleSound();
        };
    }

    private static Sound getCrippleSound() {
        if (CRIPPLE_SOUND != null) {
            return CRIPPLE_SOUND;
        }
        try {
            Class<?> clazz = Class.forName(ORG_BUKKIT_SOUND);
            Method valueOf = clazz.getMethod(VALUE_OF, new Class[0]);
            CRIPPLE_SOUND = (Sound)valueOf.invoke(null, ITEM_MACE_SMASH_GROUND);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            CRIPPLE_SOUND = Sound.BLOCK_ANVIL_PLACE;
        }
        return CRIPPLE_SOUND;
    }

    public static float getFizzPitch() {
        return 2.6f + (Misc.getRandom().nextFloat() - Misc.getRandom().nextFloat()) * 0.8f;
    }

    public static float getPopPitch() {
        return ((Misc.getRandom().nextFloat() - Misc.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f;
    }
}

