/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.BukkitConfig;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.sounds.SoundType;

public class SoundConfig
extends BukkitConfig {
    private static SoundConfig instance;

    public SoundConfig() {
        super("sounds.yml");
        this.validate();
        instance = this;
    }

    public static SoundConfig getInstance() {
        if (instance == null) {
            return new SoundConfig();
        }
        return instance;
    }

    @Override
    protected void loadKeys() {
    }

    @Override
    protected boolean validateKeys() {
        for (SoundType soundType : SoundType.values()) {
            if (this.config.getDouble("Sounds." + String.valueOf((Object)soundType) + ".Volume") < 0.0) {
                LogUtils.debug(mcMMO.p.getLogger(), "[mcMMO] Sound volume cannot be below 0 for " + String.valueOf((Object)soundType));
                return false;
            }
            if (soundType.usesCustomPitch() || !(this.config.getDouble("Sounds." + String.valueOf((Object)soundType) + ".Pitch") < 0.0)) continue;
            LogUtils.debug(mcMMO.p.getLogger(), "[mcMMO] Sound pitch cannot be below 0 for " + String.valueOf((Object)soundType));
            return false;
        }
        return true;
    }

    public float getMasterVolume() {
        return (float)this.config.getDouble("Sounds.MasterVolume", 1.0);
    }

    public float getVolume(SoundType soundType) {
        String key = "Sounds." + String.valueOf((Object)soundType) + ".Volume";
        return (float)this.config.getDouble(key, 1.0);
    }

    public float getPitch(SoundType soundType) {
        String key = "Sounds." + String.valueOf((Object)soundType) + ".Pitch";
        return (float)this.config.getDouble(key, 1.0);
    }

    public String getSound(SoundType soundType) {
        String key = "Sounds." + String.valueOf((Object)soundType) + ".CustomSoundId";
        return this.config.getString(key);
    }

    public boolean getIsEnabled(SoundType soundType) {
        String key = "Sounds." + String.valueOf((Object)soundType) + ".Enable";
        return this.config.getBoolean(key, true);
    }
}

