/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.interfaces.InteractType;
import com.gmail.nossr50.events.fake.FakeEntityTameEvent;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.metadata.MobMetaFlagType;
import com.gmail.nossr50.runnables.TravelingBlockMetaCleanup;
import com.gmail.nossr50.skills.archery.Archery;
import com.gmail.nossr50.skills.crossbows.Crossbows;
import com.gmail.nossr50.skills.mining.BlastMining;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.taming.Taming;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.util.AttributeMapper;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.MetadataConstants;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.MobMetadataUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.ProjectileUtils;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class EntityListener
implements Listener {
    private final mcMMO pluginRef;
    private final NamespacedKey piercingEnchantment = NamespacedKey.minecraft((String)"piercing");
    private static final Set<EntityType> TRANSFORMABLE_ENTITIES = Set.of(EntityType.SLIME, EntityType.MAGMA_CUBE);

    public EntityListener(mcMMO pluginRef) {
        this.pluginRef = pluginRef;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityTransform(EntityTransformEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (MobMetadataUtils.hasMobFlags(livingEntity)) {
                for (Entity entity2 : event.getTransformedEntities()) {
                    if (!(entity2 instanceof LivingEntity)) continue;
                    LivingEntity transformedEntity = (LivingEntity)entity2;
                    MobMetadataUtils.addMobFlags(livingEntity, transformedEntity);
                }
            }
            if (TRANSFORMABLE_ENTITIES.contains(livingEntity.getType())) {
                mcMMO.getTransientMetadataTools().cleanLivingEntityMetadata(livingEntity);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTargetEntity(EntityTargetLivingEntityEvent event) {
        Enderman enderman;
        Entity entity;
        if (!ExperienceConfig.getInstance().isEndermanEndermiteFarmingPrevented()) {
            return;
        }
        if (event.getTarget() == null) {
            return;
        }
        if (event.getTarget() instanceof Endermite && (entity = event.getEntity()) instanceof Enderman && !MobMetadataUtils.hasMobFlag(MobMetaFlagType.EXPLOITED_ENDERMEN, (LivingEntity)(enderman = (Enderman)entity))) {
            MobMetadataUtils.flagMetadata(MobMetaFlagType.EXPLOITED_ENDERMEN, (LivingEntity)enderman);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Entity projectile = event.getProjectile();
            if (!(projectile instanceof Arrow)) {
                return;
            }
            Arrow arrow = (Arrow)projectile;
            ItemStack bow = event.getBow();
            if (bow == null) {
                return;
            }
            if (bow.containsEnchantment(mcMMO.p.getEnchantmentMapper().getInfinity())) {
                projectile.setMetadata("mcMMO: Infinite Arrow", (MetadataValue)MetadataConstants.MCMMO_METADATA_VALUE);
            }
            projectile.setMetadata("mcMMO: Bow Force", (MetadataValue)new FixedMetadataValue((Plugin)this.pluginRef, (Object)Math.min((double)event.getForce() * mcMMO.p.getAdvancedConfig().getForceMultiplier(), 1.0)));
            projectile.setMetadata("mcMMO: Arrow Distance", (MetadataValue)new FixedMetadataValue((Plugin)this.pluginRef, (Object)arrow.getLocation()));
            CombatUtils.delayArrowMetaCleanup((AbstractArrow)arrow);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                return;
            }
            Projectile projectile = event.getEntity();
            if (projectile instanceof Arrow) {
                Arrow arrow = (Arrow)projectile;
                CombatUtils.delayArrowMetaCleanup((AbstractArrow)arrow);
                if (ItemUtils.doesPlayerHaveEnchantmentInHands(player, "multishot")) {
                    arrow.setMetadata("mcMMO: Multi-shot Arrow", (MetadataValue)MetadataConstants.MCMMO_METADATA_VALUE);
                }
                if (!arrow.hasMetadata("mcMMO: Bow Force")) {
                    arrow.setMetadata("mcMMO: Bow Force", (MetadataValue)new FixedMetadataValue((Plugin)this.pluginRef, (Object)1.0));
                }
                if (!arrow.hasMetadata("mcMMO: Arrow Distance")) {
                    arrow.setMetadata("mcMMO: Arrow Distance", (MetadataValue)new FixedMetadataValue((Plugin)this.pluginRef, (Object)arrow.getLocation()));
                }
                if (ItemUtils.doesPlayerHaveEnchantmentInHands(player, "piercing")) {
                    return;
                }
                if (ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.ARCHERY_ARROW_RETRIEVAL, UserManager.getPlayer(player))) {
                    arrow.setMetadata("mcMMO: Tracked Arrow", (MetadataValue)MetadataConstants.MCMMO_METADATA_VALUE);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        Material notYetReplacedType = block.getState().getType();
        if (!BlockUtils.shouldBeWatched(block.getState()) && notYetReplacedType != Material.WATER && notYetReplacedType != Material.LAVA && block.getType() != Material.AIR && block.getType() != Material.CAVE_AIR) {
            return;
        }
        if (entity instanceof FallingBlock || entity instanceof Enderman) {
            boolean isTracked = entity.hasMetadata("mcMMO: Traveling Block");
            if (mcMMO.getUserBlockTracker().isIneligible(block) && !isTracked) {
                mcMMO.getUserBlockTracker().setEligible(block);
                entity.setMetadata("mcMMO: Traveling Block", (MetadataValue)MetadataConstants.MCMMO_METADATA_VALUE);
                TravelingBlockMetaCleanup metaCleanupTask = new TravelingBlockMetaCleanup(entity, this.pluginRef);
                mcMMO.p.getFoliaLib().getScheduler().runAtEntityTimer(entity, (Consumer)metaCleanupTask, 20L, 1200L);
            } else if (isTracked) {
                BlockUtils.setUnnaturalBlock(block);
                entity.removeMetadata("mcMMO: Traveling Block", (Plugin)this.pluginRef);
            }
        } else if (block.getType() != Material.REDSTONE_ORE && !block.getType().getKey().getKey().equalsIgnoreCase("deepslate_redstone_ore") && mcMMO.getUserBlockTracker().isIneligible(block)) {
            mcMMO.getUserBlockTracker().setEligible(block);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityCombustByEntityEvent(EntityCombustByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player defender = (Player)entity;
            Entity entity2 = event.getCombuster();
            if (entity2 instanceof Projectile) {
                Player attacker;
                Projectile projectile = (Projectile)entity2;
                ProjectileSource projectileSource = projectile.getShooter();
                if (projectileSource instanceof Player && this.checkIfInPartyOrSamePlayer((Cancellable)event, defender, attacker = (Player)projectileSource)) {
                    event.setCancelled(true);
                }
            } else {
                Player attacker;
                entity2 = event.getCombuster();
                if (entity2 instanceof Player && this.checkIfInPartyOrSamePlayer((Cancellable)event, defender, attacker = (Player)entity2)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        ProjectileSource shooter;
        Projectile projectile;
        LivingEntity livingEntity;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && CombatUtils.hasIgnoreDamageMetadata(livingEntity = (LivingEntity)entity)) {
            return;
        }
        double damage = event.getFinalDamage();
        Entity defender = event.getEntity();
        Entity attacker = event.getDamager();
        if (WorldGuardUtils.isWorldGuardLoaded() && (attacker instanceof Player ? !WorldGuardManager.getInstance().hasMainFlag((Player)attacker) : attacker instanceof Projectile && (projectile = (Projectile)attacker).getShooter() instanceof Player && !WorldGuardManager.getInstance().hasMainFlag((Player)projectile.getShooter()))) {
            return;
        }
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        if (event.getEntity() instanceof ArmorStand) {
            return;
        }
        if (ExperienceConfig.getInstance().isNPCInteractionPrevented() && Misc.isNPCEntityExcludingVillagers(defender) || !defender.isValid() || !(defender instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)defender;
        if (CombatUtils.isInvincible(target, damage)) {
            return;
        }
        if (ExperienceConfig.getInstance().isNPCInteractionPrevented() && Misc.isNPCEntityExcludingVillagers(attacker)) {
            return;
        }
        if (CombatUtils.hasIgnoreDamageMetadata(target)) {
            return;
        }
        if (attacker instanceof Tameable) {
            AnimalTamer animalTamer = ((Tameable)attacker).getOwner();
            if (animalTamer != null && ((OfflinePlayer)animalTamer).isOnline()) {
                attacker = (Entity)animalTamer;
            }
        } else if (attacker instanceof TNTPrimed) {
            TNTPrimed tntAttacker = (TNTPrimed)attacker;
            if (defender instanceof Player && BlastMining.processBlastMiningExplosion(event, tntAttacker, (Player)defender)) {
                return;
            }
        }
        if (defender instanceof Player) {
            Player attackingPlayer;
            Player defendingPlayer = (Player)defender;
            if (attacker instanceof Projectile) {
                UnarmedManager unarmedManager;
                Player attackingPlayer2;
                Projectile projectile2 = (Projectile)attacker;
                ProjectileSource projectileSource = projectile2.getShooter();
                if (projectileSource instanceof Player && !(attackingPlayer2 = (Player)projectileSource).equals((Object)defendingPlayer) && this.checkIfInPartyOrSamePlayer((Cancellable)event, defendingPlayer, attackingPlayer2)) {
                    return;
                }
                McMMOPlayer mmoPlayer = UserManager.getPlayer(defendingPlayer);
                if (mmoPlayer != null && (unarmedManager = mmoPlayer.getUnarmedManager()).canDeflect() && projectile2 instanceof Arrow && unarmedManager.deflectCheck()) {
                    event.setCancelled(true);
                    return;
                }
            } else if (attacker instanceof Player && this.checkIfInPartyOrSamePlayer((Cancellable)event, defendingPlayer, attackingPlayer = (Player)attacker)) {
                return;
            }
        }
        if (attacker instanceof Projectile && (shooter = ((Projectile)attacker).getShooter()) instanceof LivingEntity) {
            attacker = (LivingEntity)shooter;
        }
        if (mcMMO.isProjectKorraEnabled() && event.getFinalDamage() == 0.0) {
            return;
        }
        CombatUtils.processCombatAttack(event, attacker, target);
        CombatUtils.handleHealthbars(attacker, target, event.getFinalDamage(), this.pluginRef);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onEntityDamageMonitor(EntityDamageByEntityEvent entityDamageEvent) {
        Entity entity;
        Player player;
        Entity entity2 = entityDamageEvent.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            if (entityDamageEvent.getFinalDamage() >= livingEntity.getHealth()) {
                CombatUtils.fixNames(livingEntity);
            }
        }
        if ((entity2 = entityDamageEvent.getDamager()) instanceof Arrow) {
            Arrow arrow = (Arrow)entity2;
            CombatUtils.delayArrowMetaCleanup((AbstractArrow)arrow);
        }
        if ((entity2 = entityDamageEvent.getEntity()) instanceof Player) {
            McMMOPlayer mmoPlayer;
            player = (Player)entity2;
            if (entityDamageEvent.getDamager() instanceof Player && (mmoPlayer = UserManager.getPlayer(player)) != null && mmoPlayer.isDebugMode()) {
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "(mmodebug start of combat report) EntityDamageByEntityEvent DEBUG Info:");
                player.sendMessage("You are being damaged by another player in this event");
                player.sendMessage("Raw Damage: " + entityDamageEvent.getDamage());
                player.sendMessage("Your max health: " + player.getAttribute(AttributeMapper.MAPPED_MAX_HEALTH).getValue());
                player.sendMessage("Your current health: " + player.getHealth());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Damage Modifiers (final damage)");
                entity = EntityDamageEvent.DamageModifier.values();
                int n = ((EntityDamageEvent.DamageModifier[])entity).length;
                for (int i = 0; i < n; ++i) {
                    EntityDamageEvent.DamageModifier modifier = entity[i];
                    player.sendMessage("Modifier " + modifier.name() + ": " + entityDamageEvent.getDamage(modifier));
                }
                player.sendMessage("Final damage: " + entityDamageEvent.getFinalDamage());
                if (entityDamageEvent.isCancelled()) {
                    player.sendMessage("Event was cancelled, which means no damage should be done.");
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "(mmodebug end of combat report)");
            }
        }
        if ((entity = entityDamageEvent.getDamager()) instanceof Player) {
            player = (Player)entity;
            entity = entityDamageEvent.getEntity();
            if (entity instanceof Player) {
                Player otherPlayer = (Player)entity;
                McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
                if (mmoPlayer != null && mmoPlayer.isDebugMode()) {
                    player.sendMessage(String.valueOf(ChatColor.GOLD) + "(mmodebug start of combat report) EntityDamageByEntityEvent DEBUG Info:");
                    player.sendMessage("You are dealing damage to another player in this event");
                    player.sendMessage("Raw Damage: " + entityDamageEvent.getDamage());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Damage Modifiers (final damage)");
                    for (EntityDamageEvent.DamageModifier modifier : EntityDamageEvent.DamageModifier.values()) {
                        player.sendMessage("Modifier " + modifier.name() + ": " + entityDamageEvent.getDamage(modifier));
                    }
                    player.sendMessage("Final damage: " + entityDamageEvent.getFinalDamage());
                    player.sendMessage("Target players max health: " + otherPlayer.getAttribute(AttributeMapper.MAPPED_MAX_HEALTH).getValue());
                    player.sendMessage("Target players current health: " + otherPlayer.getHealth());
                    if (entityDamageEvent.isCancelled()) {
                        player.sendMessage("Event was cancelled, which means no damage should be done.");
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "(mmodebug end of combat report)");
                }
            }
        }
    }

    public boolean checkIfInPartyOrSamePlayer(Cancellable event, Player defendingPlayer, Player attackingPlayer) {
        if (defendingPlayer.equals((Object)attackingPlayer)) {
            return true;
        }
        if (!this.pluginRef.isPartySystemEnabled()) {
            return false;
        }
        if (!UserManager.hasPlayerDataKey((Entity)defendingPlayer) || !UserManager.hasPlayerDataKey((Entity)attackingPlayer)) {
            return true;
        }
        if (!(mcMMO.p.getGeneralConfig().getPartyFriendlyFire() || !mcMMO.p.getPartyManager().inSameParty(defendingPlayer, attackingPlayer) && !mcMMO.p.getPartyManager().areAllies(defendingPlayer, attackingPlayer) || Permissions.friendlyFire((Permissible)attackingPlayer) && Permissions.friendlyFire((Permissible)defendingPlayer))) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        LivingEntity livingEntity;
        Entity entity;
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        if (event.getEntity().hasMetadata("mcMMO: Rupture Explosion")) {
            event.getEntity().removeMetadata("mcMMO: Rupture Explosion", (Plugin)mcMMO.p);
        }
        if ((entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                return;
            }
        }
        InteractionManager.processEvent((Event)event, this.pluginRef, InteractType.ON_ENTITY_DAMAGE);
        entity = event.getEntity();
        if (entity instanceof LivingEntity && CombatUtils.hasIgnoreDamageMetadata(livingEntity = (LivingEntity)entity)) {
            return;
        }
        double damage = event.getFinalDamage();
        if (damage <= 0.0) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (ExperienceConfig.getInstance().isNPCInteractionPrevented() && Misc.isNPCEntityExcludingVillagers(entity2) || !entity2.isValid() || !(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity2 = (LivingEntity)entity2;
        if (CombatUtils.isInvincible(livingEntity2, damage)) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (livingEntity2 instanceof Player) {
            Player player = (Player)entity2;
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return;
            }
            McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
            if (mmoPlayer == null) {
                return;
            }
            if (mmoPlayer.getGodMode()) {
                event.setCancelled(true);
                return;
            }
            if (event.getFinalDamage() >= 1.0) {
                mmoPlayer.actualizeRecentlyHurt();
            }
        } else if (livingEntity2 instanceof Tameable) {
            Player player;
            Tameable pet = (Tameable)livingEntity2;
            AnimalTamer owner = pet.getOwner();
            if (owner instanceof Player) {
                player = (Player)owner;
                if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                    return;
                }
            }
            if (Taming.canPreventDamage(pet, owner)) {
                player = (Player)owner;
                Wolf wolf = (Wolf)pet;
                if (UserManager.getPlayer(player) == null) {
                    return;
                }
                TamingManager tamingManager = UserManager.getPlayer(player).getTamingManager();
                switch (cause) {
                    case CONTACT: 
                    case FIRE: 
                    case HOT_FLOOR: 
                    case LAVA: {
                        if (tamingManager.canUseEnvironmentallyAware()) {
                            tamingManager.processEnvironmentallyAware(wolf, event.getDamage());
                        }
                        return;
                    }
                    case FALL: {
                        if (tamingManager.canUseEnvironmentallyAware()) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                    case ENTITY_ATTACK: 
                    case PROJECTILE: {
                        if (tamingManager.canUseThickFur()) {
                            event.setDamage(Taming.processThickFur(wolf, event.getDamage()));
                            if (event.getFinalDamage() == 0.0) {
                                event.setCancelled(true);
                            }
                        }
                        return;
                    }
                    case FIRE_TICK: {
                        if (tamingManager.canUseThickFur()) {
                            Taming.processThickFurFire(wolf);
                        }
                        return;
                    }
                    case MAGIC: 
                    case POISON: 
                    case WITHER: {
                        if (tamingManager.canUseHolyHound()) {
                            Taming.processHolyHound(wolf, event.getDamage());
                        }
                        return;
                    }
                    case BLOCK_EXPLOSION: 
                    case ENTITY_EXPLOSION: 
                    case LIGHTNING: {
                        if (tamingManager.canUseShockProof()) {
                            event.setDamage(Taming.processShockProof(wolf, event.getDamage()));
                            if (event.getFinalDamage() == 0.0) {
                                event.setCancelled(true);
                            }
                        }
                        return;
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDeathLowest(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (TRANSFORMABLE_ENTITIES.contains(entity.getType())) {
            return;
        }
        mcMMO.getTransientMetadataTools().cleanLivingEntityMetadata(entity);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (mcMMO.getTransientEntityTracker().isTransient(entity)) {
            mcMMO.getTransientEntityTracker().killSummonAndCleanMobFlags(entity, null, false);
        }
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        if (ExperienceConfig.getInstance().isNPCInteractionPrevented() && Misc.isNPCEntityExcludingVillagers((Entity)entity)) {
            return;
        }
        Archery.arrowRetrievalCheck(entity);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        switch (event.getSpawnReason()) {
            case NETHER_PORTAL: {
                this.trackSpawnedAndPassengers(livingEntity, MobMetaFlagType.NETHER_PORTAL_MOB);
                break;
            }
            case SPAWNER: 
            case SPAWNER_EGG: {
                this.trackSpawnedAndPassengers(livingEntity, MobMetaFlagType.MOB_SPAWNER_MOB);
                break;
            }
            case DISPENSE_EGG: 
            case EGG: {
                this.trackSpawnedAndPassengers(livingEntity, MobMetaFlagType.EGG_MOB);
                break;
            }
            case BREEDING: {
                this.trackSpawnedAndPassengers(livingEntity, MobMetaFlagType.PLAYER_BRED_MOB);
                break;
            }
        }
    }

    private void trackSpawnedAndPassengers(LivingEntity livingEntity, MobMetaFlagType mobMetaFlagType) {
        MobMetadataUtils.flagMetadata(mobMetaFlagType, livingEntity);
        for (Entity passenger : livingEntity.getPassengers()) {
            if (passenger == null) continue;
            MobMetadataUtils.flagMetadata(mobMetaFlagType, livingEntity);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityBreed(EntityBreedEvent event) {
        if (ExperienceConfig.getInstance().isCOTWBreedingPrevented() && (MobMetadataUtils.hasMobFlag(MobMetaFlagType.COTW_SUMMONED_MOB, event.getFather()) || MobMetadataUtils.hasMobFlag(MobMetaFlagType.COTW_SUMMONED_MOB, event.getMother()))) {
            event.setCancelled(true);
            Animals mom = (Animals)event.getMother();
            Animals father = (Animals)event.getFather();
            mom.setLoveModeTicks(0);
            father.setLoveModeTicks(0);
            LivingEntity livingEntity = event.getBreeder();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.BreedingDisallowed", new String[0]);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof TNTPrimed) || !entity.hasMetadata("mcMMO: Tracked TNT")) {
            return;
        }
        Player player = this.pluginRef.getServer().getPlayerExact(((MetadataValue)entity.getMetadata("mcMMO: Tracked TNT").get(0)).asString());
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        MiningManager miningManager = UserManager.getPlayer(player).getMiningManager();
        if (miningManager.canUseBiggerBombs()) {
            event.setRadius(miningManager.biggerBombs(event.getRadius()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEnitityExplode(EntityExplodeEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof TNTPrimed) || !entity.hasMetadata("mcMMO: Tracked TNT")) {
            return;
        }
        Player player = this.pluginRef.getServer().getPlayerExact(((MetadataValue)entity.getMetadata("mcMMO: Tracked TNT").get(0)).asString());
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        MiningManager miningManager = UserManager.getPlayer(player).getMiningManager();
        if (miningManager.canUseBlastMining()) {
            miningManager.blastMiningDropProcessing(event.getYield(), event);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        Material foodInHand;
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        HumanEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        int currentFoodLevel = player.getFoodLevel();
        int newFoodLevel = event.getFoodLevel();
        int foodChange = newFoodLevel - currentFoodLevel;
        if (foodChange <= 0) {
            return;
        }
        if (mcMMO.getMaterialMapStore().isFood(player.getInventory().getItemInMainHand().getType())) {
            foodInHand = player.getInventory().getItemInMainHand().getType();
        } else if (mcMMO.getMaterialMapStore().isFood(player.getInventory().getItemInOffHand().getType())) {
            foodInHand = player.getInventory().getItemInOffHand().getType();
        } else {
            return;
        }
        if (foodInHand.getKey().getKey().equalsIgnoreCase("glow_berries")) {
            if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.HERBALISM_FARMERS_DIET)) {
                event.setFoodLevel(UserManager.getPlayer(player).getHerbalismManager().farmersDiet(newFoodLevel));
            }
            return;
        }
        switch (foodInHand) {
            case BAKED_POTATO: 
            case BEETROOT: 
            case BREAD: 
            case CARROT: 
            case GOLDEN_CARROT: 
            case MUSHROOM_STEW: 
            case PUMPKIN_PIE: {
                if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.HERBALISM_FARMERS_DIET)) {
                    event.setFoodLevel(UserManager.getPlayer(player).getHerbalismManager().farmersDiet(newFoodLevel));
                }
                return;
            }
            case COOKIE: 
            case MELON_SLICE: 
            case POISONOUS_POTATO: 
            case POTATO: {
                if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.HERBALISM_FARMERS_DIET)) {
                    event.setFoodLevel(UserManager.getPlayer(player).getHerbalismManager().farmersDiet(newFoodLevel));
                }
                return;
            }
            case COD: 
            case SALMON: 
            case TROPICAL_FISH: 
            case COOKED_COD: 
            case COOKED_SALMON: {
                if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.FISHING_FISHERMANS_DIET)) {
                    event.setFoodLevel(UserManager.getPlayer(player).getFishingManager().handleFishermanDiet(newFoodLevel));
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTame(EntityTameEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        if (event instanceof FakeEntityTameEvent) {
            return;
        }
        Player player = (Player)event.getOwner();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!UserManager.hasPlayerDataKey((Entity)player) || ExperienceConfig.getInstance().isNPCInteractionPrevented() && Misc.isNPCEntityExcludingVillagers((Entity)livingEntity) || MobMetadataUtils.hasMobFlag(MobMetaFlagType.EGG_MOB, livingEntity) || MobMetadataUtils.hasMobFlag(MobMetaFlagType.MOB_SPAWNER_MOB, livingEntity)) {
            return;
        }
        MobMetadataUtils.flagMetadata(MobMetaFlagType.PLAYER_TAMED_MOB, livingEntity);
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        UserManager.getPlayer(player).getTamingManager().awardTamingXP(livingEntity);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        Tameable tameable;
        Entity target;
        block8: {
            block7: {
                if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
                    return;
                }
                Entity entity = event.getEntity();
                target = event.getTarget();
                if (!(entity instanceof Tameable)) break block7;
                tameable = (Tameable)entity;
                if (target instanceof Player) break block8;
            }
            return;
        }
        Player player = (Player)target;
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || !CombatUtils.isFriendlyPet(player, tameable)) {
            return;
        }
        if (!Permissions.friendlyFire((Permissible)player) || !Permissions.friendlyFire((Permissible)((Player)tameable.getOwner()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        ItemMeta meta = event.getPotion().getItem().getItemMeta();
        if (meta == null) {
            return;
        }
        for (PotionEffect effect : ((PotionMeta)meta).getCustomEffects()) {
            if (!effect.getType().equals(PotionEffectType.SATURATION)) {
                return;
            }
            for (LivingEntity entity : event.getAffectedEntities()) {
                int duration = (int)((double)effect.getDuration() * event.getIntensity(entity));
                entity.addPotionEffect(new PotionEffect(effect.getType(), duration, effect.getAmplifier(), effect.isAmbient()));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileHitEvent(ProjectileHitEvent event) {
        Arrow arrow;
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        Projectile projectile = event.getEntity();
        if (projectile instanceof Arrow && ProjectileUtils.isCrossbowProjectile((AbstractArrow)(arrow = (Arrow)projectile))) {
            Crossbows.processCrossbows(event, (Plugin)this.pluginRef, arrow);
        }
    }
}

