/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.unarmed;

import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.inventory.ItemStack;

public class Unarmed {
    public static double berserkDamageModifier = 1.5;

    public static void handleItemPickup(Player player, EntityPickupItemEvent event) {
        ItemStack[] storageContents = player.getInventory().getStorageContents();
        ItemStack itemDrop = event.getItem().getItemStack();
        int heldItemSlotID = player.getInventory().getHeldItemSlot();
        int amount = itemDrop.getAmount();
        boolean grabbedItem = false;
        for (int i = 0; i <= storageContents.length - 1 && amount > 0; ++i) {
            ItemStack modifiedAmount;
            if (i == heldItemSlotID) continue;
            if (storageContents[i] == null) {
                player.getInventory().setItem(i, itemDrop);
                amount = 0;
                grabbedItem = true;
                break;
            }
            if (!itemDrop.isSimilar(storageContents[i]) || storageContents[i].getAmount() >= storageContents[i].getMaxStackSize()) continue;
            if (amount + storageContents[i].getAmount() <= storageContents[i].getMaxStackSize()) {
                modifiedAmount = storageContents[i];
                modifiedAmount.setAmount(amount + storageContents[i].getAmount());
                player.getInventory().setItem(i, modifiedAmount);
                grabbedItem = true;
                amount = 0;
                continue;
            }
            modifiedAmount = storageContents[i];
            int amountThatCanFit = storageContents[i].getMaxStackSize() - storageContents[i].getAmount();
            modifiedAmount.setAmount(amountThatCanFit);
            player.getInventory().setItem(i, modifiedAmount);
            grabbedItem = true;
            amount -= amountThatCanFit;
        }
        if (amount <= 0) {
            event.getItem().remove();
        } else {
            event.getItem().getItemStack().setAmount(amount);
        }
        event.setCancelled(true);
        if (grabbedItem) {
            SoundManager.sendSound(player, player.getLocation(), SoundType.POP);
            player.updateInventory();
        }
    }
}

