/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.experience;

import com.gmail.nossr50.config.BukkitConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.alchemy.PotionStage;
import com.gmail.nossr50.util.text.ConfigStringUtils;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.EntityType;

public class ExperienceConfig
extends BukkitConfig {
    private static ExperienceConfig instance;
    private final Map<PrimarySkillType, Map<Material, Integer>> blockExperienceMap = new HashMap<PrimarySkillType, Map<Material, Integer>>();

    private ExperienceConfig() {
        super("experience.yml");
        this.validate();
    }

    public static ExperienceConfig getInstance() {
        if (instance == null) {
            instance = new ExperienceConfig();
            for (PrimarySkillType skill : PrimarySkillType.values()) {
                HashMap<Material, Integer> experienceMap = new HashMap<Material, Integer>();
                ExperienceConfig.instance.blockExperienceMap.put(skill, experienceMap);
                for (Material material : Material.values()) {
                    int xp = instance.getConfigXp(skill, material);
                    if (xp <= 0) continue;
                    experienceMap.put(material, xp);
                }
            }
        }
        return instance;
    }

    @Override
    protected void loadKeys() {
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> reason = new ArrayList<String>();
        if (this.getMultiplier(FormulaType.EXPONENTIAL) <= 0.0) {
            reason.add("Experience_Formula.Exponential_Values.multiplier should be greater than 0!");
        }
        if (this.getMultiplier(FormulaType.LINEAR) <= 0.0) {
            reason.add("Experience_Formula.Linear_Values.multiplier should be greater than 0!");
        }
        if (this.getExponent(FormulaType.EXPONENTIAL) <= 0.0) {
            reason.add("Experience_Formula.Exponential_Values.exponent should be greater than 0!");
        }
        if (this.getExperienceGainsGlobalMultiplier() <= 0.0) {
            reason.add("Experience_Formula.Multiplier.Global should be greater than 0!");
        }
        if (this.getPlayerVersusPlayerXP() < 0.0) {
            reason.add("Experience_Formula.Multiplier.PVP should be at least 0!");
        }
        if (this.getSpawnedMobXpMultiplier() < 0.0) {
            reason.add("Experience_Formula.Mobspawners.Multiplier should be at least 0!");
        }
        if (this.getBredMobXpMultiplier() < 0.0) {
            reason.add("Experience_Formula.Breeding.Multiplier should be at least 0!");
        }
        if (this.getExpModifier() <= 0.0) {
            reason.add("Conversion.Exp_Modifier should be greater than 0!");
        }
        for (PotionStage potionStage : PotionStage.values()) {
            if (!(this.getPotionXP(potionStage) < 0.0)) continue;
            reason.add("Experience_Values.Alchemy.Potion_Stage_" + potionStage.toNumerical() + " should be at least 0!");
        }
        if (this.getArcheryDistanceMultiplier() < 0.0) {
            reason.add("Experience_Values.Archery.Distance_Multiplier should be at least 0!");
        }
        if (this.getAnimalsXP() < 0.0) {
            reason.add("Experience_Values.Combat.Multiplier.Animals should be at least 0!");
        }
        if (this.getDodgeXPModifier() < 0) {
            reason.add("Skills.Acrobatics.Dodge_XP_Modifier should be at least 0!");
        }
        if (this.getRollXPModifier() < 0) {
            reason.add("Skills.Acrobatics.Roll_XP_Modifier should be at least 0!");
        }
        if (this.getFallXPModifier() < 0) {
            reason.add("Skills.Acrobatics.Fall_XP_Modifier should be at least 0!");
        }
        if (this.getFishingShakeXP() <= 0) {
            reason.add("Experience_Values.Fishing.Shake should be greater than 0!");
        }
        if (this.getRepairXPBase() <= 0.0) {
            reason.add("Experience_Values.Repair.Base should be greater than 0!");
        }
        if (this.getTamingXP(EntityType.WOLF) <= 0) {
            reason.add("Experience_Values.Taming.Animal_Taming.Wolf should be greater than 0!");
        }
        if (this.getTamingXP(EntityType.OCELOT) <= 0) {
            reason.add("Experience_Values.Taming.Animal_Taming.Ocelot should be greater than 0!");
        }
        return this.noErrorsInConfig(reason);
    }

    public boolean isEarlyGameBoostEnabled() {
        return this.config.getBoolean("EarlyGameBoost.Enabled", true);
    }

    public boolean isSnowExploitPrevented() {
        return this.config.getBoolean("ExploitFix.SnowGolemExcavation", true);
    }

    public boolean isEndermanEndermiteFarmingPrevented() {
        return this.config.getBoolean("ExploitFix.EndermanEndermiteFarms", true);
    }

    public boolean isPistonCheatingPrevented() {
        return this.config.getBoolean("ExploitFix.PistonCheating", true);
    }

    public boolean isPistonExploitPrevented() {
        return this.config.getBoolean("ExploitFix.Pistons", false);
    }

    public boolean allowUnsafeEnchantments() {
        return this.config.getBoolean("ExploitFix.UnsafeEnchantments", false);
    }

    public boolean isCOTWBreedingPrevented() {
        return this.config.getBoolean("ExploitFix.COTWBreeding", true);
    }

    public boolean isNPCInteractionPrevented() {
        return this.config.getBoolean("ExploitFix.PreventPluginNPCInteraction", true);
    }

    public boolean isArmorStandInteractionPrevented() {
        return this.config.getBoolean("ExploitFix.PreventArmorStandInteraction", true);
    }

    public boolean isFishingExploitingPrevented() {
        return this.config.getBoolean("ExploitFix.Fishing", true);
    }

    public int getFishingExploitingOptionMoveRange() {
        return this.config.getInt("Fishing_ExploitFix_Options.MoveRange", 3);
    }

    public int getFishingExploitingOptionOverFishLimit() {
        return this.config.getInt("Fishing_ExploitFix_Options.OverFishLimit", 10);
    }

    public boolean isAcrobaticsExploitingPrevented() {
        return this.config.getBoolean("ExploitFix.Acrobatics", true);
    }

    public boolean isTreeFellerXPReduced() {
        return this.config.getBoolean("ExploitFix.TreeFellerReducedXP", true);
    }

    public FormulaType getFormulaType() {
        return FormulaType.getFormulaType(this.config.getString("Experience_Formula.Curve"));
    }

    public boolean getCumulativeCurveEnabled() {
        return this.config.getBoolean("Experience_Formula.Cumulative_Curve", false);
    }

    public double getMultiplier(FormulaType type) {
        return this.config.getDouble("Experience_Formula." + StringUtils.getCapitalized(type.toString()) + "_Values.multiplier");
    }

    public int getBase(FormulaType type) {
        return this.config.getInt("Experience_Formula." + StringUtils.getCapitalized(type.toString()) + "_Values.base");
    }

    public double getExponent(FormulaType type) {
        return this.config.getDouble("Experience_Formula." + StringUtils.getCapitalized(type.toString()) + "_Values.exponent");
    }

    public double getExperienceGainsGlobalMultiplier() {
        return this.config.getDouble("Experience_Formula.Multiplier.Global", 1.0);
    }

    public void setExperienceGainsGlobalMultiplier(double value) {
        this.config.set("Experience_Formula.Multiplier.Global", (Object)value);
    }

    public double getPlayerVersusPlayerXP() {
        return this.config.getDouble("Experience_Formula.Multiplier.PVP", 1.0);
    }

    public double getSpawnedMobXpMultiplier() {
        return this.config.getDouble("Experience_Formula.Mobspawners.Multiplier", 0.0);
    }

    public double getEggXpMultiplier() {
        return this.config.getDouble("Experience_Formula.Eggs.Multiplier", 0.0);
    }

    public double getTamedMobXpMultiplier() {
        return this.config.getDouble("Experience_Formula.Player_Tamed.Multiplier", 0.0);
    }

    public double getNetherPortalXpMultiplier() {
        return this.config.getDouble("Experience_Formula.Nether_Portal.Multiplier", 0.0);
    }

    public double getBredMobXpMultiplier() {
        return this.config.getDouble("Experience_Formula.Breeding.Multiplier", 1.0);
    }

    public double getFormulaSkillModifier(PrimarySkillType skill) {
        return this.config.getDouble("Experience_Formula.Skill_Multiplier." + StringUtils.getCapitalized(skill.toString()), 1.0);
    }

    public double getCustomXpPerkBoost() {
        return this.config.getDouble("Experience_Formula.Custom_XP_Perk.Boost", 1.25);
    }

    public float getDiminishedReturnsCap() {
        return (float)this.config.getDouble("Diminished_Returns.Guaranteed_Minimum_Percentage", 0.05);
    }

    public boolean getDiminishedReturnsEnabled() {
        return this.config.getBoolean("Diminished_Returns.Enabled", false);
    }

    public int getDiminishedReturnsThreshold(PrimarySkillType skill) {
        return this.config.getInt("Diminished_Returns.Threshold." + StringUtils.getCapitalized(skill.toString()), 20000);
    }

    public int getDiminishedReturnsTimeInterval() {
        return this.config.getInt("Diminished_Returns.Time_Interval", 10);
    }

    public double getExpModifier() {
        return this.config.getDouble("Conversion.Exp_Modifier", 1.0);
    }

    public boolean getExperienceGainsPlayerVersusPlayerEnabled() {
        return this.config.getBoolean("Experience_Values.PVP.Rewards", true);
    }

    public double getCombatXP(String entity) {
        return this.config.getDouble("Experience_Values.Combat.Multiplier." + entity);
    }

    public double getCombatXP(EntityType entity) {
        return this.config.getDouble("Experience_Values.Combat.Multiplier." + ConfigStringUtils.getConfigEntityTypeString(entity).replace(" ", "_"));
    }

    public double getAnimalsXP(EntityType entity) {
        return this.config.getDouble("Experience_Values.Combat.Multiplier." + ConfigStringUtils.getConfigEntityTypeString(entity).replace(" ", "_"), this.getAnimalsXP());
    }

    public double getAnimalsXP() {
        return this.config.getDouble("Experience_Values.Combat.Multiplier.Animals", 1.0);
    }

    public boolean hasCombatXP(EntityType entity) {
        return this.config.contains("Experience_Values.Combat.Multiplier." + ConfigStringUtils.getConfigEntityTypeString(entity).replace(" ", "_"));
    }

    private int getConfigXp(PrimarySkillType skill, Material material) {
        if (material == Material.LILY_PAD) {
            return 0;
        }
        String baseString = "Experience_Values." + StringUtils.getCapitalized(skill.toString()) + ".";
        String configPath = baseString + ConfigStringUtils.getMaterialConfigString(material);
        return this.config.getInt(configPath, 0);
    }

    public int getXp(PrimarySkillType skill, Material material) {
        return this.blockExperienceMap.get((Object)skill).getOrDefault(material, 0);
    }

    public int getXp(PrimarySkillType skill, BlockState blockState) {
        return this.getXp(skill, blockState.getType());
    }

    public int getXp(PrimarySkillType skill, Block block) {
        Material material = block.getType();
        return this.getXp(skill, material);
    }

    public int getXp(PrimarySkillType skill, BlockData data) {
        return this.getXp(skill, data.getMaterial());
    }

    public boolean doesBlockGiveSkillXP(PrimarySkillType skill, Material material) {
        return this.getXp(skill, material) > 0;
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    public boolean doesBlockGiveSkillXP(PrimarySkillType skill, BlockData data) {
        return this.getXp(skill, data) > 0;
    }

    public boolean isPartyExperienceBarsEnabled() {
        return this.config.getBoolean("Experience_Bars.Update.Party", true);
    }

    public boolean isPassiveGainsExperienceBarsEnabled() {
        return this.config.getBoolean("Experience_Bars.Update.Passive", true);
    }

    public boolean getDoExperienceBarsAlwaysUpdateTitle() {
        return this.config.getBoolean("Experience_Bars.ThisMayCauseLag.AlwaysUpdateTitlesWhenXPIsGained.Enable", false) || this.getAddExtraDetails();
    }

    public boolean getAddExtraDetails() {
        return this.config.getBoolean("Experience_Bars.ThisMayCauseLag.AlwaysUpdateTitlesWhenXPIsGained.ExtraDetails", false);
    }

    public boolean useCombatHPCeiling() {
        return this.config.getBoolean("ExploitFix.Combat.XPCeiling.Enabled", true);
    }

    public int getCombatHPCeiling() {
        return this.config.getInt("ExploitFix.Combat.XPCeiling.HP_Modifier_Limit", 100);
    }

    public boolean isExperienceBarsEnabled() {
        return this.config.getBoolean("Experience_Bars.Enable", true);
    }

    public boolean isExperienceBarEnabled(PrimarySkillType primarySkillType) {
        return this.config.getBoolean("Experience_Bars." + StringUtils.getCapitalized(primarySkillType.toString()) + ".Enable", true);
    }

    public BarColor getExperienceBarColor(PrimarySkillType primarySkillType) {
        String colorValueFromConfig = this.config.getString("Experience_Bars." + StringUtils.getCapitalized(primarySkillType.toString()) + ".Color");
        for (BarColor barColor : BarColor.values()) {
            if (!barColor.toString().equalsIgnoreCase(colorValueFromConfig)) continue;
            return barColor;
        }
        return BarColor.WHITE;
    }

    public BarStyle getExperienceBarStyle(PrimarySkillType primarySkillType) {
        String colorValueFromConfig = this.config.getString("Experience_Bars." + StringUtils.getCapitalized(primarySkillType.toString()) + ".BarStyle");
        for (BarStyle barStyle : BarStyle.values()) {
            if (!barStyle.toString().equalsIgnoreCase(colorValueFromConfig)) continue;
            return barStyle;
        }
        return BarStyle.SOLID;
    }

    public int getDodgeXPModifier() {
        return this.config.getInt("Experience_Values.Acrobatics.Dodge", 120);
    }

    public int getRollXPModifier() {
        return this.config.getInt("Experience_Values.Acrobatics.Roll", 80);
    }

    public int getFallXPModifier() {
        return this.config.getInt("Experience_Values.Acrobatics.Fall", 120);
    }

    public double getFeatherFallXPModifier() {
        return this.config.getDouble("Experience_Values.Acrobatics.FeatherFall_Multiplier", 2.0);
    }

    public double getPotionXP(PotionStage stage) {
        return this.config.getDouble("Experience_Values.Alchemy.Potion_Brewing.Stage_" + stage.toNumerical(), 10.0);
    }

    public double getArcheryDistanceMultiplier() {
        return this.config.getDouble("Experience_Values.Archery.Distance_Multiplier", 0.025);
    }

    public int getFishingShakeXP() {
        return this.config.getInt("Experience_Values.Fishing.Shake", 50);
    }

    public double getRepairXPBase() {
        return this.config.getDouble("Experience_Values.Repair.Base", 1000.0);
    }

    public double getRepairXP(MaterialType repairMaterialType) {
        return this.config.getDouble("Experience_Values.Repair." + StringUtils.getCapitalized(repairMaterialType.toString()));
    }

    public int getTamingXP(EntityType type) {
        return this.config.getInt("Experience_Values.Taming.Animal_Taming." + ConfigStringUtils.getConfigEntityTypeString(type));
    }

    public boolean preventStoneLavaFarming() {
        return this.config.getBoolean("ExploitFix.LavaStoneAndCobbleFarming", true);
    }

    public boolean limitXPOnTallPlants() {
        return this.config.getBoolean("ExploitFix.LimitTallPlantFarming", true);
    }
}

