/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.skills.archery.Archery;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class ArcheryCommand
extends SkillCommand {
    private String skillShotBonus;
    private String dazeChance;
    private String dazeChanceLucky;
    private String retrieveChance;
    private String retrieveChanceLucky;
    private boolean canSkillShot;
    private boolean canDaze;
    private boolean canRetrieve;

    public ArcheryCommand() {
        super(PrimarySkillType.ARCHERY);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canRetrieve) {
            String[] retrieveStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.ARCHERY_ARROW_RETRIEVAL);
            this.retrieveChance = retrieveStrings[0];
            this.retrieveChanceLucky = retrieveStrings[1];
        }
        if (this.canDaze) {
            String[] dazeStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.ARCHERY_DAZE);
            this.dazeChance = dazeStrings[0];
            this.dazeChanceLucky = dazeStrings[1];
        }
        if (this.canSkillShot) {
            this.skillShotBonus = this.percent.format(Archery.getDamageBonusPercent(player));
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canSkillShot = Permissions.canUseSubSkill(player, SubSkillType.ARCHERY_SKILL_SHOT);
        this.canDaze = Permissions.canUseSubSkill(player, SubSkillType.ARCHERY_DAZE);
        this.canRetrieve = Permissions.canUseSubSkill(player, SubSkillType.ARCHERY_ARROW_RETRIEVAL);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canRetrieve) {
            messages.add(this.getStatMessage(SubSkillType.ARCHERY_ARROW_RETRIEVAL, this.retrieveChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.retrieveChanceLucky) : ""));
        }
        if (this.canDaze) {
            messages.add(this.getStatMessage(SubSkillType.ARCHERY_DAZE, this.dazeChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.dazeChanceLucky) : ""));
        }
        if (this.canSkillShot) {
            messages.add(this.getStatMessage(SubSkillType.ARCHERY_SKILL_SHOT, this.skillShotBonus));
        }
        if (Permissions.canUseSubSkill(player, SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK)) {
            messages.add(this.getStatMessage(SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK, 1000))));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.ARCHERY);
        return textComponents;
    }
}

