/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.flatfile;

import com.gmail.nossr50.database.FlatFileDataFlag;
import com.gmail.nossr50.database.flatfile.BadCategorizedFlatFileData;
import com.gmail.nossr50.database.flatfile.FlatFileDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlatFileDataUtil {
    @Nullable
    public static String[] getPreparedSaveDataLine(@NotNull FlatFileDataContainer dataContainer) {
        String[] splitData;
        if (dataContainer.getDataFlags() == null) {
            return dataContainer.getSplitData();
        }
        if (dataContainer.getDataFlags().contains((Object)FlatFileDataFlag.CORRUPTED_OR_UNRECOGNIZABLE) || dataContainer.getDataFlags().contains((Object)FlatFileDataFlag.DUPLICATE_UUID) || dataContainer.getDataFlags().contains((Object)FlatFileDataFlag.BAD_UUID_DATA) || dataContainer.getDataFlags().contains((Object)FlatFileDataFlag.TOO_INCOMPLETE)) {
            return null;
        }
        if (dataContainer instanceof BadCategorizedFlatFileData) {
            BadCategorizedFlatFileData badData = (BadCategorizedFlatFileData)dataContainer;
            splitData = FlatFileDataUtil.repairBadData(dataContainer.getSplitData(), badData.getBadDataIndexes());
        } else {
            splitData = dataContainer.getSplitData();
        }
        assert (splitData.length == 55);
        return splitData;
    }

    @NotNull
    public static String[] repairBadData(@NotNull String[] splitData, boolean[] badDataValues) {
        for (int i = 0; i < 55; ++i) {
            if (!badDataValues[i]) continue;
            splitData[i] = FlatFileDataUtil.getZeroInitialisedData(i, 0);
        }
        return splitData;
    }

    @NotNull
    public static String getZeroInitialisedData(int index, int startingLevel) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> "_INVALID_OLD_USERNAME_'";
            case 2, 3, 23, 33, 37, 38 -> "IGNORED";
            case 1, 5, 7, 8, 9, 10, 11, 12, 13, 14, 24, 34, 39, 46, 48, 53 -> String.valueOf(startingLevel);
            case 44 -> String.valueOf(-1L);
            case 4, 6, 15, 16, 17, 18, 19, 20, 21, 22, 25, 26, 27, 28, 29, 30, 31, 32, 35, 36, 40, 42, 43, 45, 47, 49, 50, 51, 52, 54 -> "0";
            case 41 -> throw new IndexOutOfBoundsException();
            default -> throw new IndexOutOfBoundsException();
        };
    }
}

