/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.sounds;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.jetbrains.annotations.Nullable;

public final class SoundRegistryUtils {
    private static Method registryLookup;
    private static Object soundReg;
    public static final String PAPER_SOUND_REGISTRY_FIELD = "SOUND_EVENT";
    public static final String SPIGOT_SOUND_REGISTRY_FIELD = "SOUNDS";
    public static final String METHOD_GET_OR_THROW_NAME = "getOrThrow";
    public static final String METHOD_GET_NAME = "get";

    public static boolean useLegacyLookup() {
        return registryLookup == null;
    }

    @Nullable
    public static Sound getSound(String id, String fallBackId) {
        if (registryLookup != null) {
            try {
                return (Sound)registryLookup.invoke(soundReg, NamespacedKey.fromString((String)id));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                if (fallBackId != null) {
                    LogUtils.debug(mcMMO.p.getLogger(), String.format("Could not find sound with ID '%s', trying fallback ID '%s'", id, fallBackId));
                    try {
                        return (Sound)registryLookup.invoke(soundReg, NamespacedKey.fromString((String)fallBackId));
                    }
                    catch (IllegalAccessException | InvocationTargetException ex) {
                        mcMMO.p.getLogger().severe(String.format("Could not find sound with ID %s, fallback ID of %s also failed.", id, fallBackId));
                    }
                } else {
                    mcMMO.p.getLogger().severe(String.format("Could not find sound with ID %s.", id));
                }
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static {
        boolean foundRegistry = false;
        try {
            Class<?> registry = Class.forName("org.bukkit.Registry");
            try {
                soundReg = registry.getField(PAPER_SOUND_REGISTRY_FIELD).get(null);
                foundRegistry = true;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                try {
                    soundReg = registry.getField(SPIGOT_SOUND_REGISTRY_FIELD);
                    foundRegistry = true;
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (foundRegistry) {
            try {
                registryLookup = soundReg.getClass().getMethod(METHOD_GET_OR_THROW_NAME, NamespacedKey.class);
            }
            catch (NoSuchMethodException e) {
                try {
                    registryLookup = soundReg.getClass().getMethod(METHOD_GET_NAME, NamespacedKey.class);
                }
                catch (NoSuchMethodException ex) {
                    registryLookup = null;
                }
            }
        }
    }
}

