/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyLeader;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class PartyAPI {
    private PartyAPI() {
    }

    public static String getPartyName(Player player) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled() || !PartyAPI.inParty(player)) {
            return null;
        }
        return UserManager.getPlayer(player).getParty().getName();
    }

    public static boolean isPartySystemEnabled() {
        return mcMMO.p.getPartyConfig().isPartyEnabled();
    }

    public static boolean inParty(Player player) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled() || UserManager.getPlayer(player) == null) {
            return false;
        }
        return UserManager.getPlayer(player).inParty();
    }

    public static boolean inSameParty(Player playerA, Player playerB) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled()) {
            return false;
        }
        return mcMMO.p.getPartyManager().inSameParty(playerA, playerB);
    }

    public static List<Party> getParties() {
        return mcMMO.p.getPartyManager().getParties();
    }

    @Deprecated
    public static void addToParty(Player player, String partyName) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled()) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            return;
        }
        Party party = mcMMO.p.getPartyManager().getParty(partyName);
        if (party == null) {
            party = new Party(new PartyLeader(player.getUniqueId(), player.getName()), partyName);
        } else if (mcMMO.p.getPartyManager().isPartyFull(player, party)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.PARTY_MESSAGE, "Commands.Party.PartyFull", party.toString());
            return;
        }
        mcMMO.p.getPartyManager().addToParty(mmoPlayer, party);
    }

    public static int getMaxPartySize() {
        return mcMMO.p.getGeneralConfig().getPartyMaxSize();
    }

    public static void addToParty(Player player, String partyName, boolean bypassLimit) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled() || UserManager.getPlayer(player) == null) {
            return;
        }
        Party party = mcMMO.p.getPartyManager().getParty(partyName);
        if (party == null) {
            party = new Party(new PartyLeader(player.getUniqueId(), player.getName()), partyName);
        }
        mcMMO.p.getPartyManager().addToParty(UserManager.getPlayer(player), party);
    }

    public static void removeFromParty(Player player) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled() || UserManager.getPlayer(player) == null) {
            return;
        }
        mcMMO.p.getPartyManager().removeFromParty(UserManager.getPlayer(player));
    }

    @Nullable
    public static String getPartyLeader(String partyName) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled()) {
            return null;
        }
        return mcMMO.p.getPartyManager().getPartyLeaderName(partyName);
    }

    @Deprecated
    public static void setPartyLeader(String partyName, String playerName) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled()) {
            return;
        }
        mcMMO.p.getPartyManager().setPartyLeader(mcMMO.p.getServer().getOfflinePlayer(playerName).getUniqueId(), mcMMO.p.getPartyManager().getParty(partyName));
    }

    @Deprecated
    public static List<OfflinePlayer> getOnlineAndOfflineMembers(Player player) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled()) {
            return null;
        }
        ArrayList<OfflinePlayer> members = new ArrayList<OfflinePlayer>();
        for (UUID memberUniqueId : mcMMO.p.getPartyManager().getAllMembers(player).keySet()) {
            OfflinePlayer member = mcMMO.p.getServer().getOfflinePlayer(memberUniqueId);
            members.add(member);
        }
        return members;
    }

    @Deprecated
    public static LinkedHashSet<String> getMembers(Player player) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled()) {
            return null;
        }
        return (LinkedHashSet)mcMMO.p.getPartyManager().getAllMembers(player).values();
    }

    public static LinkedHashMap<UUID, String> getMembersMap(Player player) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled()) {
            return null;
        }
        return mcMMO.p.getPartyManager().getAllMembers(player);
    }

    public static List<Player> getOnlineMembers(String partyName) {
        if (!mcMMO.p.getPartyConfig().isPartyEnabled()) {
            return null;
        }
        return mcMMO.p.getPartyManager().getOnlineMembers(partyName);
    }

    public static List<Player> getOnlineMembers(Player player) {
        return mcMMO.p.getPartyManager().getOnlineMembers(player);
    }

    public static boolean hasAlly(String partyName) {
        return PartyAPI.getAllyName(partyName) != null;
    }

    public static String getAllyName(String partyName) {
        Party ally = mcMMO.p.getPartyManager().getParty(partyName).getAlly();
        if (ally != null) {
            return ally.getName();
        }
        return null;
    }
}

