/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.meta.BonusDropMeta;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.util.MaterialUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import java.util.HashSet;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockUtils {
    public static final String SHORT_GRASS = "SHORT_GRASS";
    public static final String GRASS = "GRASS";

    private BlockUtils() {
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    public static void markDropsAsBonus(BlockState blockState, boolean triple) {
        if (triple) {
            blockState.getBlock().setMetadata("mcMMO: Double Drops", (MetadataValue)new BonusDropMeta(2, mcMMO.p));
        } else {
            blockState.getBlock().setMetadata("mcMMO: Double Drops", (MetadataValue)new BonusDropMeta(1, mcMMO.p));
        }
    }

    public static void markDropsAsBonus(Block block, boolean triple) {
        if (triple) {
            block.setMetadata("mcMMO: Double Drops", (MetadataValue)new BonusDropMeta(2, mcMMO.p));
        } else {
            block.setMetadata("mcMMO: Double Drops", (MetadataValue)new BonusDropMeta(1, mcMMO.p));
        }
    }

    public static Material getShortGrass() {
        if (Material.getMaterial((String)SHORT_GRASS) != null) {
            return Material.getMaterial((String)SHORT_GRASS);
        }
        if (Material.getMaterial((String)GRASS) != null) {
            return Material.getMaterial((String)GRASS);
        }
        throw new UnsupportedOperationException("Unable to find short grass material");
    }

    public static void setUnnaturalBlock(@NotNull Block block) {
        mcMMO.getUserBlockTracker().setIneligible(block);
        if (block.hasMetadata("mcMMO: Double Drops")) {
            block.removeMetadata("mcMMO: Double Drops", (Plugin)mcMMO.p);
        }
    }

    public static void cleanupBlockMetadata(Block block) {
        if (block.hasMetadata("mcMMO: Recently Replanted")) {
            block.removeMetadata("mcMMO: Recently Replanted", (Plugin)mcMMO.p);
        }
        mcMMO.getUserBlockTracker().setEligible(block);
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    public static void markDropsAsBonus(BlockState blockState, int amount) {
        blockState.setMetadata("mcMMO: Double Drops", (MetadataValue)new BonusDropMeta(amount, mcMMO.p));
    }

    public static void markDropsAsBonus(Block block, int amount) {
        block.setMetadata("mcMMO: Double Drops", (MetadataValue)new BonusDropMeta(amount, mcMMO.p));
    }

    @Deprecated(forRemoval=true, since="2.2.010")
    public static boolean checkDoubleDrops(Player player, BlockState blockState, PrimarySkillType ignored, SubSkillType subSkillType) {
        return BlockUtils.checkDoubleDrops(UserManager.getPlayer(player), blockState, subSkillType);
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    public static boolean checkDoubleDrops(@Nullable McMMOPlayer mmoPlayer, @NotNull BlockState blockState, @NotNull SubSkillType subSkillType) {
        Objects.requireNonNull(blockState, "blockState cannot be null");
        Objects.requireNonNull(subSkillType, "subSkillType cannot be null");
        if (mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(subSkillType.getParentSkill(), blockState.getType()) && Permissions.isSubSkillEnabled(mmoPlayer, subSkillType)) {
            return ProbabilityUtil.isSkillRNGSuccessful(subSkillType, mmoPlayer);
        }
        return false;
    }

    public static boolean checkDoubleDrops(@Nullable McMMOPlayer mmoPlayer, @NotNull Block block, @NotNull SubSkillType subSkillType) {
        Objects.requireNonNull(block, "block cannot be null");
        Objects.requireNonNull(subSkillType, "subSkillType cannot be null");
        if (mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(subSkillType.getParentSkill(), block.getType()) && Permissions.isSubSkillEnabled(mmoPlayer, subSkillType)) {
            return ProbabilityUtil.isSkillRNGSuccessful(subSkillType, mmoPlayer);
        }
        return false;
    }

    public static boolean shouldBeWatched(BlockState blockState) {
        return BlockUtils.shouldBeWatched(blockState.getType());
    }

    public static boolean shouldBeWatched(Material material) {
        return BlockUtils.affectedByGigaDrillBreaker(material) || BlockUtils.affectedByGreenTerra(material) || BlockUtils.affectedBySuperBreaker(material) || BlockUtils.hasWoodcuttingXP(material) || mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.MINING, material) || mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.EXCAVATION, material) || mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.WOODCUTTING, material) || mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.SMELTING, material);
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    public static boolean canActivateAbilities(BlockState blockState) {
        return !mcMMO.getMaterialMapStore().isAbilityActivationBlackListed(blockState.getType());
    }

    public static boolean canActivateAbilities(Block block) {
        return !mcMMO.getMaterialMapStore().isAbilityActivationBlackListed(block.getType());
    }

    public static boolean canActivateTools(BlockState blockState) {
        return !mcMMO.getMaterialMapStore().isToolActivationBlackListed(blockState.getType()) && blockState.getType() != Repair.anvilMaterial && blockState.getType() != Salvage.anvilMaterial;
    }

    public static boolean isOre(BlockState blockState) {
        return BlockUtils.isOre(blockState.getType());
    }

    public static boolean isOre(Block block) {
        return BlockUtils.isOre(block.getType());
    }

    public static boolean isOre(Material material) {
        return MaterialUtils.isOre(material);
    }

    @Deprecated(since="2.2.024")
    public static boolean canMakeMossy(BlockState blockState) {
        return mcMMO.getMaterialMapStore().isMossyWhiteListed(blockState.getType());
    }

    public static boolean canMakeMossy(Block block) {
        return mcMMO.getMaterialMapStore().isMossyWhiteListed(block.getType());
    }

    public static boolean affectedByGreenTerra(BlockState blockState) {
        return BlockUtils.affectedByGreenTerra(blockState.getType());
    }

    public static boolean affectedByGreenTerra(Block block) {
        return BlockUtils.affectedByGreenTerra(block.getType());
    }

    public static boolean affectedByGreenTerra(Material material) {
        return ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.HERBALISM, material);
    }

    public static boolean affectedBySuperBreaker(BlockState blockState) {
        return BlockUtils.affectedBySuperBreaker(blockState.getType());
    }

    public static boolean affectedBySuperBreaker(Block block) {
        return BlockUtils.affectedBySuperBreaker(block.getType());
    }

    public static boolean affectedBySuperBreaker(Material material) {
        if (mcMMO.getMaterialMapStore().isIntendedToolPickaxe(material)) {
            return true;
        }
        return ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.MINING, material);
    }

    public static boolean affectedByGigaDrillBreaker(@NotNull BlockState blockState) {
        return BlockUtils.affectedByGigaDrillBreaker(blockState.getType());
    }

    public static boolean affectedByGigaDrillBreaker(@NotNull Block block) {
        return BlockUtils.affectedByGigaDrillBreaker(block.getType());
    }

    public static boolean affectedByGigaDrillBreaker(@NotNull Material material) {
        return ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.EXCAVATION, material);
    }

    public static boolean hasWoodcuttingXP(@NotNull BlockState blockState) {
        return BlockUtils.hasWoodcuttingXP(blockState.getType());
    }

    public static boolean hasWoodcuttingXP(@NotNull Block block) {
        return BlockUtils.hasWoodcuttingXP(block.getType());
    }

    public static boolean hasWoodcuttingXP(@NotNull Material material) {
        return ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.WOODCUTTING, material);
    }

    public static boolean isNonWoodPartOfTree(@NotNull BlockState blockState) {
        return BlockUtils.isNonWoodPartOfTree(blockState.getType());
    }

    public static boolean isNonWoodPartOfTree(@NotNull Block block) {
        return BlockUtils.isNonWoodPartOfTree(block.getType());
    }

    public static boolean isNonWoodPartOfTree(@NotNull Material material) {
        return mcMMO.getMaterialMapStore().isTreeFellerDestructible(material);
    }

    public static boolean canActivateHerbalism(BlockState blockState) {
        return mcMMO.getMaterialMapStore().isHerbalismAbilityWhiteListed(blockState.getType());
    }

    public static boolean affectedByBlockCracker(BlockState blockState) {
        return BlockUtils.affectedByBlockCracker(blockState.getType());
    }

    public static boolean affectedByBlockCracker(Block block) {
        return BlockUtils.affectedByBlockCracker(block.getType());
    }

    public static boolean affectedByBlockCracker(Material material) {
        return mcMMO.getMaterialMapStore().isBlockCrackerWhiteListed(material);
    }

    public static boolean canMakeShroomy(BlockState blockState) {
        return mcMMO.getMaterialMapStore().isShroomyWhiteListed(blockState.getType());
    }

    public static boolean isMcMMOAnvil(BlockState blockState) {
        Material type = blockState.getType();
        return type == Repair.anvilMaterial || type == Salvage.anvilMaterial;
    }

    public static boolean isPistonPiece(BlockState blockState) {
        Material type = blockState.getType();
        return type == Material.MOVING_PISTON || type == Material.AIR;
    }

    public static HashSet<Material> getTransparentBlocks() {
        HashSet<Material> transparentBlocks = new HashSet<Material>();
        for (Material material : Material.values()) {
            if (!material.isTransparent()) continue;
            transparentBlocks.add(material);
        }
        return transparentBlocks;
    }

    public static boolean isFullyGrown(BlockState blockState) {
        BlockData data = blockState.getBlockData();
        if (data.getMaterial() == Material.CACTUS || data.getMaterial() == Material.SUGAR_CANE) {
            return true;
        }
        if (data instanceof Ageable) {
            Ageable ageable = (Ageable)data;
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return true;
    }

    public static boolean isPartOfTree(Block block) {
        return BlockUtils.hasWoodcuttingXP(block.getState()) || BlockUtils.isNonWoodPartOfTree(block.getType());
    }

    public static boolean isWithinWorldBounds(@NotNull Block block) {
        World world = block.getWorld();
        return block.getY() >= world.getMinHeight() && block.getY() < world.getMaxHeight();
    }
}

