/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.flatfile;

import com.gmail.nossr50.database.FlatFileDataFlag;
import com.gmail.nossr50.database.flatfile.BadCategorizedFlatFileData;
import com.gmail.nossr50.database.flatfile.CategorizedFlatFileData;
import com.gmail.nossr50.database.flatfile.FlatFileDataContainer;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class FlatFileDataBuilder {
    @NotNull
    private final HashSet<FlatFileDataFlag> dataFlags;
    @NotNull
    private String[] splitStringData;
    private final int uniqueProcessingId;
    private boolean[] badDataValues;

    public FlatFileDataBuilder(@NotNull String[] splitStringData, int uniqueProcessingId) {
        this.uniqueProcessingId = uniqueProcessingId;
        this.splitStringData = splitStringData;
        this.dataFlags = new HashSet();
    }

    @NotNull
    public FlatFileDataBuilder appendFlag(@NotNull FlatFileDataFlag dataFlag) {
        this.dataFlags.add(dataFlag);
        return this;
    }

    @NotNull
    public FlatFileDataBuilder appendBadDataValues(boolean[] badDataValues) {
        this.badDataValues = badDataValues;
        return this;
    }

    @NotNull
    public FlatFileDataContainer build() {
        if (this.dataFlags.contains((Object)FlatFileDataFlag.BAD_VALUES)) {
            return new BadCategorizedFlatFileData(this.uniqueProcessingId, this.dataFlags, this.splitStringData, this.badDataValues);
        }
        return new CategorizedFlatFileData(this.uniqueProcessingId, this.dataFlags, this.splitStringData);
    }

    @NotNull
    public FlatFileDataBuilder setSplitStringData(@NotNull String[] splitStringData) {
        this.splitStringData = splitStringData;
        return this;
    }
}

