/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class UnarmedCommand
extends SkillCommand {
    private String berserkLength;
    private String berserkLengthEndurance;
    private String deflectChance;
    private String deflectChanceLucky;
    private String disarmChance;
    private String disarmChanceLucky;
    private String ironGripChance;
    private String ironGripChanceLucky;
    private double ironArmBonus;
    private boolean canBerserk;
    private boolean canDisarm;
    private boolean canIronArm;
    private boolean canDeflect;
    private boolean canIronGrip;

    public UnarmedCommand() {
        super(PrimarySkillType.UNARMED);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canDeflect) {
            String[] deflectStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.UNARMED_ARROW_DEFLECT);
            this.deflectChance = deflectStrings[0];
            this.deflectChanceLucky = deflectStrings[1];
        }
        if (this.canBerserk) {
            String[] berserkStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.berserkLength = berserkStrings[0];
            this.berserkLengthEndurance = berserkStrings[1];
        }
        if (this.canDisarm) {
            String[] disarmStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.UNARMED_DISARM);
            this.disarmChance = disarmStrings[0];
            this.disarmChanceLucky = disarmStrings[1];
        }
        if (this.canIronArm) {
            this.ironArmBonus = this.mmoPlayer.getUnarmedManager().getSteelArmStyleDamage();
        }
        if (this.canIronGrip) {
            String[] ironGripStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.UNARMED_IRON_GRIP);
            this.ironGripChance = ironGripStrings[0];
            this.ironGripChanceLucky = ironGripStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBerserk = RankUtils.hasUnlockedSubskill(player, SubSkillType.UNARMED_BERSERK) && Permissions.berserk((Permissible)player);
        this.canIronArm = Permissions.canUseSubSkill(player, SubSkillType.UNARMED_STEEL_ARM_STYLE);
        this.canDeflect = Permissions.canUseSubSkill(player, SubSkillType.UNARMED_ARROW_DEFLECT);
        this.canDisarm = Permissions.canUseSubSkill(player, SubSkillType.UNARMED_DISARM);
        this.canIronGrip = Permissions.canUseSubSkill(player, SubSkillType.UNARMED_IRON_GRIP);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canDeflect) {
            messages.add(this.getStatMessage(SubSkillType.UNARMED_ARROW_DEFLECT, this.deflectChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.deflectChanceLucky) : ""));
        }
        if (this.canBerserk) {
            messages.add(this.getStatMessage(SubSkillType.UNARMED_BERSERK, this.berserkLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.berserkLengthEndurance) : ""));
        }
        if (this.canDisarm) {
            messages.add(this.getStatMessage(SubSkillType.UNARMED_DISARM, this.disarmChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.disarmChanceLucky) : ""));
        }
        if (this.canIronArm) {
            messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Unarmed.Ability.Bonus.0"), LocaleLoader.getString("Unarmed.Ability.Bonus.1", this.ironArmBonus)));
        }
        if (this.canIronGrip) {
            messages.add(this.getStatMessage(SubSkillType.UNARMED_IRON_GRIP, this.ironGripChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.ironGripChanceLucky) : ""));
        }
        if (Permissions.canUseSubSkill(player, SubSkillType.UNARMED_UNARMED_LIMIT_BREAK)) {
            messages.add(this.getStatMessage(SubSkillType.UNARMED_UNARMED_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.UNARMED_UNARMED_LIMIT_BREAK, 1000))));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.UNARMED);
        return textComponents;
    }
}

