/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.skills.alchemy.AlchemyManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class AlchemyCommand
extends SkillCommand {
    private String brewSpeed;
    private String brewSpeedLucky;
    private int tier;
    private int ingredientCount;
    private String ingredientList;
    private boolean canCatalysis;
    private boolean canConcoctions;

    public AlchemyCommand() {
        super(PrimarySkillType.ALCHEMY);
    }

    protected String[] calculateAbilityDisplayValues(Player player) {
        AlchemyManager alchemyManager = this.mmoPlayer.getAlchemyManager();
        String[] displayValues = new String[2];
        boolean isLucky = Permissions.lucky((Permissible)player, PrimarySkillType.ALCHEMY);
        displayValues[0] = this.decimal.format(alchemyManager.calculateBrewSpeed(false)) + "x";
        displayValues[1] = isLucky ? this.decimal.format(alchemyManager.calculateBrewSpeed(true)) + "x" : null;
        return displayValues;
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canCatalysis) {
            String[] catalysisStrings = this.calculateAbilityDisplayValues(player);
            this.brewSpeed = catalysisStrings[0];
            this.brewSpeedLucky = catalysisStrings[1];
        }
        if (this.canConcoctions) {
            AlchemyManager alchemyManager = this.mmoPlayer.getAlchemyManager();
            this.tier = alchemyManager.getTier();
            this.ingredientCount = alchemyManager.getIngredients().size();
            this.ingredientList = alchemyManager.getIngredientList();
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canCatalysis = Permissions.canUseSubSkill(player, SubSkillType.ALCHEMY_CATALYSIS);
        this.canConcoctions = Permissions.canUseSubSkill(player, SubSkillType.ALCHEMY_CONCOCTIONS);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canCatalysis) {
            messages.add(this.getStatMessage(SubSkillType.ALCHEMY_CATALYSIS, this.brewSpeed) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.brewSpeedLucky) : ""));
        }
        if (this.canConcoctions) {
            messages.add(this.getStatMessage(false, true, SubSkillType.ALCHEMY_CONCOCTIONS, String.valueOf(this.tier), String.valueOf(RankUtils.getHighestRank(SubSkillType.ALCHEMY_CONCOCTIONS))));
            messages.add(this.getStatMessage(true, true, SubSkillType.ALCHEMY_CONCOCTIONS, String.valueOf(this.ingredientCount), this.ingredientList));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.ALCHEMY);
        return textComponents;
    }
}

