/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CrossbowsCommand
extends SkillCommand {
    private boolean canTrickShot;
    private boolean canPoweredShot;

    public CrossbowsCommand() {
        super(PrimarySkillType.CROSSBOWS);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canTrickShot = RankUtils.hasUnlockedSubskill(player, SubSkillType.CROSSBOWS_TRICK_SHOT) && Permissions.trickShot((Permissible)player);
        this.canPoweredShot = RankUtils.hasUnlockedSubskill(player, SubSkillType.CROSSBOWS_POWERED_SHOT) && Permissions.poweredShot((Permissible)player);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.mmoPlayer == null) {
            return messages;
        }
        if (this.canPoweredShot) {
            messages.add(this.getStatMessage(SubSkillType.CROSSBOWS_POWERED_SHOT, this.percent.format(this.mmoPlayer.getCrossbowsManager().getDamageBonusPercent(player))));
        }
        if (this.canTrickShot) {
            messages.add(this.getStatMessage(SubSkillType.CROSSBOWS_TRICK_SHOT, String.valueOf(this.mmoPlayer.getCrossbowsManager().getTrickShotMaxBounceCount())));
        }
        if (Permissions.canUseSubSkill(player, SubSkillType.CROSSBOWS_CROSSBOWS_LIMIT_BREAK)) {
            messages.add(this.getStatMessage(SubSkillType.CROSSBOWS_CROSSBOWS_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.CROSSBOWS_CROSSBOWS_LIMIT_BREAK, 1000))));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.CROSSBOWS);
        return textComponents;
    }
}

