/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills.subskills.acrobatics;

import java.util.Objects;
import org.bukkit.event.entity.EntityDamageEvent;

public class RollResult {
    private final boolean rollSuccess;
    private final boolean isGraceful;
    private final double eventDamage;
    private final double modifiedDamage;
    private final boolean isFatal;
    private final boolean isExploiting;
    private final float xpGain;

    private RollResult(Builder builder) {
        this.rollSuccess = builder.rollSuccess;
        this.isGraceful = builder.isGraceful;
        this.eventDamage = builder.eventDamage;
        this.modifiedDamage = builder.modifiedDamage;
        this.isFatal = builder.isFatal;
        this.isExploiting = builder.isExploiting;
        this.xpGain = builder.xpGain;
    }

    public boolean isRollSuccess() {
        return this.rollSuccess;
    }

    public boolean isGraceful() {
        return this.isGraceful;
    }

    public double getEventDamage() {
        return this.eventDamage;
    }

    public double getModifiedDamage() {
        return this.modifiedDamage;
    }

    public boolean isFatal() {
        return this.isFatal;
    }

    public boolean isExploiting() {
        return this.isExploiting;
    }

    public float getXpGain() {
        return this.xpGain;
    }

    public static class Builder {
        private final boolean isGraceful;
        private final double eventDamage;
        private double modifiedDamage;
        private boolean isFatal;
        private boolean rollSuccess;
        private boolean isExploiting;
        private float xpGain;

        public Builder(EntityDamageEvent entityDamageEvent, boolean isGracefulRoll) {
            Objects.requireNonNull(entityDamageEvent, "EntityDamageEvent cannot be null");
            this.eventDamage = entityDamageEvent.getDamage();
            this.isGraceful = isGracefulRoll;
        }

        public Builder modifiedDamage(double modifiedDamage) {
            this.modifiedDamage = modifiedDamage;
            return this;
        }

        public Builder fatal(boolean isFatal) {
            this.isFatal = isFatal;
            return this;
        }

        public Builder rollSuccess(boolean rollSuccess) {
            this.rollSuccess = rollSuccess;
            return this;
        }

        public Builder exploiting(boolean isExploiting) {
            this.isExploiting = isExploiting;
            return this;
        }

        public Builder xpGain(float xpGain) {
            this.xpGain = xpGain;
            return this;
        }

        public RollResult build() {
            return new RollResult(this);
        }
    }
}

