/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.mcMMO;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.attribute.Attribute;

public class AttributeMapper {
    public static final String ATTRIBUTE = "ATTRIBUTE";
    public static final String ORG_BUKKIT_REGISTRY = "org.bukkit.Registry";
    private static final String MAX_HEALTH_1_21_3_STR = "max_health";
    private static final String MAX_HEALTH_1_18_2_STR = "generic.max_health";
    public static final Attribute MAPPED_MAX_HEALTH = AttributeMapper.findAttribute("max_health", "generic.max_health");
    private static final String JUMP_STRENGTH_1_23_1 = "jump_strength";
    private static final String JUMP_STRENGTH_1_21_1 = "generic.jump_strength";
    private static final String JUMP_STR_1_18_2 = "horse.jump_strength";
    public static final Attribute MAPPED_JUMP_STRENGTH = AttributeMapper.findAttribute("jump_strength", "generic.jump_strength", "horse.jump_strength");
    public static final Attribute MAPPED_MOVEMENT_SPEED = AttributeMapper.findAttribute("generic.movement_speed", "generic.movement_speed", "movement_speed");
    private static final String MOVEMENT_SPEED_1_18_2 = "generic.movement_speed";
    private static final String MOVEMENT_SPEED_1_21_1 = "generic.movement_speed";
    private static final String MOVEMENT_SPEED_1_21_3 = "movement_speed";

    private AttributeMapper() {
    }

    private static Attribute findAttribute(String ... keys) {
        Stream attributeStream;
        try {
            Class<?> registryClass = Class.forName(ORG_BUKKIT_REGISTRY);
            Field attributeField = registryClass.getField(ATTRIBUTE);
            Object attributeRegistry = attributeField.get(null);
            Method streamMethod = attributeRegistry.getClass().getMethod("stream", new Class[0]);
            attributeStream = (Stream)streamMethod.invoke(attributeRegistry, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            T[] enumConstants = Attribute.class.getEnumConstants();
            attributeStream = Arrays.stream(enumConstants);
        }
        Optional<Object> optionalAttribute = attributeStream.filter(attr -> {
            try {
                String attrKey = null;
                String attrName = null;
                Method getKeyMethod = attr.getClass().getMethod("getKey", new Class[0]);
                Object namespacedKey = getKeyMethod.invoke(attr, new Object[0]);
                if (namespacedKey != null) {
                    Method getKeyStringMethod = namespacedKey.getClass().getMethod("getKey", new Class[0]);
                    attrKey = (String)getKeyStringMethod.invoke(namespacedKey, new Object[0]);
                }
                try {
                    Method nameMethod = attr.getClass().getMethod("name", new Class[0]);
                    attrName = (String)nameMethod.invoke(attr, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    attrName = null;
                }
                for (String key : keys) {
                    if ((attrKey == null || !attrKey.equalsIgnoreCase(key)) && (attrName == null || !attrName.equalsIgnoreCase(key))) continue;
                    return true;
                }
            }
            catch (Exception e) {
                mcMMO.p.getLogger().severe("Unable to find the attribute with possible keys: " + Arrays.toString(keys) + ", mcMMO will not function properly.");
                throw new RuntimeException(e);
            }
            return false;
        }).findFirst();
        if (optionalAttribute.isPresent()) {
            return (Attribute)optionalAttribute.get();
        }
        mcMMO.p.getLogger().severe("Unable to find the attribute with possible keys: " + Arrays.toString(keys) + ", mcMMO will not function properly.");
        throw new IllegalStateException("Unable to find the attribute with possible keys: " + Arrays.toString(keys));
    }
}

