/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class SmeltingCommand
extends SkillCommand {
    private String burnTimeModifier;
    private String str_secondSmeltChance;
    private String str_secondSmeltChanceLucky;
    private String str_fluxMiningChance;
    private String str_fluxMiningChanceLucky;
    private boolean canFuelEfficiency;
    private boolean canSecondSmelt;
    private boolean canFluxMine;
    private boolean canUnderstandTheArt;

    public SmeltingCommand() {
        super(PrimarySkillType.SMELTING);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canFuelEfficiency) {
            this.burnTimeModifier = String.valueOf(this.mmoPlayer.getSmeltingManager().getFuelEfficiencyMultiplier());
        }
        if (this.canSecondSmelt) {
            String[] secondSmeltStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.SMELTING_SECOND_SMELT);
            this.str_secondSmeltChance = secondSmeltStrings[0];
            this.str_secondSmeltChanceLucky = secondSmeltStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canFuelEfficiency = Permissions.canUseSubSkill(player, SubSkillType.SMELTING_FUEL_EFFICIENCY);
        this.canSecondSmelt = Permissions.canUseSubSkill(player, SubSkillType.SMELTING_SECOND_SMELT);
        this.canUnderstandTheArt = Permissions.vanillaXpBoost((Permissible)player, this.skill) && RankUtils.hasUnlockedSubskill(player, SubSkillType.SMELTING_UNDERSTANDING_THE_ART);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canFuelEfficiency) {
            messages.add(this.getStatMessage(false, true, SubSkillType.SMELTING_FUEL_EFFICIENCY, this.burnTimeModifier));
        }
        if (this.canSecondSmelt) {
            messages.add(this.getStatMessage(SubSkillType.SMELTING_SECOND_SMELT, this.str_secondSmeltChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.str_secondSmeltChanceLucky) : ""));
        }
        if (this.canUnderstandTheArt) {
            messages.add(this.getStatMessage(false, true, SubSkillType.SMELTING_UNDERSTANDING_THE_ART, String.valueOf(this.mmoPlayer.getSmeltingManager().getVanillaXpMultiplier())));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.SMELTING);
        return textComponents;
    }
}

