/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.party;

import com.gmail.nossr50.commands.party.PartySubcommandType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.text.ConfigStringUtils;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public enum PartyFeature {
    CHAT,
    TELEPORT,
    ALLIANCE,
    ITEM_SHARE,
    XP_SHARE;


    public String getLocaleString() {
        return LocaleLoader.getString("Party.Feature." + ConfigStringUtils.getConfigPartyFeatureString(this));
    }

    public String getFeatureLockedLocaleString() {
        return LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Party.Feature.Locked." + ConfigStringUtils.getConfigPartyFeatureString(this), mcMMO.p.getGeneralConfig().getPartyFeatureUnlockLevel(this)));
    }

    public boolean hasPermission(Player player) {
        PartySubcommandType partySubCommandType;
        switch (this.ordinal()) {
            case 0: {
                partySubCommandType = PartySubcommandType.CHAT;
                break;
            }
            case 1: {
                partySubCommandType = PartySubcommandType.TELEPORT;
                break;
            }
            case 2: {
                partySubCommandType = PartySubcommandType.ALLIANCE;
                break;
            }
            case 3: {
                partySubCommandType = PartySubcommandType.ITEMSHARE;
                break;
            }
            case 4: {
                partySubCommandType = PartySubcommandType.XPSHARE;
                break;
            }
            default: {
                return false;
            }
        }
        return Permissions.partySubcommand((Permissible)player, partySubCommandType);
    }
}

