/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.platform;

import com.gmail.nossr50.util.platform.version.SimpleNumericVersion;
import com.gmail.nossr50.util.platform.version.Versioned;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MajorMinorPatchVersion
implements Versioned {
    @NotNull
    private final SimpleNumericVersion majorVersion;
    @NotNull
    private final SimpleNumericVersion minorVersion;
    @NotNull
    private final SimpleNumericVersion patchVersion;

    public MajorMinorPatchVersion(@NotNull SimpleNumericVersion majorVersion, @NotNull SimpleNumericVersion minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = new SimpleNumericVersion(0);
    }

    public MajorMinorPatchVersion(@NotNull SimpleNumericVersion majorVersion, @NotNull SimpleNumericVersion minorVersion, @Nullable SimpleNumericVersion patchVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = Objects.requireNonNullElseGet(patchVersion, () -> new SimpleNumericVersion(0));
    }

    public MajorMinorPatchVersion(int majorVerNumber, int minorVerNumber, int patchVerNumber) {
        this.majorVersion = new SimpleNumericVersion(majorVerNumber);
        this.minorVersion = new SimpleNumericVersion(minorVerNumber);
        this.patchVersion = new SimpleNumericVersion(patchVerNumber);
    }

    public MajorMinorPatchVersion(int majorVerNumber, int minorVerNumber) {
        this.majorVersion = new SimpleNumericVersion(majorVerNumber);
        this.minorVersion = new SimpleNumericVersion(minorVerNumber);
        this.patchVersion = new SimpleNumericVersion(0);
    }

    @NotNull
    public SimpleNumericVersion getMajorVersion() {
        return this.majorVersion;
    }

    @NotNull
    public SimpleNumericVersion getMinorVersion() {
        return this.minorVersion;
    }

    @NotNull
    public SimpleNumericVersion getPatchVersion() {
        return this.patchVersion;
    }

    @Override
    public String getVersionStr() {
        if (this.isPatch()) {
            return this.majorVersion.getVersionString() + "." + String.valueOf(this.minorVersion) + "." + String.valueOf(this.patchVersion);
        }
        return this.majorVersion.getVersionString() + "." + this.minorVersion.getVersionString();
    }

    public boolean isPatch() {
        return this.patchVersion.asInt() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MajorMinorPatchVersion that = (MajorMinorPatchVersion)o;
        return this.majorVersion.equals(that.majorVersion) && this.minorVersion.equals(that.minorVersion) && this.patchVersion.equals(that.patchVersion);
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.patchVersion);
    }
}

