/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.events.skills.SkillActivationPerkEvent;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;

public final class PerksUtils {
    private static final int LUCKY_SKILL_ACTIVATION_CHANCE = 75;
    private static final int NORMAL_SKILL_ACTIVATION_CHANCE = 100;

    private PerksUtils() {
    }

    public static int handleCooldownPerks(Player player, int cooldown) {
        if (Permissions.halvedCooldowns((Permissible)player)) {
            cooldown = (int)((double)cooldown * 0.5);
        } else if (Permissions.thirdedCooldowns((Permissible)player)) {
            cooldown = (int)((double)cooldown * 0.6666666666666666);
        } else if (Permissions.quarteredCooldowns((Permissible)player)) {
            cooldown = (int)((double)cooldown * 0.75);
        }
        return cooldown;
    }

    public static int handleActivationPerks(Player player, int ticks, int maxTicks) {
        if (maxTicks != 0) {
            ticks = Math.min(ticks, maxTicks);
        }
        if (Permissions.twelveSecondActivationBoost((Permissible)player)) {
            ticks += 12;
        } else if (Permissions.eightSecondActivationBoost((Permissible)player)) {
            ticks += 8;
        } else if (Permissions.fourSecondActivationBoost((Permissible)player)) {
            ticks += 4;
        }
        SkillActivationPerkEvent skillActivationPerkEvent = new SkillActivationPerkEvent(player, ticks, maxTicks);
        Bukkit.getPluginManager().callEvent((Event)skillActivationPerkEvent);
        return skillActivationPerkEvent.getTicks();
    }

    public static float handleXpPerks(Player player, float xp, PrimarySkillType skill) {
        double modifier = 1.0;
        if (Permissions.customXpBoost((Permissible)player, skill)) {
            if (UserManager.getPlayer(player) != null && UserManager.getPlayer(player).isDebugMode()) {
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "[DEBUG] " + String.valueOf(ChatColor.DARK_GRAY) + "XP Perk Multiplier IS CUSTOM! ");
            }
            modifier = ExperienceConfig.getInstance().getCustomXpPerkBoost();
        } else if (Permissions.quadrupleXp((Permissible)player, skill)) {
            modifier = 4.0;
        } else if (Permissions.tripleXp((Permissible)player, skill)) {
            modifier = 3.0;
        } else if (Permissions.doubleAndOneHalfXp((Permissible)player, skill)) {
            modifier = 2.5;
        } else if (Permissions.doubleXp((Permissible)player, skill)) {
            modifier = 2.0;
        } else if (Permissions.oneAndOneHalfXp((Permissible)player, skill)) {
            modifier = 1.5;
        } else if (Permissions.oneAndAQuarterXp((Permissible)player, skill)) {
            modifier = 1.25;
        } else if (Permissions.oneAndOneTenthXp((Permissible)player, skill)) {
            modifier = 1.1;
        }
        float modifiedXP = (float)((double)xp * modifier);
        if (UserManager.getPlayer(player) != null && UserManager.getPlayer(player).isDebugMode()) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "[DEBUG] " + String.valueOf(ChatColor.RESET) + "XP Perk Multiplier - " + String.valueOf(ChatColor.GOLD) + modifier);
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "[DEBUG] " + String.valueOf(ChatColor.RESET) + "Original XP before perk boosts " + String.valueOf(ChatColor.RED) + (double)xp);
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "[DEBUG] " + String.valueOf(ChatColor.RESET) + "XP AFTER PERKS " + String.valueOf(ChatColor.DARK_RED) + modifiedXP);
        }
        return modifiedXP;
    }

    public static int handleLuckyPerks(Player player, PrimarySkillType skill) {
        if (Permissions.lucky((Permissible)player, skill)) {
            return 75;
        }
        return 100;
    }

    public static int handleLuckyPerks(McMMOPlayer mmoPlayer, PrimarySkillType skill) {
        if (Permissions.lucky((Permissible)mmoPlayer.getPlayer(), skill)) {
            return 75;
        }
        return 100;
    }
}

