/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills;

import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.text.StringUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public enum SuperAbilityType {
    EXPLOSIVE_SHOT("Archery.Skills.ExplosiveShot.On", "Archery.Skills.ExplosiveShot.Off", "Archery.Skills.ExplosiveShot.Other.On", "Archery.Skills.ExplosiveShot.Refresh", "Archery.Skills.ExplosiveShot.Other.Off", "Archery.SubSkill.ExplosiveShot.Name"),
    BERSERK("Unarmed.Skills.Berserk.On", "Unarmed.Skills.Berserk.Off", "Unarmed.Skills.Berserk.Other.On", "Unarmed.Skills.Berserk.Refresh", "Unarmed.Skills.Berserk.Other.Off", "Unarmed.SubSkill.Berserk.Name"),
    SUPER_BREAKER("Mining.Skills.SuperBreaker.On", "Mining.Skills.SuperBreaker.Off", "Mining.Skills.SuperBreaker.Other.On", "Mining.Skills.SuperBreaker.Refresh", "Mining.Skills.SuperBreaker.Other.Off", "Mining.SubSkill.SuperBreaker.Name"),
    GIGA_DRILL_BREAKER("Excavation.Skills.GigaDrillBreaker.On", "Excavation.Skills.GigaDrillBreaker.Off", "Excavation.Skills.GigaDrillBreaker.Other.On", "Excavation.Skills.GigaDrillBreaker.Refresh", "Excavation.Skills.GigaDrillBreaker.Other.Off", "Excavation.SubSkill.GigaDrillBreaker.Name"),
    GREEN_TERRA("Herbalism.Skills.GTe.On", "Herbalism.Skills.GTe.Off", "Herbalism.Skills.GTe.Other.On", "Herbalism.Skills.GTe.Refresh", "Herbalism.Skills.GTe.Other.Off", "Herbalism.SubSkill.GreenTerra.Name"),
    SKULL_SPLITTER("Axes.Skills.SS.On", "Axes.Skills.SS.Off", "Axes.Skills.SS.Other.On", "Axes.Skills.SS.Refresh", "Axes.Skills.SS.Other.Off", "Axes.SubSkill.SkullSplitter.Name"),
    TREE_FELLER("Woodcutting.Skills.TreeFeller.On", "Woodcutting.Skills.TreeFeller.Off", "Woodcutting.Skills.TreeFeller.Other.On", "Woodcutting.Skills.TreeFeller.Refresh", "Woodcutting.Skills.TreeFeller.Other.Off", "Woodcutting.SubSkill.TreeFeller.Name"),
    SERRATED_STRIKES("Swords.Skills.SS.On", "Swords.Skills.SS.Off", "Swords.Skills.SS.Other.On", "Swords.Skills.SS.Refresh", "Swords.Skills.SS.Other.Off", "Swords.SubSkill.SerratedStrikes.Name"),
    SUPER_SHOTGUN("Placeholder", "Placeholder", "Placeholder", "Placeholder", "Placeholder", "Placeholder"),
    TRIDENTS_SUPER_ABILITY("Placeholder", "Placeholder", "Placeholder", "Placeholder", "Placeholder", "Placeholder"),
    MACES_SUPER_ABILITY("Placeholder", "Placeholder", "Placeholder", "Placeholder", "Placeholder", "Placeholder"),
    BLAST_MINING(null, null, "Mining.Blast.Other.On", "Mining.Blast.Refresh", null, "Mining.SubSkill.BlastMining.Name");

    private final String abilityOn;
    private final String abilityOff;
    private final String abilityPlayer;
    private final String abilityRefresh;
    private final String abilityPlayerOff;
    private SubSkillType subSkillTypeDefinition;
    private final String localizedName;

    private SuperAbilityType(String abilityOn, String abilityOff, String abilityPlayer, String abilityRefresh, String abilityPlayerOff, String localizedName) {
        this.abilityOn = abilityOn;
        this.abilityOff = abilityOff;
        this.abilityPlayer = abilityPlayer;
        this.abilityRefresh = abilityRefresh;
        this.abilityPlayerOff = abilityPlayerOff;
        this.localizedName = localizedName;
    }

    public int getCooldown() {
        return mcMMO.p.getSkillTools().getSuperAbilityCooldown(this);
    }

    public int getMaxLength() {
        return mcMMO.p.getGeneralConfig().getMaxLength(this);
    }

    public String getAbilityOn() {
        return this.abilityOn;
    }

    public String getAbilityOff() {
        return this.abilityOff;
    }

    public String getAbilityPlayer() {
        return this.abilityPlayer;
    }

    public String getAbilityPlayerOff() {
        return this.abilityPlayerOff;
    }

    public String getAbilityRefresh() {
        return this.abilityRefresh;
    }

    public String getName() {
        return StringUtils.getPrettySuperAbilityString(this);
    }

    public String getLocalizedName() {
        return LocaleLoader.getString(this.localizedName);
    }

    public String toString() {
        String baseString = this.name();
        String[] substrings = baseString.split("_");
        String formattedString = "";
        int size = 1;
        for (String string : substrings) {
            formattedString = formattedString.concat(StringUtils.getCapitalized(string));
            if (size < substrings.length) {
                formattedString = formattedString.concat("_");
            }
            ++size;
        }
        return formattedString;
    }

    public boolean getPermissions(Player player) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> Permissions.berserk((Permissible)player);
            case 11 -> Permissions.remoteDetonation((Permissible)player);
            case 3 -> Permissions.gigaDrillBreaker((Permissible)player);
            case 4 -> Permissions.greenTerra((Permissible)player);
            case 7 -> Permissions.serratedStrikes((Permissible)player);
            case 5 -> Permissions.skullSplitter((Permissible)player);
            case 2 -> Permissions.superBreaker((Permissible)player);
            case 6 -> Permissions.treeFeller((Permissible)player);
            case 0, 8, 9, 10 -> false;
        };
    }

    public boolean blockCheck(@NotNull Block block) {
        return switch (this.ordinal()) {
            case 1 -> {
                if (BlockUtils.affectedByGigaDrillBreaker(block) || block.getType() == Material.SNOW || mcMMO.getMaterialMapStore().isGlass(block.getType())) {
                    yield true;
                }
                yield false;
            }
            case 3 -> BlockUtils.affectedByGigaDrillBreaker(block);
            case 4 -> BlockUtils.canMakeMossy(block);
            case 2 -> BlockUtils.affectedBySuperBreaker(block);
            case 6 -> BlockUtils.hasWoodcuttingXP(block);
            default -> false;
        };
    }

    public SubSkillType getSubSkillTypeDefinition() {
        return this.subSkillTypeDefinition;
    }

    static {
        SuperAbilityType.BERSERK.subSkillTypeDefinition = SubSkillType.UNARMED_BERSERK;
        SuperAbilityType.SUPER_BREAKER.subSkillTypeDefinition = SubSkillType.MINING_SUPER_BREAKER;
        SuperAbilityType.GIGA_DRILL_BREAKER.subSkillTypeDefinition = SubSkillType.EXCAVATION_GIGA_DRILL_BREAKER;
        SuperAbilityType.GREEN_TERRA.subSkillTypeDefinition = SubSkillType.HERBALISM_GREEN_TERRA;
        SuperAbilityType.SKULL_SPLITTER.subSkillTypeDefinition = SubSkillType.AXES_SKULL_SPLITTER;
        SuperAbilityType.TREE_FELLER.subSkillTypeDefinition = SubSkillType.WOODCUTTING_TREE_FELLER;
        SuperAbilityType.SERRATED_STRIKES.subSkillTypeDefinition = SubSkillType.SWORDS_SERRATED_STRIKES;
        SuperAbilityType.BLAST_MINING.subSkillTypeDefinition = SubSkillType.MINING_BLAST_MINING;
    }
}

