/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.BukkitConfig;
import com.gmail.nossr50.metadata.MobMetaFlagType;

public class PersistentDataConfig
extends BukkitConfig {
    private static PersistentDataConfig instance;

    private PersistentDataConfig() {
        super("persistent_data.yml");
        this.validate();
    }

    public static PersistentDataConfig getInstance() {
        if (instance == null) {
            instance = new PersistentDataConfig();
        }
        return instance;
    }

    @Override
    protected void loadKeys() {
    }

    @Override
    protected boolean validateKeys() {
        return true;
    }

    public boolean isMobPersistent(MobMetaFlagType mobMetaFlagType) {
        String key = "Persistent_Data.Mobs.Flags." + mobMetaFlagType.toString() + ".Saved_To_Disk";
        return this.config.getBoolean(key, false);
    }

    public boolean useBlockTracker() {
        return this.config.getBoolean("mcMMO_Region_System.Enabled", true);
    }
}

