/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.events.skills.rupture.McMMOEntityDamageByRuptureEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.AttributeMapper;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.MobHealthbarUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RuptureTask
extends CancellableRunnable {
    public static final int DAMAGE_TICK_INTERVAL = 10;
    public static final int ANIMATION_TICK_INTERVAL = 1;
    @NotNull
    private final McMMOPlayer ruptureSource;
    @NotNull
    private final LivingEntity targetEntity;
    private final int expireTick;
    private int ruptureTick;
    private int damageTickTracker;
    private int animationTick;
    private final double pureTickDamage;
    private int totalTicks = 0;
    private final int totalTickCeiling;

    public RuptureTask(@NotNull McMMOPlayer ruptureSource, @NotNull LivingEntity targetEntity, double pureTickDamage) {
        this.ruptureSource = ruptureSource;
        this.targetEntity = targetEntity;
        this.expireTick = mcMMO.p.getAdvancedConfig().getRuptureDurationSeconds(targetEntity instanceof Player) * 20;
        this.totalTickCeiling = Math.min(this.expireTick, 200);
        this.ruptureTick = 0;
        this.damageTickTracker = 0;
        this.animationTick = 1;
        this.pureTickDamage = pureTickDamage;
    }

    @Deprecated(forRemoval=true, since="2.2.023")
    public RuptureTask(@NotNull McMMOPlayer ruptureSource, @NotNull LivingEntity targetEntity, double pureTickDamage, double ignored) {
        this(ruptureSource, targetEntity, pureTickDamage);
    }

    @Override
    public void run() {
        ++this.totalTicks;
        if (this.totalTicks >= this.totalTickCeiling) {
            this.cancel();
            return;
        }
        if (this.targetEntity.isValid()) {
            ++this.ruptureTick;
            ++this.damageTickTracker;
            if (this.ruptureTick < this.expireTick) {
                if (this.damageTickTracker >= 10) {
                    this.damageTickTracker = 0;
                    if (this.applyRupture()) {
                        return;
                    }
                    this.playAnimation();
                }
            } else {
                if (!this.applyRupture()) {
                    this.playAnimation();
                }
                this.endRupture();
            }
        } else {
            this.cancel();
            this.targetEntity.removeMetadata("mcmmo_rupture", (Plugin)mcMMO.p);
        }
    }

    private void playAnimation() {
        if (this.animationTick >= 1) {
            ParticleEffectUtils.playBleedEffect(this.targetEntity);
            this.animationTick = 0;
        } else {
            ++this.animationTick;
        }
    }

    private boolean applyRupture() {
        double healthBeforeRuptureIsApplied = this.targetEntity.getHealth();
        if (healthBeforeRuptureIsApplied > 0.01) {
            McMMOEntityDamageByRuptureEvent event = new McMMOEntityDamageByRuptureEvent(this.ruptureSource, (Entity)this.targetEntity, this.calculateAdjustedTickDamage());
            mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
            double damage = event.getDamage();
            if (event.isCancelled() || damage <= 0.0 || healthBeforeRuptureIsApplied - damage <= 0.0) {
                return true;
            }
            double damagedHealth = healthBeforeRuptureIsApplied - damage;
            AttributeInstance maxHealthAttribute = this.targetEntity.getAttribute(AttributeMapper.MAPPED_MAX_HEALTH);
            if (maxHealthAttribute == null) {
                mcMMO.p.getLogger().info("RuptureTask: Target entity has an illegal state for its health. Cancelling Rupture. Target has null " + String.valueOf(AttributeMapper.MAPPED_MAX_HEALTH) + " attribute.");
                return true;
            }
            if (damagedHealth > maxHealthAttribute.getValue()) {
                mcMMO.p.getLogger().info("RuptureTask: Target entity has an illegal state for its health. Cancelling Rupture. Target has " + this.targetEntity.getHealth() + " health, but max health is " + maxHealthAttribute.getValue());
                return true;
            }
            this.targetEntity.setHealth(damagedHealth);
            MobHealthbarUtils.handleMobHealthbars(this.targetEntity, damage, mcMMO.p);
        }
        return false;
    }

    public void refreshRupture() {
        this.damageTickTracker = 10;
        this.ruptureTick = 0;
    }

    private void endRupture() {
        this.targetEntity.removeMetadata("mcmmo_rupture", (Plugin)mcMMO.p);
        this.cancel();
    }

    private double calculateAdjustedTickDamage() {
        double tickDamage = this.pureTickDamage;
        if (this.targetEntity.getHealth() <= tickDamage && (tickDamage = this.targetEntity.getHealth() - 0.01) <= 0.0) {
            tickDamage = 0.0;
        }
        return tickDamage;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof RuptureTask)) {
            return false;
        }
        RuptureTask that = (RuptureTask)o;
        return this.ruptureSource.equals(that.ruptureSource) && this.targetEntity.equals((Object)that.targetEntity);
    }

    public int hashCode() {
        int result = this.ruptureSource.hashCode();
        result = 31 * result + this.targetEntity.hashCode();
        return result;
    }

    public String toString() {
        return "RuptureTask{ruptureSource=" + String.valueOf(this.ruptureSource) + ", targetEntity=" + String.valueOf(this.targetEntity) + ", expireTick=" + this.expireTick + ", ruptureTick=" + this.ruptureTick + ", damageTickTracker=" + this.damageTickTracker + ", animationTick=" + this.animationTick + ", pureTickDamage=" + this.pureTickDamage + ", totalTicks=" + this.totalTicks + ", totalTickCeiling=" + this.totalTickCeiling + "}";
    }
}

