/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.util.MetadataService;
import com.gmail.nossr50.util.player.UserManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerMetadataUtils {
    public static void changeContainerOwnership(@Nullable BlockState blockState, @Nullable Player player) {
        if (blockState == null || player == null) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        ContainerMetadataUtils.printOwnershipGainDebug(blockState, mmoPlayer);
        ContainerMetadataUtils.printOwnershipLossDebug(blockState);
        ContainerMetadataUtils.setOwner(blockState, player.getUniqueId());
    }

    public static void printOwnershipGainDebug(@NotNull BlockState blockState, @Nullable McMMOPlayer mmoPlayer) {
        if (mmoPlayer != null && mmoPlayer.isDebugMode()) {
            mmoPlayer.getPlayer().sendMessage("Container ownership " + String.valueOf(ChatColor.GREEN) + "gained " + String.valueOf(ChatColor.RESET) + "at location: " + String.valueOf(blockState.getLocation()));
        }
    }

    public static void printOwnershipLossDebug(BlockState blockState) {
        McMMOPlayer mmoContainerOwner;
        OfflinePlayer containerOwner = ContainerMetadataUtils.getContainerOwner(blockState);
        if (containerOwner != null && containerOwner.isOnline() && (mmoContainerOwner = UserManager.getPlayer(containerOwner.getPlayer())) != null && mmoContainerOwner.isDebugMode()) {
            mmoContainerOwner.getPlayer().sendMessage("Container ownership " + String.valueOf(ChatColor.RED) + "lost " + String.valueOf(ChatColor.RESET) + "at location: " + String.valueOf(blockState.getLocation()));
        }
    }

    @Nullable
    public static OfflinePlayer getContainerOwner(BlockState container) {
        PersistentDataHolder persistentDataHolder;
        UUID uuid;
        if (container instanceof PersistentDataHolder && (uuid = ContainerMetadataUtils.getOwner(persistentDataHolder = (PersistentDataHolder)container)) != null) {
            return Bukkit.getOfflinePlayer((UUID)uuid);
        }
        return null;
    }

    public static boolean isContainerOwned(BlockState blockState) {
        return ContainerMetadataUtils.getContainerOwner(blockState) != null;
    }

    public static void processContainerOwnership(BlockState blockState, Player player) {
        if (blockState == null || player == null) {
            return;
        }
        if (ContainerMetadataUtils.getContainerOwner(blockState) != null && ContainerMetadataUtils.getContainerOwner(blockState).getUniqueId().equals(player.getUniqueId())) {
            return;
        }
        ContainerMetadataUtils.changeContainerOwnership(blockState, player);
    }

    @Nullable
    public static UUID getOwner(@NotNull PersistentDataHolder persistentDataHolder) {
        PersistentDataContainer dataContainer = persistentDataHolder.getPersistentDataContainer();
        Long mostSigBits = (Long)dataContainer.get(MetadataService.NSK_CONTAINER_UUID_MOST_SIG, PersistentDataType.LONG);
        Long leastSigBits = (Long)dataContainer.get(MetadataService.NSK_CONTAINER_UUID_LEAST_SIG, PersistentDataType.LONG);
        if (mostSigBits != null && leastSigBits != null) {
            return new UUID(mostSigBits, leastSigBits);
        }
        return null;
    }

    public static void setOwner(@NotNull BlockState blockState, @NotNull UUID uuid) {
        PersistentDataContainer dataContainer = ((PersistentDataHolder)blockState).getPersistentDataContainer();
        dataContainer.set(MetadataService.NSK_CONTAINER_UUID_MOST_SIG, PersistentDataType.LONG, (Object)uuid.getMostSignificantBits());
        dataContainer.set(MetadataService.NSK_CONTAINER_UUID_LEAST_SIG, PersistentDataType.LONG, (Object)uuid.getLeastSignificantBits());
        blockState.update();
    }
}

