/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.text;

import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    protected static final DecimalFormat percent = new DecimalFormat("##0.00%", DecimalFormatSymbols.getInstance(Locale.US));
    protected static final DecimalFormat shortDecimal = new DecimalFormat("##0.0", DecimalFormatSymbols.getInstance(Locale.US));
    private static final Map<EntityType, String> formattedEntityStrings = new ConcurrentHashMap<EntityType, String>();
    private static final Map<SuperAbilityType, String> formattedSuperAbilityStrings = new ConcurrentHashMap<SuperAbilityType, String>();
    private static final Map<Material, String> formattedMaterialStrings = new ConcurrentHashMap<Material, String>();
    private static final Function<String, String> PRETTY_STRING_FUNC = baseString -> {
        if (baseString.contains("_") && !baseString.contains(" ")) {
            return StringUtils.prettify(baseString.split("_"));
        }
        if (baseString.contains(" ")) {
            return StringUtils.prettify(baseString.split(" "));
        }
        return StringUtils.getCapitalized(baseString);
    };

    public static String getCapitalized(String target) {
        if (target == null || target.isEmpty()) {
            return target;
        }
        return target.substring(0, 1).toUpperCase(Locale.ENGLISH) + target.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String ticksToSeconds(double ticks) {
        return shortDecimal.format(ticks / 20.0);
    }

    public static String getPrettySuperAbilityString(SuperAbilityType superAbilityType) {
        Objects.requireNonNull(superAbilityType, "superAbilityType cannot be null");
        return formattedSuperAbilityStrings.computeIfAbsent(superAbilityType, StringUtils::createPrettyString);
    }

    public static String buildStringAfterNthElement(@NotNull @NotNull String @NotNull [] args, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must be greater than or equal to 0");
        }
        StringBuilder trimMessage = new StringBuilder();
        for (int i = index; i < args.length; ++i) {
            if (i > index) {
                trimMessage.append(' ');
            }
            trimMessage.append(args[i]);
        }
        return trimMessage.toString();
    }

    public static String getPrettyMaterialString(Material material) {
        return formattedMaterialStrings.computeIfAbsent(material, StringUtils::createPrettyString);
    }

    public static String getPrettyEntityTypeString(EntityType entityType) {
        return formattedEntityStrings.computeIfAbsent(entityType, StringUtils::createPrettyString);
    }

    private static String createPrettyString(String baseString) {
        return PRETTY_STRING_FUNC.apply(baseString);
    }

    @NotNull
    private static String prettify(String[] substrings) {
        StringBuilder prettyString = new StringBuilder();
        for (int i = 0; i < substrings.length; ++i) {
            prettyString.append(StringUtils.getCapitalized(substrings[i]));
            if (i >= substrings.length - 1) continue;
            prettyString.append(' ');
        }
        return prettyString.toString();
    }

    private static String createPrettyString(Object object) {
        return StringUtils.createPrettyString(object.toString());
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }
}

