/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.api.exceptions.InvalidFormulaTypeException;
import com.gmail.nossr50.api.exceptions.InvalidPlayerException;
import com.gmail.nossr50.api.exceptions.InvalidSkillException;
import com.gmail.nossr50.api.exceptions.InvalidXPGainReasonException;
import com.gmail.nossr50.api.exceptions.McMMOPlayerNotFoundException;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillTools;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class ExperienceAPI {
    private ExperienceAPI() {
    }

    public static boolean isValidSkillType(@NotNull String skillType) {
        return mcMMO.p.getSkillTools().matchSkill(skillType) != null;
    }

    @Deprecated
    public static void addCombatXP(McMMOPlayer mmoPlayer, LivingEntity target, PrimarySkillType primarySkillType, double multiplier) {
        CombatUtils.processCombatXP(mmoPlayer, target, primarySkillType, multiplier);
    }

    @Deprecated
    public static void addCombatXP(McMMOPlayer mmoPlayer, LivingEntity target, PrimarySkillType primarySkillType) {
        CombatUtils.processCombatXP(mmoPlayer, target, primarySkillType);
    }

    public static boolean isNonChildSkill(String skillType) {
        PrimarySkillType skill = mcMMO.p.getSkillTools().matchSkill(skillType);
        return skill != null && !SkillTools.isChildSkill(skill);
    }

    @Deprecated
    public static void addRawXP(Player player, String skillType, int XP) {
        ExperienceAPI.addRawXP(player, skillType, (float)XP);
    }

    @Deprecated
    public static void addRawXP(Player player, String skillType, float XP) {
        ExperienceAPI.addRawXP(player, skillType, XP, "UNKNOWN");
    }

    public static void addRawXP(Player player, String skillType, float XP, String xpGainReason) {
        ExperienceAPI.addRawXP(player, skillType, XP, xpGainReason, false);
    }

    public static void addRawXP(Player player, String skillType, float XP, String xpGainReason, boolean isUnshared) {
        if (isUnshared) {
            ExperienceAPI.getPlayer(player).beginUnsharedXpGain(ExperienceAPI.getSkillType(skillType), XP, ExperienceAPI.getXPGainReason(xpGainReason), XPGainSource.CUSTOM);
            return;
        }
        ExperienceAPI.getPlayer(player).applyXpGain(ExperienceAPI.getSkillType(skillType), XP, ExperienceAPI.getXPGainReason(xpGainReason), XPGainSource.CUSTOM);
    }

    @Deprecated
    public static void addRawXPOffline(String playerName, String skillType, int XP) {
        ExperienceAPI.addRawXPOffline(playerName, skillType, (float)XP);
    }

    @Deprecated
    public static void addRawXPOffline(String playerName, String skillType, float XP) {
        ExperienceAPI.addOfflineXP(playerName, ExperienceAPI.getSkillType(skillType), (int)Math.floor(XP));
    }

    public static void addRawXPOffline(UUID uuid, String skillType, float XP) {
        ExperienceAPI.addOfflineXP(uuid, ExperienceAPI.getSkillType(skillType), (int)Math.floor(XP));
    }

    @Deprecated
    public static void addMultipliedXP(Player player, String skillType, int XP) {
        ExperienceAPI.addMultipliedXP(player, skillType, XP, "UNKNOWN");
    }

    public static void addMultipliedXP(Player player, String skillType, int XP, String xpGainReason) {
        ExperienceAPI.getPlayer(player).applyXpGain(ExperienceAPI.getSkillType(skillType), (int)((double)XP * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()), ExperienceAPI.getXPGainReason(xpGainReason), XPGainSource.CUSTOM);
    }

    @Deprecated
    public static void addMultipliedXPOffline(String playerName, String skillType, int XP) {
        ExperienceAPI.addOfflineXP(playerName, ExperienceAPI.getSkillType(skillType), (int)((double)XP * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    @Deprecated
    public static void addModifiedXP(Player player, String skillType, int XP) {
        ExperienceAPI.addModifiedXP(player, skillType, XP, "UNKNOWN");
    }

    public static void addModifiedXP(Player player, String skillType, int XP, String xpGainReason) {
        ExperienceAPI.addModifiedXP(player, skillType, XP, xpGainReason, false);
    }

    public static void addModifiedXP(Player player, String skillType, int XP, String xpGainReason, boolean isUnshared) {
        PrimarySkillType skill = ExperienceAPI.getSkillType(skillType);
        ExperienceConfig expConf = ExperienceConfig.getInstance();
        if (isUnshared) {
            ExperienceAPI.getPlayer(player).beginUnsharedXpGain(skill, (int)((double)XP / expConf.getFormulaSkillModifier(skill) * expConf.getExperienceGainsGlobalMultiplier()), ExperienceAPI.getXPGainReason(xpGainReason), XPGainSource.CUSTOM);
            return;
        }
        ExperienceAPI.getPlayer(player).applyXpGain(skill, (int)((double)XP / expConf.getFormulaSkillModifier(skill) * expConf.getExperienceGainsGlobalMultiplier()), ExperienceAPI.getXPGainReason(xpGainReason), XPGainSource.CUSTOM);
    }

    @Deprecated
    public static void addModifiedXPOffline(String playerName, String skillType, int XP) {
        PrimarySkillType skill = ExperienceAPI.getSkillType(skillType);
        ExperienceAPI.addOfflineXP(playerName, skill, (int)((double)XP / ExperienceConfig.getInstance().getFormulaSkillModifier(skill) * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    @Deprecated
    public static void addXP(Player player, String skillType, int XP) {
        ExperienceAPI.addXP(player, skillType, XP, "UNKNOWN");
    }

    public static void addXP(Player player, String skillType, int XP, String xpGainReason) {
        ExperienceAPI.addXP(player, skillType, XP, xpGainReason, false);
    }

    public static void addXP(Player player, String skillType, int XP, String xpGainReason, boolean isUnshared) {
        if (isUnshared) {
            ExperienceAPI.getPlayer(player).beginUnsharedXpGain(ExperienceAPI.getSkillType(skillType), XP, ExperienceAPI.getXPGainReason(xpGainReason), XPGainSource.CUSTOM);
            return;
        }
        ExperienceAPI.getPlayer(player).beginXpGain(ExperienceAPI.getSkillType(skillType), XP, ExperienceAPI.getXPGainReason(xpGainReason), XPGainSource.CUSTOM);
    }

    public static int getXP(Player player, String skillType) {
        return ExperienceAPI.getPlayer(player).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    @Deprecated
    public static int getOfflineXP(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getOfflineXP(UUID uuid, String skillType) {
        return ExperienceAPI.getOfflineProfile(uuid).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getOfflineXP(@NotNull OfflinePlayer offlinePlayer, @NotNull String skillType) throws InvalidPlayerException {
        return ExperienceAPI.getOfflineProfile(offlinePlayer).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static float getXPRaw(Player player, String skillType) {
        return ExperienceAPI.getPlayer(player).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(skillType));
    }

    @Deprecated
    public static float getOfflineXPRaw(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static float getOfflineXPRaw(UUID uuid, String skillType) {
        return ExperienceAPI.getOfflineProfile(uuid).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static float getOfflineXPRaw(@NotNull OfflinePlayer offlinePlayer, @NotNull String skillType) throws InvalidPlayerException, UnsupportedOperationException, InvalidSkillException {
        return ExperienceAPI.getOfflineProfile(offlinePlayer).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static float getOfflineXPRaw(@NotNull OfflinePlayer offlinePlayer, @NotNull PrimarySkillType skillType) throws InvalidPlayerException, UnsupportedOperationException {
        if (SkillTools.isChildSkill(skillType)) {
            throw new UnsupportedOperationException();
        }
        return ExperienceAPI.getOfflineProfile(offlinePlayer).getSkillXpLevelRaw(skillType);
    }

    public static int getXPToNextLevel(Player player, String skillType) {
        return ExperienceAPI.getPlayer(player).getXpToLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    @Deprecated
    public static int getOfflineXPToNextLevel(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getXpToLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getOfflineXPToNextLevel(@NotNull UUID uuid, @NotNull String skillType) {
        return ExperienceAPI.getOfflineProfile(uuid).getXpToLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getOfflineXPToNextLevel(@NotNull OfflinePlayer offlinePlayer, @NotNull String skillType) throws UnsupportedOperationException, InvalidSkillException, InvalidPlayerException {
        return ExperienceAPI.getOfflineProfile(offlinePlayer).getXpToLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getXPRemaining(Player player, String skillType) {
        PrimarySkillType skill = ExperienceAPI.getNonChildSkillType(skillType);
        PlayerProfile profile = ExperienceAPI.getPlayer(player).getProfile();
        return profile.getXpToLevel(skill) - profile.getSkillXpLevel(skill);
    }

    @Deprecated
    public static int getOfflineXPRemaining(String playerName, String skillType) {
        PrimarySkillType skill = ExperienceAPI.getNonChildSkillType(skillType);
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        return profile.getXpToLevel(skill) - profile.getSkillXpLevel(skill);
    }

    public static float getOfflineXPRemaining(UUID uuid, String skillType) {
        PrimarySkillType skill = ExperienceAPI.getNonChildSkillType(skillType);
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(uuid);
        return (float)profile.getXpToLevel(skill) - profile.getSkillXpLevelRaw(skill);
    }

    public static float getOfflineXPRemaining(OfflinePlayer offlinePlayer, String skillType) throws InvalidSkillException, InvalidPlayerException, UnsupportedOperationException {
        PrimarySkillType skill = ExperienceAPI.getNonChildSkillType(skillType);
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(offlinePlayer);
        return (float)profile.getXpToLevel(skill) - profile.getSkillXpLevelRaw(skill);
    }

    public static void addLevel(Player player, String skillType, int levels) {
        ExperienceAPI.getPlayer(player).addLevels(ExperienceAPI.getSkillType(skillType), levels);
    }

    @Deprecated
    public static void addLevelOffline(String playerName, String skillType, int levels) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        PrimarySkillType skill = ExperienceAPI.getSkillType(skillType);
        if (SkillTools.isChildSkill(skill)) {
            ImmutableList<PrimarySkillType> parentSkills = mcMMO.p.getSkillTools().getChildSkillParents(skill);
            for (PrimarySkillType parentSkill : parentSkills) {
                profile.addLevels(parentSkill, levels / parentSkills.size());
            }
            profile.scheduleAsyncSave();
            return;
        }
        profile.addLevels(skill, levels);
        profile.scheduleAsyncSave();
    }

    public static void addLevelOffline(UUID uuid, String skillType, int levels) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(uuid);
        PrimarySkillType skill = ExperienceAPI.getSkillType(skillType);
        if (SkillTools.isChildSkill(skill)) {
            ImmutableList<PrimarySkillType> parentSkills = mcMMO.p.getSkillTools().getChildSkillParents(skill);
            for (PrimarySkillType parentSkill : parentSkills) {
                profile.addLevels(parentSkill, levels / parentSkills.size());
            }
            profile.scheduleAsyncSave();
            return;
        }
        profile.addLevels(skill, levels);
        profile.scheduleAsyncSave();
    }

    @Deprecated
    public static int getLevel(Player player, String skillType) {
        return ExperienceAPI.getPlayer(player).getSkillLevel(ExperienceAPI.getSkillType(skillType));
    }

    public static int getLevel(Player player, PrimarySkillType skillType) {
        return ExperienceAPI.getPlayer(player).getSkillLevel(skillType);
    }

    public static int getLevelOffline(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getSkillLevel(ExperienceAPI.getSkillType(skillType));
    }

    public static int getLevelOffline(UUID uuid, String skillType) {
        return ExperienceAPI.getOfflineProfile(uuid).getSkillLevel(ExperienceAPI.getSkillType(skillType));
    }

    public static int getPowerLevel(Player player) {
        return ExperienceAPI.getPlayer(player).getPowerLevel();
    }

    @Deprecated
    public static int getPowerLevelOffline(String playerName) {
        int powerLevel = 0;
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        for (PrimarySkillType type : SkillTools.NON_CHILD_SKILLS) {
            powerLevel += profile.getSkillLevel(type);
        }
        return powerLevel;
    }

    public static int getPowerLevelOffline(UUID uuid) {
        int powerLevel = 0;
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(uuid);
        for (PrimarySkillType type : SkillTools.NON_CHILD_SKILLS) {
            powerLevel += profile.getSkillLevel(type);
        }
        return powerLevel;
    }

    public static int getLevelCap(String skillType) {
        return mcMMO.p.getSkillTools().getLevelCap(ExperienceAPI.getSkillType(skillType));
    }

    public static int getPowerLevelCap() {
        return mcMMO.p.getGeneralConfig().getPowerLevelCap();
    }

    @Deprecated
    public static int getPlayerRankSkill(String playerName, String skillType) {
        return mcMMO.getDatabaseManager().readRank(mcMMO.p.getServer().getOfflinePlayer(playerName).getName()).get((Object)ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getPlayerRankSkill(UUID uuid, String skillType) {
        return mcMMO.getDatabaseManager().readRank(mcMMO.p.getServer().getOfflinePlayer(uuid).getName()).get((Object)ExperienceAPI.getNonChildSkillType(skillType));
    }

    @Deprecated
    public static int getPlayerRankOverall(String playerName) {
        return mcMMO.getDatabaseManager().readRank(mcMMO.p.getServer().getOfflinePlayer(playerName).getName()).get(null);
    }

    public static int getPlayerRankOverall(UUID uuid) {
        return mcMMO.getDatabaseManager().readRank(mcMMO.p.getServer().getOfflinePlayer(uuid).getName()).get(null);
    }

    public static void setLevel(Player player, String skillType, int skillLevel) {
        ExperienceAPI.getPlayer(player).modifySkill(ExperienceAPI.getSkillType(skillType), skillLevel);
    }

    @Deprecated
    public static void setLevelOffline(String playerName, String skillType, int skillLevel) {
        ExperienceAPI.getOfflineProfile(playerName).modifySkill(ExperienceAPI.getSkillType(skillType), skillLevel);
    }

    public static void setLevelOffline(UUID uuid, String skillType, int skillLevel) {
        ExperienceAPI.getOfflineProfile(uuid).modifySkill(ExperienceAPI.getSkillType(skillType), skillLevel);
    }

    public static void setXP(Player player, String skillType, int newValue) {
        ExperienceAPI.getPlayer(player).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType), newValue);
    }

    @Deprecated
    public static void setXPOffline(String playerName, String skillType, int newValue) {
        ExperienceAPI.getOfflineProfile(playerName).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType), newValue);
    }

    public static void setXPOffline(UUID uuid, String skillType, int newValue) {
        ExperienceAPI.getOfflineProfile(uuid).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType), newValue);
    }

    public static void removeXP(Player player, String skillType, int xp) {
        ExperienceAPI.getPlayer(player).removeXp(ExperienceAPI.getNonChildSkillType(skillType), xp);
    }

    @Deprecated
    public static void removeXPOffline(String playerName, String skillType, int xp) {
        ExperienceAPI.getOfflineProfile(playerName).removeXp(ExperienceAPI.getNonChildSkillType(skillType), xp);
    }

    public static void removeXPOffline(UUID uuid, String skillType, int xp) {
        ExperienceAPI.getOfflineProfile(uuid).removeXp(ExperienceAPI.getNonChildSkillType(skillType), xp);
    }

    public static int getXpNeededToLevel(int level) {
        return mcMMO.getFormulaManager().getXPtoNextLevel(level, ExperienceConfig.getInstance().getFormulaType());
    }

    public static int getXpNeededToLevel(int level, String formulaType) {
        return mcMMO.getFormulaManager().getXPtoNextLevel(level, ExperienceAPI.getFormulaType(formulaType));
    }

    public static void addXpFromBlocks(ArrayList<BlockState> blockStates, McMMOPlayer mmoPlayer) {
        for (BlockState bs : blockStates) {
            for (PrimarySkillType skillType : PrimarySkillType.values()) {
                if (ExperienceConfig.getInstance().getXp(skillType, bs.getType()) <= 0) continue;
                mmoPlayer.applyXpGain(skillType, ExperienceConfig.getInstance().getXp(skillType, bs.getType()), XPGainReason.PVE, XPGainSource.SELF);
            }
        }
    }

    public static void addXpFromBlocksBySkill(ArrayList<BlockState> blockStates, McMMOPlayer mmoPlayer, PrimarySkillType skillType) {
        for (BlockState bs : blockStates) {
            if (ExperienceConfig.getInstance().getXp(skillType, bs.getType()) <= 0) continue;
            mmoPlayer.applyXpGain(skillType, ExperienceConfig.getInstance().getXp(skillType, bs.getType()), XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    public static void addXpFromBlock(BlockState blockState, McMMOPlayer mmoPlayer) {
        for (PrimarySkillType skillType : PrimarySkillType.values()) {
            if (ExperienceConfig.getInstance().getXp(skillType, blockState.getType()) <= 0) continue;
            mmoPlayer.applyXpGain(skillType, ExperienceConfig.getInstance().getXp(skillType, blockState.getType()), XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    public static void addXpFromBlockBySkill(BlockState blockState, McMMOPlayer mmoPlayer, PrimarySkillType skillType) {
        if (ExperienceConfig.getInstance().getXp(skillType, blockState.getType()) > 0) {
            mmoPlayer.applyXpGain(skillType, ExperienceConfig.getInstance().getXp(skillType, blockState.getType()), XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    private static void addOfflineXP(@NotNull UUID playerUniqueId, @NotNull PrimarySkillType skill, int XP) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerUniqueId);
        profile.addXp(skill, XP);
        profile.save(true);
    }

    private static void addOfflineXP(@NotNull String playerName, @NotNull PrimarySkillType skill, int XP) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        profile.addXp(skill, XP);
        profile.scheduleAsyncSave();
    }

    @NotNull
    private static PlayerProfile getOfflineProfile(@NotNull UUID uuid) throws InvalidPlayerException {
        PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(uuid);
        if (!profile.isLoaded()) {
            throw new InvalidPlayerException();
        }
        return profile;
    }

    @NotNull
    private static PlayerProfile getOfflineProfile(@NotNull OfflinePlayer offlinePlayer) throws InvalidPlayerException {
        PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(offlinePlayer);
        if (!profile.isLoaded()) {
            throw new InvalidPlayerException();
        }
        return profile;
    }

    @NotNull
    private static PlayerProfile getOfflineProfile(@NotNull String playerName) throws InvalidPlayerException {
        PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(playerName);
        if (!profile.isLoaded()) {
            throw new InvalidPlayerException();
        }
        return profile;
    }

    private static PrimarySkillType getSkillType(String skillType) throws InvalidSkillException {
        PrimarySkillType skill = mcMMO.p.getSkillTools().matchSkill(skillType);
        if (skill == null) {
            throw new InvalidSkillException();
        }
        return skill;
    }

    private static PrimarySkillType getNonChildSkillType(String skillType) throws InvalidSkillException, UnsupportedOperationException {
        PrimarySkillType skill = ExperienceAPI.getSkillType(skillType);
        if (SkillTools.isChildSkill(skill)) {
            throw new UnsupportedOperationException("Child skills do not have XP");
        }
        return skill;
    }

    private static XPGainReason getXPGainReason(String reason) throws InvalidXPGainReasonException {
        XPGainReason xpGainReason = XPGainReason.getXPGainReason(reason);
        if (xpGainReason == null) {
            throw new InvalidXPGainReasonException();
        }
        return xpGainReason;
    }

    private static FormulaType getFormulaType(String formula) throws InvalidFormulaTypeException {
        FormulaType formulaType = FormulaType.getFormulaType(formula);
        if (formulaType == null) {
            throw new InvalidFormulaTypeException();
        }
        return formulaType;
    }

    @Deprecated(forRemoval=true)
    private static McMMOPlayer getPlayer(Player player) throws McMMOPlayerNotFoundException {
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            throw new McMMOPlayerNotFoundException(player);
        }
        return UserManager.getPlayer(player);
    }
}

