/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.events.experience;

import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

public abstract class McMMOPlayerExperienceEvent
extends PlayerEvent
implements Cancellable {
    private boolean cancelled;
    protected PrimarySkillType skill;
    protected int skillLevel;
    protected XPGainReason xpGainReason;
    private static final HandlerList handlers = new HandlerList();

    @Deprecated
    protected McMMOPlayerExperienceEvent(Player player, PrimarySkillType skill) {
        super(player);
        this.skill = skill;
        this.skillLevel = UserManager.getPlayer(player).getSkillLevel(skill);
        this.xpGainReason = XPGainReason.UNKNOWN;
    }

    protected McMMOPlayerExperienceEvent(Player player, PrimarySkillType skill, XPGainReason xpGainReason) {
        super(player);
        this.skill = skill;
        this.skillLevel = UserManager.getPlayer(player) != null ? UserManager.getPlayer(player).getSkillLevel(skill) : 0;
        this.xpGainReason = xpGainReason;
    }

    public PrimarySkillType getSkill() {
        return this.skill;
    }

    public int getSkillLevel() {
        return this.skillLevel;
    }

    public XPGainReason getXpGainReason() {
        return this.xpGainReason;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

