/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.MetadataConstants;
import com.gmail.nossr50.util.MobMetadataUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class TransientMetadataTools {
    private final mcMMO pluginRef;

    public TransientMetadataTools(@NotNull mcMMO pluginRef) {
        this.pluginRef = pluginRef;
    }

    public void cleanLivingEntityMetadata(@NotNull LivingEntity entity) {
        if (entity.hasMetadata("mcmmo_custom_name")) {
            entity.setCustomName(((MetadataValue)entity.getMetadata("mcmmo_custom_name").get(0)).asString());
            entity.removeMetadata("mcmmo_custom_name", (Plugin)this.pluginRef);
        }
        if (entity.hasMetadata("mcMMO: Name Visibility")) {
            entity.setCustomNameVisible(((MetadataValue)entity.getMetadata("mcMMO: Name Visibility").get(0)).asBoolean());
            entity.removeMetadata("mcMMO: Name Visibility", (Plugin)this.pluginRef);
        }
        if (entity.hasMetadata("mcMMO: Traveling Block")) {
            entity.removeMetadata("mcMMO: Traveling Block", (Plugin)this.pluginRef);
        }
        MobMetadataUtils.removeMobFlags(entity);
        for (String key : MetadataConstants.MOB_METADATA_KEYS) {
            if (!entity.hasMetadata(key)) continue;
            entity.removeMetadata(key, (Plugin)this.pluginRef);
        }
    }
}

