/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.nms;

import com.gmail.nossr50.util.nms.NMSVersion;
import org.jetbrains.annotations.Nullable;

public class NMSConstants {
    public static final String BUKKIT_PACKAGE_PATH = "org.bukkit";
    public static final String CRAFT_BUKKIT_PACKAGE_PATH = "org.bukkit.craftbukkit";
    public static final String NET_MINECRAFT_SERVER = "net.minecraft.server";
    private static final String CRAFT_PLAYER_CLASS_PATH = "entity.CraftPlayer";
    private static final String ENTITY_HUMAN_CLASS_PATH = "EntityHuman";

    protected static String getFullyQualifiedCraftBukkitPath(String cbVersionPackage, String targetClass) {
        return "org.bukkit.craftbukkit." + cbVersionPackage + "." + targetClass;
    }

    protected static String getFullQualifiedBukkitPath(String fromSourceRoot) {
        return "org.bukkit." + fromSourceRoot;
    }

    protected static String getFullyQualifiedNMSPath(String cbVersionPackage, String fromSourceRoot) {
        return "net.minecraft.server." + cbVersionPackage + "." + fromSourceRoot;
    }

    public static String getCraftPlayerClassPath(String cbVersionPackage) {
        return NMSConstants.getFullyQualifiedCraftBukkitPath(cbVersionPackage, CRAFT_PLAYER_CLASS_PATH);
    }

    public static String getEntityHumanClassPath(String cbVersionPackage) {
        return NMSConstants.getFullyQualifiedNMSPath(cbVersionPackage, ENTITY_HUMAN_CLASS_PATH);
    }

    @Nullable
    public static String getCraftBukkitVersionPath(NMSVersion nmsVersion) {
        switch (nmsVersion) {
            case NMS_1_8_8: {
                break;
            }
            case NMS_1_12_2: {
                return "v1_12_R1";
            }
            case NMS_1_13_2: {
                return "v1_13_R2";
            }
            case NMS_1_14_4: {
                return "v1_14_R1";
            }
            case NMS_1_15_2: {
                return "v1_15_R1";
            }
            case NMS_1_16_1: {
                return "v1_16_R1";
            }
            case NMS_1_16_4: {
                return "v1_16_R3";
            }
        }
        return null;
    }
}

