/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.datatypes.skills.subskills.interfaces.InteractType;
import com.gmail.nossr50.datatypes.skills.subskills.interfaces.Interaction;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.bukkit.event.Event;

public class InteractionManager {
    private static HashMap<InteractType, ArrayList<Interaction>> interactRegister;
    private static HashMap<String, AbstractSubSkill> subSkillNameMap;
    private static ArrayList<AbstractSubSkill> subSkillList;

    public static void initMaps() {
        if (interactRegister == null) {
            interactRegister = new HashMap();
        }
        if (subSkillList == null) {
            subSkillList = new ArrayList();
        }
        if (subSkillNameMap == null) {
            subSkillNameMap = new HashMap();
        }
    }

    public static void registerSubSkill(AbstractSubSkill abstractSubSkill) {
        if (!subSkillList.contains(abstractSubSkill)) {
            subSkillList.add(abstractSubSkill);
        }
        interactRegister.computeIfAbsent(abstractSubSkill.getInteractType(), k -> new ArrayList());
        ArrayList<Interaction> arrayRef = interactRegister.get((Object)abstractSubSkill.getInteractType());
        arrayRef.add(abstractSubSkill);
        String lowerCaseName = abstractSubSkill.getConfigKeyName().toLowerCase(Locale.ENGLISH);
        subSkillNameMap.putIfAbsent(lowerCaseName, abstractSubSkill);
        LogUtils.debug(mcMMO.p.getLogger(), "Registered subskill: " + abstractSubSkill.getConfigKeyName());
    }

    public static AbstractSubSkill getAbstractByName(String name) {
        return subSkillNameMap.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static void processEvent(Event event, mcMMO plugin, InteractType curInteractType) {
        if (interactRegister.get((Object)curInteractType) == null) {
            return;
        }
        for (Interaction interaction : interactRegister.get((Object)curInteractType)) {
            interaction.doInteraction(event, plugin);
        }
    }

    public static ArrayList<AbstractSubSkill> getSubSkillList() {
        return subSkillList;
    }

    public static boolean hasSubSkill(String name) {
        return InteractionManager.getAbstractByName(name) != null;
    }

    public static boolean hasSubSkill(SubSkillType subSkillType) {
        return InteractionManager.hasSubSkill(subSkillType.getNiceNameNoSpaces(subSkillType));
    }

    public static HashMap<InteractType, ArrayList<Interaction>> getInteractRegister() {
        return interactRegister;
    }
}

