/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.api.exceptions.IncompleteNamespacedKeyRegister;
import com.gmail.nossr50.config.PersistentDataConfig;
import com.gmail.nossr50.metadata.MobMetaFlagType;
import com.gmail.nossr50.util.MetadataService;
import com.google.common.collect.MapMaker;
import java.util.EnumMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class MobMetadataUtils {
    @NotNull
    private static final ConcurrentMap<Entity, Set<MobMetaFlagType>> mobRegistry;
    @NotNull
    private static final EnumMap<MobMetaFlagType, NamespacedKey> mobFlagKeyMap;
    private static boolean isUsingPersistentData;

    private MobMetadataUtils() {
    }

    private static void initMobFlagKeyMap() throws IncompleteNamespacedKeyRegister {
        block9: for (MobMetaFlagType mobMetaFlagType : MobMetaFlagType.values()) {
            switch (mobMetaFlagType) {
                case MOB_SPAWNER_MOB: {
                    mobFlagKeyMap.put(mobMetaFlagType, MetadataService.NSK_MOB_SPAWNER_MOB);
                    continue block9;
                }
                case EGG_MOB: {
                    mobFlagKeyMap.put(mobMetaFlagType, MetadataService.NSK_EGG_MOB);
                    continue block9;
                }
                case NETHER_PORTAL_MOB: {
                    mobFlagKeyMap.put(mobMetaFlagType, MetadataService.NSK_NETHER_GATE_MOB);
                    continue block9;
                }
                case COTW_SUMMONED_MOB: {
                    mobFlagKeyMap.put(mobMetaFlagType, MetadataService.NSK_COTW_SUMMONED_MOB);
                    continue block9;
                }
                case PLAYER_BRED_MOB: {
                    mobFlagKeyMap.put(mobMetaFlagType, MetadataService.NSK_PLAYER_BRED_MOB);
                    continue block9;
                }
                case EXPLOITED_ENDERMEN: {
                    mobFlagKeyMap.put(mobMetaFlagType, MetadataService.NSK_EXPLOITED_ENDERMEN);
                    continue block9;
                }
                case PLAYER_TAMED_MOB: {
                    mobFlagKeyMap.put(mobMetaFlagType, MetadataService.NSK_PLAYER_TAMED_MOB);
                    continue block9;
                }
                default: {
                    throw new IncompleteNamespacedKeyRegister("Missing namespaced key register for type: " + String.valueOf((Object)mobMetaFlagType));
                }
            }
        }
    }

    public static boolean hasMobFlag(@NotNull MobMetaFlagType flag, @NotNull LivingEntity livingEntity) {
        if (PersistentDataConfig.getInstance().isMobPersistent(flag)) {
            return livingEntity.getPersistentDataContainer().has(mobFlagKeyMap.get((Object)flag), PersistentDataType.BYTE);
        }
        Set flags = (Set)mobRegistry.get(livingEntity);
        return flags != null && flags.contains((Object)flag);
    }

    public static boolean hasMobFlags(@NotNull LivingEntity livingEntity) {
        if (isUsingPersistentData) {
            for (MobMetaFlagType metaFlagType : MobMetaFlagType.values()) {
                if (!MobMetadataUtils.hasMobFlag(metaFlagType, livingEntity)) continue;
                return true;
            }
            return false;
        }
        Set flags = (Set)mobRegistry.get(livingEntity);
        return flags != null && !flags.isEmpty();
    }

    public static void addMobFlags(@NotNull LivingEntity sourceEntity, @NotNull LivingEntity targetEntity) {
        if (!MobMetadataUtils.hasMobFlags(sourceEntity)) {
            return;
        }
        if (isUsingPersistentData) {
            for (MobMetaFlagType flag : MobMetaFlagType.values()) {
                if (!MobMetadataUtils.hasMobFlag(flag, sourceEntity)) continue;
                MobMetadataUtils.flagMetadata(flag, targetEntity);
            }
        } else {
            Set sourceFlags = (Set)mobRegistry.get(sourceEntity);
            if (sourceFlags != null) {
                Set targetFlags = mobRegistry.computeIfAbsent((Entity)targetEntity, k -> ConcurrentHashMap.newKeySet());
                targetFlags.addAll(sourceFlags);
            }
        }
    }

    public static void flagMetadata(@NotNull MobMetaFlagType flag, @NotNull LivingEntity livingEntity) {
        if (PersistentDataConfig.getInstance().isMobPersistent(flag)) {
            if (!MobMetadataUtils.hasMobFlag(flag, livingEntity)) {
                PersistentDataContainer persistentDataContainer = livingEntity.getPersistentDataContainer();
                persistentDataContainer.set(mobFlagKeyMap.get((Object)flag), PersistentDataType.BYTE, (Object)1);
            }
        } else {
            Set flags = mobRegistry.computeIfAbsent((Entity)livingEntity, k -> ConcurrentHashMap.newKeySet());
            flags.add(flag);
        }
    }

    public static void removeMobFlag(@NotNull MobMetaFlagType flag, @NotNull LivingEntity livingEntity) {
        if (PersistentDataConfig.getInstance().isMobPersistent(flag)) {
            if (MobMetadataUtils.hasMobFlag(flag, livingEntity)) {
                PersistentDataContainer persistentDataContainer = livingEntity.getPersistentDataContainer();
                persistentDataContainer.remove(mobFlagKeyMap.get((Object)flag));
            }
        } else {
            Set flags = (Set)mobRegistry.get(livingEntity);
            if (flags != null) {
                flags.remove((Object)flag);
                if (flags.isEmpty()) {
                    mobRegistry.remove(livingEntity, flags);
                }
            }
        }
    }

    public static void removeMobFlags(@NotNull LivingEntity livingEntity) {
        if (isUsingPersistentData) {
            for (MobMetaFlagType flag : MobMetaFlagType.values()) {
                MobMetadataUtils.removeMobFlag(flag, livingEntity);
            }
        } else {
            mobRegistry.remove(livingEntity);
        }
    }

    static {
        isUsingPersistentData = false;
        mobFlagKeyMap = new EnumMap(MobMetaFlagType.class);
        mobRegistry = new MapMaker().weakKeys().concurrencyLevel(4).makeMap();
        MobMetadataUtils.initMobFlagKeyMap();
        for (MobMetaFlagType metaFlagType : MobMetaFlagType.values()) {
            if (!PersistentDataConfig.getInstance().isMobPersistent(metaFlagType)) continue;
            isUsingPersistentData = true;
            break;
        }
    }
}

