/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.random;

import com.gmail.nossr50.util.random.ProbabilityImpl;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.NotNull;

public interface Probability {
    public static final Probability ALWAYS_FAILS = () -> 0.0;
    public static final Probability ALWAYS_SUCCEEDS = () -> 1.0;

    @NotNull
    public static Probability ofPercent(double percentage) {
        if (percentage < 0.0) {
            throw new IllegalArgumentException("Value should never be negative for Probability! This suggests a coding mistake, contact the devs!");
        }
        double probabilityValue = percentage / 100.0;
        return new ProbabilityImpl(probabilityValue);
    }

    @NotNull
    public static Probability ofValue(double value) {
        return new ProbabilityImpl(value);
    }

    private static boolean isSuccessfulRoll(double probabilityValue) {
        return probabilityValue >= ThreadLocalRandom.current().nextDouble(1.0);
    }

    public double getValue();

    default public boolean evaluate() {
        return Probability.isSuccessfulRoll(this.getValue());
    }

    default public boolean evaluate(double probabilityMultiplier) {
        double probabilityValue = this.getValue() * probabilityMultiplier;
        return Probability.isSuccessfulRoll(probabilityValue);
    }

    default public boolean evaluate(double probabilityMultiplier, double finalProbabilityMultiplier) {
        double probabilityValue = this.getValue() * probabilityMultiplier;
        return Probability.isSuccessfulRoll(probabilityValue * finalProbabilityMultiplier);
    }
}

