/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.treasure;

import com.gmail.nossr50.config.BukkitConfig;
import com.gmail.nossr50.datatypes.treasure.ExcavationTreasure;
import com.gmail.nossr50.datatypes.treasure.HylianTreasure;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.PotionUtil;
import com.gmail.nossr50.util.text.ConfigStringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class TreasureConfig
extends BukkitConfig {
    public static final String FILENAME = "treasures.yml";
    public static final String LEVEL_REQUIREMENT_RETRO_MODE = ".Level_Requirement.Retro_Mode";
    public static final String LEVEL_REQUIREMENT_STANDARD_MODE = ".Level_Requirement.Standard_Mode";
    public static final String WRONG_KEY_VALUE_STANDARD = ".Drop_Level.Standard_Mode";
    public static final String WRONG_KEY_VALUE_RETRO = ".Drop_Level.Retro_Mode";
    public static final String LEGACY_DROP_LEVEL = ".Drop_Level";
    public static final String WRONG_KEY_ROOT = ".Drop_Level";
    private static TreasureConfig instance;
    public HashMap<String, List<ExcavationTreasure>> excavationMap = new HashMap();
    public HashMap<String, List<HylianTreasure>> hylianMap = new HashMap();

    private TreasureConfig() {
        super(FILENAME, false);
        this.loadKeys();
        this.validate();
    }

    public static TreasureConfig getInstance() {
        if (instance == null) {
            instance = new TreasureConfig();
        }
        return instance;
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> reason = new ArrayList<String>();
        return this.noErrorsInConfig(reason);
    }

    @Override
    protected void loadKeys() {
        if (this.config.getConfigurationSection("Treasures") != null) {
            this.backup();
            return;
        }
        this.loadTreasures("Excavation");
        this.loadTreasures("Hylian_Luck");
    }

    private void loadTreasures(String type) {
        boolean shouldWeUpdateFile = false;
        boolean isExcavation = type.equals("Excavation");
        boolean isHylian = type.equals("Hylian_Luck");
        ConfigurationSection treasureSection = this.config.getConfigurationSection(type);
        if (treasureSection == null) {
            return;
        }
        for (String treasureName : treasureSection.getKeys(false)) {
            List dropList;
            short data;
            ArrayList<String> reason = new ArrayList<String>();
            String[] treasureInfo = treasureName.split("[|]");
            String materialName = treasureInfo[0];
            Material material = Material.matchMaterial((String)materialName);
            int amount = this.config.getInt(type + "." + treasureName + ".Amount");
            short s = data = treasureInfo.length == 2 ? Short.parseShort(treasureInfo[1]) : (short)this.config.getInt(type + "." + treasureName + ".Data");
            if (material == null) {
                LogUtils.debug(mcMMO.p.getLogger(), String.format("Material '%s' for treasure '%s' is not recognized. Skipping...", materialName, treasureName));
                continue;
            }
            if (amount <= 0) {
                amount = 1;
            }
            if (material != null && material.isBlock() && (data > 127 || data < -128)) {
                reason.add("Data of " + treasureName + " is invalid! " + data);
            }
            int xp = this.config.getInt(type + "." + treasureName + ".XP");
            double dropChance = this.config.getDouble(type + "." + treasureName + ".Drop_Chance");
            if (this.getWrongKeyValue(type, treasureName, DropLevelKeyConversionType.LEGACY) != -1) {
                shouldWeUpdateFile = this.processAutomaticKeyConversion(type, shouldWeUpdateFile, treasureName, DropLevelKeyConversionType.LEGACY);
            }
            if (this.getWrongKeyValue(type, treasureName, DropLevelKeyConversionType.WRONG_KEY_STANDARD) != -1) {
                shouldWeUpdateFile = this.processAutomaticKeyConversion(type, shouldWeUpdateFile, treasureName, DropLevelKeyConversionType.WRONG_KEY_STANDARD);
            }
            if (this.getWrongKeyValue(type, treasureName, DropLevelKeyConversionType.WRONG_KEY_RETRO) != -1) {
                shouldWeUpdateFile = this.processAutomaticKeyConversion(type, shouldWeUpdateFile, treasureName, DropLevelKeyConversionType.WRONG_KEY_RETRO);
            }
            int dropLevel = -1;
            dropLevel = mcMMO.isRetroModeEnabled() ? this.config.getInt(type + "." + treasureName + LEVEL_REQUIREMENT_RETRO_MODE, -1) : this.config.getInt(type + "." + treasureName + LEVEL_REQUIREMENT_STANDARD_MODE, -1);
            if (dropLevel == -1) {
                mcMMO.p.getLogger().severe("Could not find a Level_Requirement entry for treasure " + treasureName);
                mcMMO.p.getLogger().severe("Skipping treasure");
                continue;
            }
            if (xp < 0) {
                reason.add(treasureName + " has an invalid XP value: " + xp);
            }
            if (dropChance < 0.0) {
                reason.add(treasureName + " has an invalid Drop_Chance: " + dropChance);
            }
            ItemStack item = null;
            if (materialName.contains("POTION")) {
                boolean upgraded;
                boolean extended;
                Material mat = Material.matchMaterial((String)materialName);
                if (mat == null) {
                    reason.add("Potion format for treasures.yml has changed");
                    continue;
                }
                item = new ItemStack(mat, amount, data);
                PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
                if (potionMeta == null) {
                    mcMMO.p.getLogger().severe("Item meta when adding potion to treasure was null, contact the mcMMO devs!");
                    reason.add("Item meta when adding potion to treasure was null, contact the mcMMO devs!");
                    continue;
                }
                String potionTypeStr = this.config.getString(type + "." + treasureName + ".PotionData.PotionType", "WATER");
                PotionType potionType = PotionUtil.matchPotionType(potionTypeStr, extended = this.config.getBoolean(type + "." + treasureName + ".PotionData.Extended", false), upgraded = this.config.getBoolean(type + "." + treasureName + ".PotionData.Upgraded", false));
                if (potionType == null) {
                    reason.add("Could not derive potion type from: " + potionTypeStr + ", " + extended + ", " + upgraded);
                    continue;
                }
                PotionUtil.setBasePotionType(potionMeta, potionType, extended, upgraded);
                if (this.config.contains(type + "." + treasureName + ".Custom_Name")) {
                    potionMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(type + "." + treasureName + ".Custom_Name")));
                }
                if (this.config.contains(type + "." + treasureName + ".Lore")) {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String s2 : this.config.getStringList(type + "." + treasureName + ".Lore")) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s2));
                    }
                    potionMeta.setLore(lore);
                }
                item.setItemMeta((ItemMeta)potionMeta);
            } else if (material != null) {
                ItemMeta itemMeta;
                item = new ItemStack(material, amount, data);
                if (this.config.contains(type + "." + treasureName + ".Custom_Name")) {
                    itemMeta = item.getItemMeta();
                    itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(type + "." + treasureName + ".Custom_Name")));
                    item.setItemMeta(itemMeta);
                }
                if (this.config.contains(type + "." + treasureName + ".Lore")) {
                    itemMeta = item.getItemMeta();
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String s3 : this.config.getStringList(type + "." + treasureName + ".Lore")) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s3));
                    }
                    itemMeta.setLore(lore);
                    item.setItemMeta(itemMeta);
                }
            }
            if (!this.noErrorsInConfig(reason)) continue;
            if (isExcavation) {
                ExcavationTreasure excavationTreasure = new ExcavationTreasure(item, xp, dropChance, dropLevel);
                dropList = this.config.getStringList(type + "." + treasureName + ".Drops_From");
                for (String blockType : dropList) {
                    if (!this.excavationMap.containsKey(blockType)) {
                        this.excavationMap.put(blockType, new ArrayList());
                    }
                    this.excavationMap.get(blockType).add(excavationTreasure);
                }
                continue;
            }
            if (!isHylian) continue;
            HylianTreasure hylianTreasure = new HylianTreasure(item, xp, dropChance, dropLevel);
            dropList = this.config.getStringList(type + "." + treasureName + ".Drops_From");
            for (String dropper : dropList) {
                if (dropper.equals("Bushes")) {
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.FERN), hylianTreasure);
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(BlockUtils.getShortGrass()), hylianTreasure);
                    for (Material species : Tag.SAPLINGS.getValues()) {
                        this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(species), hylianTreasure);
                    }
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.DEAD_BUSH), hylianTreasure);
                    continue;
                }
                if (dropper.equals("Flowers")) {
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.POPPY), hylianTreasure);
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.DANDELION), hylianTreasure);
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.BLUE_ORCHID), hylianTreasure);
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.ALLIUM), hylianTreasure);
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.AZURE_BLUET), hylianTreasure);
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.ORANGE_TULIP), hylianTreasure);
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.PINK_TULIP), hylianTreasure);
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.RED_TULIP), hylianTreasure);
                    this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(Material.WHITE_TULIP), hylianTreasure);
                    continue;
                }
                if (dropper.equals("Pots")) {
                    for (Material species : Tag.FLOWER_POTS.getValues()) {
                        this.AddHylianTreasure(ConfigStringUtils.getMaterialConfigString(species), hylianTreasure);
                    }
                    continue;
                }
                this.AddHylianTreasure(dropper, hylianTreasure);
            }
        }
        if (shouldWeUpdateFile) {
            try {
                this.config.save(this.getFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean processAutomaticKeyConversion(String type, boolean shouldWeUpdateTheFile, String treasureName, DropLevelKeyConversionType conversionType) {
        switch (conversionType.ordinal()) {
            case 0: {
                int legacyDropLevel = this.getWrongKeyValue(type, treasureName, conversionType);
                LogUtils.debug(mcMMO.p.getLogger(), "(" + treasureName + ") [Fixing bad address: Legacy] Converting Drop_Level to Level_Requirement in treasures.yml for treasure to match new expected format");
                this.config.set(type + "." + treasureName + ".Drop_Level", null);
                this.config.set(type + "." + treasureName + LEVEL_REQUIREMENT_RETRO_MODE, (Object)(legacyDropLevel * 10));
                this.config.set(type + "." + treasureName + LEVEL_REQUIREMENT_STANDARD_MODE, (Object)legacyDropLevel);
                shouldWeUpdateTheFile = true;
                break;
            }
            case 1: {
                LogUtils.debug(mcMMO.p.getLogger(), "(" + treasureName + ") [Fixing bad address: STANDARD] Converting Drop_Level to Level_Requirement in treasures.yml for treasure to match new expected format");
                int wrongKeyValueStandard = this.getWrongKeyValue(type, treasureName, conversionType);
                this.config.set(type + "." + treasureName + ".Drop_Level", null);
                if (wrongKeyValueStandard != -1) {
                    this.config.set(type + "." + treasureName + LEVEL_REQUIREMENT_STANDARD_MODE, (Object)wrongKeyValueStandard);
                    this.config.set(type + "." + treasureName + LEVEL_REQUIREMENT_RETRO_MODE, (Object)(wrongKeyValueStandard * 10));
                }
                shouldWeUpdateTheFile = true;
                break;
            }
            case 2: {
                LogUtils.debug(mcMMO.p.getLogger(), "(" + treasureName + ") [Fixing bad address: RETRO] Converting Drop_Level to Level_Requirement in treasures.yml for treasure to match new expected format");
                int wrongKeyValueRetro = this.getWrongKeyValue(type, treasureName, conversionType);
                this.config.set(type + "." + treasureName + ".Drop_Level", null);
                if (wrongKeyValueRetro != -1) {
                    this.config.set(type + "." + treasureName + LEVEL_REQUIREMENT_RETRO_MODE, (Object)wrongKeyValueRetro);
                }
                shouldWeUpdateTheFile = true;
            }
        }
        return shouldWeUpdateTheFile;
    }

    private int getWrongKeyValue(String type, String treasureName, DropLevelKeyConversionType dropLevelKeyConversionType) {
        return switch (dropLevelKeyConversionType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.config.getInt(type + "." + treasureName + ".Drop_Level", -1);
            case 1 -> this.config.getInt(type + "." + treasureName + WRONG_KEY_VALUE_STANDARD, -1);
            case 2 -> this.config.getInt(type + "." + treasureName + WRONG_KEY_VALUE_RETRO, -1);
        };
    }

    private void AddHylianTreasure(String dropper, HylianTreasure treasure) {
        if (!this.hylianMap.containsKey(dropper)) {
            this.hylianMap.put(dropper, new ArrayList());
        }
        this.hylianMap.get(dropper).add(treasure);
    }

    private static enum DropLevelKeyConversionType {
        LEGACY,
        WRONG_KEY_STANDARD,
        WRONG_KEY_RETRO;

    }
}

